/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ResolveNotUniqueNamesErrorHandler
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResolveNotUniqueNamesErrorHandler.class);

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parentShell = ShellProvider.getAnyShellParent();
        Controller controller = Controller.getInstance();
        List instances = (List)controller.getProfile().getFunctionalGroups().stream().flatMap(group -> group.getInstances().values().stream()).filter(i -> i.getNotUniqueNameError() != null).collect(CollectorsUtils.toList());
        if (instances.isEmpty()) {
            MessageDialog.openInformation((Shell)parentShell, (String)Messages.get().ResolveNotUniqueNamesErrorHandler_NoErrorsDialog_Title, (String)Messages.get().ResolveNotUniqueNamesErrorHandler_NoErrorsDialog_Description);
            return null;
        }
        List names = (List)instances.stream().map(IChild::getUiName).collect(CollectorsUtils.toList());
        String joinedNames = UtilsText.join((Collection)names, (String)", ");
        boolean result = MessageDialog.openQuestion((Shell)parentShell, (String)Messages.get().ResolveNotUniqueNamesErrorHandler_QuestionDialog_Title, (String)MessageFormat.format(Messages.get().ResolveNotUniqueNamesErrorHandler_QuestionDialog_Description, joinedNames));
        if (!result) {
            return null;
        }
        controller.runTransaction(() -> {
            for (IComponentInstanceConfig instance : instances) {
                IFunctionalGroup functionalGroup = instance.getChildContext().getFunctionalGroup();
                if (functionalGroup == null) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Component instance \"{0}\" does not have functional group", instance.getUUID());
                    continue;
                }
                String newName = controller.createInstanceName(APeriphController.getAutomaticName((IComponentInstanceConfig)instance), functionalGroup);
                controller.renameComponentInstance(instance, newName, ResolveNotUniqueNamesErrorHandler.class, true);
            }
        });
        return null;
    }
}

