/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.datacollection.core;

import com.nxp.s32ds.ext.rcp.datacollection.core.internal.DataCollectionCoreActivator;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class DataCollections {
    private static final String EMPTY_STRING = "";
    private static boolean isTestMode = false;

    public static void sendEventCollectProduct(String activationId, String product, String version) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("product", product);
        data.put("activationId", activationId);
        data.put("version", version);
        DataCollections.sendEvent("s32ds/data/collection/head", data);
    }

    public static void sendEventCollectHardware(String family, String device, String deviceCore) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("hardware.family", family);
        data.put("hardware.device", device);
        data.put("hardware.deviceCore", deviceCore);
        DataCollections.sendEvent("s32ds/data/collection/hardware", data);
    }

    public static void sendEventCollectDebugger(String id, String name, String device, String deviceCore) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("debugger.id", id);
        data.put("debugger.name", name);
        data.put("hardware.device", device);
        data.put("hardware.deviceCore", deviceCore);
        DataCollections.sendEvent("s32ds/data/collection/debugger", data);
    }

    public static void sendEventCollectDebugger(String id, String name, String device) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("debugger.id", id);
        data.put("debugger.name", name);
        data.put("hardware.device", device);
        DataCollections.sendEvent("s32ds/data/collection/debugger", data);
    }

    public static void sendEventCollectSdk(String id, String name, String version, String device, String core) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sdk.id", id);
        data.put("sdk.name", name);
        data.put("sdk.version", version);
        data.put("hardware.device", device);
        data.put("hardware.core", core);
        DataCollections.sendEvent("s32ds/data/collection/sdk", data);
    }

    public static void sendEventCollectToolChain(String id, String name, String device, String core) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("toolchain.id", id);
        data.put("toolchain.name", name);
        data.put("hardware.device", device);
        data.put("hardware.core", core);
        DataCollections.sendEvent("s32ds/data/collection/toolchain", data);
    }

    public static void sendEventCollectToolOption(String id, String value, String device, String core) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tool.option.id", id);
        data.put("tool.option.value", value);
        data.put("hardware.device", device);
        data.put("hardware.core", core);
        DataCollections.sendEvent("s32ds/data/collection/tooloption", data);
    }

    public static void sendEventConfigureService(String enabled, String logLocation, String host) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s32ds.datacollection.enable", enabled);
        data.put("s32ds.datacollection.log.location", logLocation);
        data.put("s32ds.datacollection.host", host);
        DataCollections.sendEvent("s32ds/data/collection/configuration", data);
    }

    public static void sendEventCollectMIAction(String action, String id, String name, String version) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("mi.action", action);
        data.put("mi.unit.id", id);
        data.put("mi.unit.name", name);
        data.put("mi.unit.version", version);
        DataCollections.sendEvent("s32ds/data/collection/mi", data);
    }

    public static void sendEventCollectExamples(String id, String name, String family, String device, String core, String sdkId, String sdkName, String sdkVersion) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("example.id", id);
        data.put("example.name", name);
        data.put("hardware.family", family);
        data.put("hardware.device", device);
        data.put("hardware.core", core);
        if (sdkId != null && !sdkId.isEmpty()) {
            data.put("example.sdk.id", sdkId);
            data.put("example.sdk.name", sdkName);
            data.put("example.sdk.version", sdkVersion);
        }
        DataCollections.sendEvent("s32ds/data/collection/example", data);
    }

    public static void sendEventCollectExamples(String id, String name, String family, String device, String core) {
        DataCollections.sendEventCollectExamples(id, name, family, device, core, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
    }

    public static void sendEvent(String topic, Map<String, String> data) {
        EventAdmin adminService = DataCollections.getService();
        if (adminService == null) {
            DataCollectionCoreActivator.getInstance().logError("Data Collection Service can not be reached");
            return;
        }
        Event event = new Event(topic, data);
        if (isTestMode) {
            adminService.sendEvent(event);
        } else {
            adminService.postEvent(event);
        }
    }

    private static EventAdmin getService() {
        return DataCollectionCoreActivator.getInstance().getService();
    }

    public static void setTestMode(boolean mode) {
        isTestMode = mode;
    }
}

