/*
 * Decompiled with CFR 0.152.
 */
package animations.swt;

import animations.swt.EaseSelector;
import animations.swt.ICallback;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.callback.TimelineCallbackAdapter;

public abstract class ChangerBase
implements ICallback {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int red;
    protected int green;
    protected int blue;
    protected int alpha;
    protected int topIndex;
    protected Control control;
    protected ScrolledComposite scrolledComposite;
    protected Shell shell;
    protected Grid grid;
    protected Display display;
    protected EaseSelector easeSelector;
    protected TimelineCallbackAdapter callBack = new TimelineCallbackAdapter(){

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            if (newState == Timeline.TimelineState.PLAYING_FORWARD) {
                ChangerBase.this.display.asyncExec(() -> ChangerBase.this.animationStartCallback());
            } else if (newState == Timeline.TimelineState.DONE) {
                ChangerBase.this.display.asyncExec(() -> ChangerBase.this.animationDoneCallback());
            }
        }
    };

    protected ChangerBase(Control control, EaseSelector easeSelector) {
        this.control = control;
        this.display = control.getDisplay();
        this.x = control.getBounds().x;
        this.y = control.getBounds().y;
        this.width = control.getBounds().width;
        this.height = control.getBounds().height;
        this.red = control.getBackground().getRed();
        this.green = control.getBackground().getGreen();
        this.blue = control.getBackground().getBlue();
        this.easeSelector = easeSelector;
    }

    protected ChangerBase(ScrolledComposite scrolledComposite, EaseSelector easeSelector) {
        this.scrolledComposite = scrolledComposite;
        this.display = scrolledComposite.getDisplay();
        this.x = scrolledComposite.getOrigin().x;
        this.y = scrolledComposite.getOrigin().y;
        this.easeSelector = easeSelector;
    }

    protected ChangerBase(Shell shell, EaseSelector easeSelector) {
        this.shell = shell;
        this.display = shell.getDisplay();
        this.alpha = shell.getAlpha();
        this.easeSelector = easeSelector;
    }

    protected ChangerBase(Grid grid, EaseSelector easeSelector) {
        this.grid = grid;
        this.display = grid.getDisplay();
        this.topIndex = grid.getTopIndex();
        this.easeSelector = easeSelector;
    }

    @Override
    public void animationDoneCallback() {
    }

    @Override
    public void animationStartCallback() {
    }

    public abstract void initPropertySetter();

    public abstract void play(int var1);
}

