/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model;

import com.nxp.s32ds.cle.runtime.migration.condition.MigrationCondition;
import com.nxp.s32ds.cle.runtime.migration.condition.MigrationConditionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.EvaluationDiagnosticFactory;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.ast.BooleanExpression;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.reflection.MigrationReflectionSupport;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperties;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class Condition
implements BooleanExpression {
    private final MigrationConditionDescriptor descriptor;
    private final List<MigrationProperty> properties;
    private final MigrationCondition condition;

    public Condition(MigrationConditionDescriptor descriptor, List<MigrationProperty> properties) throws MigrationReflectionSupport.MigrationReflectionException {
        this.descriptor = descriptor;
        this.properties = properties;
        this.condition = (MigrationCondition)MigrationReflectionSupport.initialize(descriptor.getConditionClass(), descriptor.getDocumentation(), properties);
    }

    public MigrationProperties getProperties() {
        return new MigrationProperties(this.properties);
    }

    @Override
    public boolean evaluate(IProject project, MigrationDiagnostic diagnostic) {
        return EvaluationDiagnosticFactory.evaluate(EvaluationDiagnosticFactory.createConditionDiagnostic(diagnostic, this), d -> this.condition.match(project));
    }

    public MigrationConditionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        String prop = new MigrationProperties(this.properties).toString();
        return "Condition id=" + this.descriptor.getId() + (prop.isEmpty() ? "" : "\n" + prop);
    }
}

