/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.datacollection;

import com.nxp.s32ds.ext.rcp.datacollection.ArbitrageProcessor;
import com.nxp.s32ds.ext.rcp.datacollection.transfer.TransferService;
import com.nxp.s32ds.ext.rcp.datacollection.transfer.TransferServiceProcessor;
import com.nxp.s32ds.ext.rcp.internal.datacollection.ArbitrageService;
import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.osgi.util.NLS;

public class TransferServiceImpl
implements TransferService,
ArbitrageProcessor {
    private static final String TARGET_FOLDER = "/datacollection/zip/";
    private static final String PROTOCOL = "Http://";
    private static final String TRANSFERED_DIR = String.valueOf(File.separator) + "transfered" + File.separator;
    private static final String ZIPPED_DIR = String.valueOf(File.separator) + "zipped" + File.separator;
    private static final String DASH = "-";
    private static final String EXTENSION_JSON = ".json";
    private static final String EXTENSION_ZIP = ".zip";
    private static final int ONE_HOUR_IN_MILLS = 3600000;
    private long scheduleSeconds;
    private String logFilePath;
    private String address;
    private Path logFileDir;
    private Path sendDir;
    private Path zipDirOld;
    private String machineId;
    private boolean isEnable = false;
    private TransferServiceProcessor processor;
    private ArbitrageService arbitrage = ArbitrageService.getDataCollectionArbitr();

    @Override
    public void setLocation(String location) {
        Path path = Paths.get(location, new String[0]);
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            this.logFilePath = path.toString();
        } else {
            String msg = NLS.bind((String)Messages.TransferService_error_file_does_not_exist, (Object)path);
            DataCollectionActivator.getInstance().logError(msg);
        }
    }

    @Override
    public void setHost(String host) {
        this.address = PROTOCOL + host + TARGET_FOLDER;
    }

    @Override
    public void setTimer(long scheduleSeconds) {
        this.scheduleSeconds = scheduleSeconds;
    }

    @Override
    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    @Override
    public void init() {
        this.processor = new TransferServiceProcessor();
        this.logFileDir = Paths.get(this.logFilePath, new String[0]).getParent();
        this.sendDir = Paths.get(this.logFileDir + ZIPPED_DIR, new String[0]);
        if (!Files.exists(this.sendDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.sendDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                DataCollectionActivator.getInstance().logError(NLS.bind((String)Messages.TransferService_error_dir_cannot_be_created, (Object)this.sendDir), e);
            }
        }
        this.zipDirOld = Paths.get(this.logFileDir + TRANSFERED_DIR, new String[0]);
        if (!Files.exists(this.zipDirOld, new LinkOption[0])) {
            try {
                Files.createDirectory(this.zipDirOld, new FileAttribute[0]);
            }
            catch (IOException e) {
                DataCollectionActivator.getInstance().logError(NLS.bind((String)Messages.TransferService_error_zip_cannot_be_send, (Object)this.zipDirOld), e);
            }
        }
        Thread senderService = new Thread("Transfer to remote host collected product usages data"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (!TransferServiceImpl.this.isEnable) {
                                Thread.sleep(3600000L);
                                continue;
                            }
                            TransferServiceImpl.this.sendCollectedData();
                            Thread.sleep(TransferServiceImpl.this.scheduleSeconds * 1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        DataCollectionActivator.getInstance().logError(e.getMessage(), e);
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        };
        senderService.start();
    }

    @Override
    public void setEnable(boolean enable) {
        this.isEnable = enable;
    }

    @Override
    public void sendCollectedData() {
        Path path = Paths.get(this.logFilePath, new String[0]);
        try {
            if (Files.size(path) != 0L) {
                this.arbitrage.startProcess(this, path);
            }
            this.processor.ifExists(this.sendDir, this.filterByExtension(EXTENSION_JSON), this::packToZip).foreach(this.sendDir, this.filterByExtension(EXTENSION_ZIP), this::sendZip);
        }
        catch (IOException e) {
            DataCollectionActivator.getInstance().logError(e.getMessage(), e);
        }
    }

    private void sendZip(Path zipFile) {
        try {
            URI uri = new URI(this.address);
            HttpRequest request = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofFile(zipFile)).header("Content-Type", "application/zip").build();
            HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
            Files.move(zipFile, Paths.get(this.zipDirOld + File.separator + zipFile.getFileName().toString(), new String[0]), new CopyOption[0]);
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.TransferService_error_zip_cannot_be_send, (Object)e.getMessage());
            DataCollectionActivator.getInstance().logError(msg, e);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.TransferService_error_zip_cannot_be_send, (Object)e.getMessage());
            DataCollectionActivator.getInstance().logError(msg, e);
        }
        catch (InterruptedException e) {
            String msg = NLS.bind((String)Messages.TransferService_error_zip_cannot_be_send, (Object)e.getMessage());
            DataCollectionActivator.getInstance().logError(msg, e);
            Thread.currentThread().interrupt();
        }
    }

    private void packToZip() {
        try {
            Path zipFile = Files.createFile(this.getPathWithMachineIdAndTime(EXTENSION_ZIP), new FileAttribute[0]);
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
                this.processor.foreach(this.sendDir, this.filterByExtension(EXTENSION_JSON), path -> {
                    String string = this.sendDir.relativize((Path)path).toString();
                    ZipEntry zipEntry = new ZipEntry(string);
                    try {
                        zs.putNextEntry(zipEntry);
                        Files.copy(path, zs);
                        zs.closeEntry();
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        DataCollectionActivator.getInstance().logError(e.getMessage(), e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DataCollectionActivator.getInstance().logError(Messages.TransferService_error_file_cannot_be_created, e);
        }
    }

    private Path getPathWithMachineIdAndTime(String ext) {
        return Paths.get(this.sendDir + File.separator + this.machineId + DASH + System.currentTimeMillis() + ext, new String[0]);
    }

    private Predicate<Path> filterByExtension(String ext) {
        return path -> path.getFileName().toString().endsWith(ext);
    }

    @Override
    public void processUnderArbitrage() {
        try {
            Path path = Paths.get(this.logFilePath, new String[0]);
            Files.move(path, this.getPathWithMachineIdAndTime(EXTENSION_JSON), new CopyOption[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            DataCollectionActivator.getInstance().logError(Messages.TransferService_error_file_cannot_be_moved, e);
        }
    }
}

