/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.datacollection.utils;

import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class MachineIdUtil {
    private static final String MACHINE_UUID_FILE_NAME = ".machine_uuid";
    private static final String UUID_PREFIX = "UUID";
    private static final String WIN_GET_UUID_COMMAND = "wmic csproduct get UUID";
    private static final String LINUX_GET_UUID_COMMAND = "cat /etc/machine-id";
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-f]+");

    private MachineIdUtil() {
    }

    public static String getMachineId(String logLocation) {
        try {
            Path path = Paths.get(logLocation, new String[0]).getParent().resolve(Paths.get(MACHINE_UUID_FILE_NAME, new String[0]));
            String id = MachineIdUtil.getMachineUUIDFromFile(path);
            if (!id.isEmpty()) {
                return id;
            }
            id = MachineIdUtil.getOriginalMachineId();
            Matcher matcher = HEX_PATTERN.matcher(id);
            if (matcher.matches()) {
                MachineIdUtil.saveMachineId(id, path);
                return id;
            }
            DataCollectionActivator.getInstance().logWarning(NLS.bind((String)Messages.MachineIdUtil_generating_random_machine_id, (Object)path.toString()));
            id = MachineIdUtil.genearteMachineId();
            if (matcher.matches()) {
                MachineIdUtil.saveMachineId(id, path);
                return id;
            }
        }
        catch (IOException ex) {
            DataCollectionActivator.getInstance().logError(ex.getMessage(), ex);
        }
        DataCollectionActivator.getInstance().logWarning(Messages.MachineIdUtil_cannot_create_machine_id);
        return "";
    }

    private static void saveMachineId(String id, Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        Files.writeString(path, (CharSequence)id, StandardOpenOption.CREATE);
    }

    private static String getMachineUUIDFromFile(Path path) throws IOException {
        String id;
        Matcher matcher;
        if (Files.exists(path, new LinkOption[0]) && (matcher = HEX_PATTERN.matcher(id = Files.readString(path))).matches()) {
            return id;
        }
        return "";
    }

    public static String genearteMachineId() throws IOException {
        String id = MachineIdUtil.formatUUID(UUID.randomUUID().toString());
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOriginalMachineId() throws IOException {
        String command = Platform.getOS().equals("win32") ? WIN_GET_UUID_COMMAND : LINUX_GET_UUID_COMMAND;
        Process process = Runtime.getRuntime().exec(command);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String readLine = null;
            do {
                if ((readLine = reader.readLine()) != null) continue;
                return "";
            } while (readLine.startsWith(UUID_PREFIX) || readLine.isBlank());
            return MachineIdUtil.formatUUID(readLine);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static String formatUUID(String id) {
        return id.trim().replace("-", "").toLowerCase();
    }
}

