/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public final class CoreASTProvider {
    private static CoreASTProvider instance = new CoreASTProvider();
    public static final String DEBUG_PREFIX = "ASTProvider > ";
    private volatile ITypeRoot fReconcilingJavaElement;
    private ITypeRoot fActiveJavaElement;
    private CompilationUnit fAST;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private volatile boolean fIsReconciling;
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnit getAST(ITypeRoot input, WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        ITypeRoot activeElement;
        Object object;
        boolean isActiveElement;
        if (input == null) throw new IllegalArgumentException("input or wait flag are null");
        if (waitFlag == null) {
            throw new IllegalArgumentException("input or wait flag are null");
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        CoreASTProvider coreASTProvider = this;
        synchronized (coreASTProvider) {
            isActiveElement = input.equals(this.fActiveJavaElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!JavaManipulationPlugin.DEBUG_AST_PROVIDER) return this.fAST;
                    System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
                if (waitFlag == WAIT_NO) {
                    if (!JavaManipulationPlugin.DEBUG_AST_PROVIDER) return null;
                    System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + input.getElementName());
                    return null;
                }
            }
        }
        boolean canReturnNull = waitFlag == WAIT_NO || waitFlag == WAIT_ACTIVE_ONLY && (!isActiveElement || this.fAST != null);
        boolean isReconciling = false;
        if (isActiveElement) {
            object = this.fReconcileLock;
            synchronized (object) {
                activeElement = this.fReconcilingJavaElement;
                isReconciling = this.isReconciling(input);
                if (!isReconciling && !canReturnNull) {
                    this.aboutToBeReconciled(input);
                }
            }
        } else {
            activeElement = null;
        }
        if (isReconciling) {
            try {
                object = this.fWaitLock;
                synchronized (object) {
                    if (this.isReconciling(input)) {
                        if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
                            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + input.getElementName());
                        }
                        this.fWaitLock.wait(30000L);
                    }
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveJavaElement) return this.getAST(input, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(input, waitFlag, progressMonitor);
                    if (!JavaManipulationPlugin.DEBUG_AST_PROVIDER) return this.fAST;
                    System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST: " + this.toString(this.fAST) + " for: " + input.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (canReturnNull) {
            return null;
        }
        CompilationUnit ast = null;
        try {
            ast = CoreASTProvider.createAST(input, progressMonitor);
            if (progressMonitor == null) return ast;
            if (!progressMonitor.isCanceled()) return ast;
            ast = null;
            if (!JavaManipulationPlugin.DEBUG_AST_PROVIDER) return ast;
            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for: " + input.getElementName() + " - operation has been cancelled");
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
                        System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + input.getElementName() + " - AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, input, null);
                    return this.fAST;
                }
                this.reconciled(ast, input, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToBeReconciled(ITypeRoot javaElement) {
        if (javaElement == null) {
            return;
        }
        if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(javaElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fReconcilingJavaElement = javaElement;
            this.fIsReconciling = true;
        }
        this.cache(null, javaElement);
    }

    private static CompilationUnit createAST(final ITypeRoot input, final IProgressMonitor progressMonitor) {
        if (!CoreASTProvider.hasSource(input)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final ASTParser parser = ASTParser.newParser((int)16);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setSource(input);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final CompilationUnit[] root = new CompilationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        return;
                    }
                    if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
                        System.err.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + CoreASTProvider.DEBUG_PREFIX + "creating AST for: " + input.getElementName());
                    }
                    root[0] = (CompilationUnit)parser.createAST(progressMonitor);
                    ASTNodes.setFlagsToAST((ASTNode)root[0], 4);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.core.manipulation", 0, "Error in JDT Core during AST creation", ex);
                Platform.getLog(CoreASTProvider.class).log((IStatus)status);
            }
        });
        return root[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(CompilationUnit ast, ITypeRoot javaElement, IProgressMonitor progressMonitor) {
        if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString(ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
            if (javaElement == null || !javaElement.equals(this.fReconcilingJavaElement)) {
                if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
                    System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, javaElement);
        }
    }

    private boolean isReconciling(ITypeRoot javaElement) {
        return javaElement != null && javaElement.equals(this.fReconcilingJavaElement) && this.fIsReconciling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cache(CompilationUnit ast, ITypeRoot javaElement) {
        if (this.fActiveJavaElement != null && !this.fActiveJavaElement.equals(javaElement)) {
            if (JavaManipulationPlugin.DEBUG_AST_PROVIDER && javaElement != null) {
                System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(javaElement));
            }
            return;
        }
        if (JavaManipulationPlugin.DEBUG_AST_PROVIDER && (javaElement != null || ast != null)) {
            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString(ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    private static boolean hasSource(ITypeRoot je) {
        if (je == null || !je.exists()) {
            return false;
        }
        try {
            return je.getBuffer() != null;
        }
        catch (JavaModelException ex) {
            Status status = new Status(4, "org.eclipse.jdt.core.manipulation", 0, "Error in JDT Core during AST creation", (Throwable)ex);
            Platform.getLog(CoreASTProvider.class).log((IStatus)status);
            return false;
        }
    }

    public synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (JavaManipulationPlugin.DEBUG_AST_PROVIDER) {
            System.out.println(String.valueOf(CoreASTProvider.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString(this.fAST) + " for: " + this.toString(this.fActiveJavaElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    public String toString(ITypeRoot javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(CompilationUnit ast) {
        if (ast == null) {
            return "null";
        }
        List types = ast.types();
        if (types != null && types.size() > 0) {
            return String.valueOf(((AbstractTypeDeclaration)types.get(0)).getName().getIdentifier()) + "(" + ast.hashCode() + ")";
        }
        return "AST without any type";
    }

    public static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    public static CoreASTProvider getInstance() {
        return instance;
    }

    private CoreASTProvider() {
    }

    public boolean isReconciling() {
        return this.fIsReconciling;
    }

    public ITypeRoot getReconcilingJavaElement() {
        return this.fReconcilingJavaElement;
    }

    public ITypeRoot getActiveJavaElement() {
        return this.fActiveJavaElement;
    }

    public void setActiveJavaElement(ITypeRoot activeJavaElement) {
        this.fActiveJavaElement = activeJavaElement;
    }

    public CompilationUnit getCachedAST() {
        return this.fAST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLockNotifyAll() {
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReconciliation() {
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
            this.fReconcilingJavaElement = null;
        }
    }

    public static final class WAIT_FLAG {
        private String fName;

        private WAIT_FLAG(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

