/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class PlatformUITestHarness
implements ITestHarness {
    private TestableObject fTestableObject;
    private final boolean fRunTestsInSeparateThread;

    public PlatformUITestHarness(Object testableObject, boolean runTestsInSeparateThread) {
        this.fRunTestsInSeparateThread = runTestsInSeparateThread;
        this.fTestableObject = (TestableObject)testableObject;
        this.fTestableObject.setTestHarness((ITestHarness)this);
    }

    public void runTests() {
        try {
            this.fTestableObject.testingStarting();
            Runnable testsRunner = () -> RemotePluginTestRunner.main(Platform.getCommandLineArgs());
            if (this.fRunTestsInSeparateThread) {
                Thread testRunnerThread = new Thread(testsRunner, "Plug-in Tests Runner");
                this.fTestableObject.runTest(() -> testRunnerThread.start());
                try {
                    testRunnerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.fTestableObject.runTest(testsRunner);
            }
        }
        finally {
            this.fTestableObject.testingFinished();
        }
    }
}

