/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui;

import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseCoreActivator;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseService;
import com.nxp.s32ds.rcp.license.core.LicenseStatus;
import com.nxp.s32ds.rcp.license.ui.ActivateWindow;
import com.nxp.s32ds.rcp.license.ui.DetailsWindow;
import com.nxp.s32ds.rcp.license.ui.ExpectedFeature;
import com.nxp.s32ds.rcp.license.ui.LicenseUIActivator;
import com.nxp.s32ds.rcp.license.ui.Messages;
import com.nxp.s32ds.rcp.license.ui.internal.ExpectedLicenses;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class LicenseWindow
extends TitleAreaDialog {
    private Table m_table;
    private Button btnActivate;
    private Button btnDetails;

    private LicenseWindow() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : null);
        this.setShellStyle(0x10CF0 | LicenseWindow.getDefaultOrientation());
        this.setHelpAvailable(false);
        this.setBlockOnOpen(true);
    }

    public static void block() {
        LicenseWindow window = new LicenseWindow();
        window.open();
        LicenseService service = LicenseUIActivator.getService();
        ExpectedFeature[] expectedFeatureArray = ExpectedLicenses.list();
        int n = expectedFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpectedFeature f = expectedFeatureArray[n2];
            try {
                LicenseStatus status = service.fetchLicenseFeature((FNOId)f).getStatus();
                if (f.isRequired() && !status.isEnabled()) {
                    PlatformUI.getWorkbench().close();
                }
            }
            catch (LicenseException e) {
                LicenseCoreActivator.log((int)4, (String)e.getMessage());
                PlatformUI.getWorkbench().close();
            }
            ++n2;
        }
    }

    private static LicenseStatus getStatus(ExpectedFeature feature) {
        try {
            return LicenseUIActivator.getService().fetchLicenseFeature((FNOId)feature).getStatus();
        }
        catch (LicenseException e) {
            return LicenseStatus.error((Throwable)e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnActivate = this.createButton(parent, 1029, Messages.getString("LicenseWindow_activate", null), false);
        this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.activate();
                int index = LicenseWindow.this.m_table.getSelectionIndex();
                LicenseWindow.this.updateTable();
                LicenseWindow.this.m_table.setSelection(index);
            }
        });
        this.btnDetails = this.createButton(parent, 1028, Messages.getString("LicenseWindow_details", null), false);
        this.btnDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.details();
            }
        });
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.close();
            }
        });
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.m_table = new Table(composite, 65540);
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.updateSelection();
                LicenseWindow.this.updateButtons();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.m_table.getItemHeight() * 3;
        data.horizontalSpan = 5;
        this.m_table.setLayoutData((Object)data);
        this.m_table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_product", null));
        column.setWidth(260);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_version", null));
        column.setWidth(80);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_status", null));
        column.setWidth(160);
        ((GridData)this.m_table.getLayoutData()).horizontalSpan = 3;
        this.m_table.setHeaderVisible(true);
        this.setTitle(Messages.getString("LicenseWindow_fslLicense", null));
        this.setMessage(Messages.getString("LicenseWindow_viewLicense", null));
        this.updateTable();
        if (this.m_table.getItemCount() > 0) {
            this.m_table.setSelection(0);
            this.updateSelection();
        }
        return composite;
    }

    private void updateTable() {
        ExpectedFeature[] features;
        this.m_table.removeAll();
        ExpectedFeature[] expectedFeatureArray = features = ExpectedLicenses.list();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ExpectedFeature feature = expectedFeatureArray[n2];
            TableItem item = new TableItem(this.m_table, 0);
            LicenseWindow.fillItemInfo(feature, item);
            ++n2;
        }
    }

    private static void fillItemInfo(ExpectedFeature feature, TableItem item) {
        if (item == null || feature == null) {
            return;
        }
        item.setData((Object)feature);
        item.setText(0, feature.getLabel());
        item.setText(1, feature.getVersion());
        item.setText(2, LicenseWindow.getStatus(feature).getStatusText());
    }

    private void updateSelection() {
        Object data;
        TableItem item = this.getSelectedItem();
        if (item != null && (data = item.getData()) instanceof ExpectedFeature) {
            LicenseWindow.fillItemInfo((ExpectedFeature)((Object)data), item);
        }
    }

    private TableItem getSelectedItem() {
        int index = this.m_table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.m_table.getItem(index);
    }

    private void updateButtons() {
        TableItem item = this.getSelectedItem();
        if (item != null) {
            LicenseStatus status = LicenseWindow.getStatus((ExpectedFeature)((Object)item.getData()));
            this.btnActivate.setEnabled(true);
            this.btnDetails.setEnabled(true);
            if (LicenseStatus.LicenseStatusType.INITIALIZATION_ERROR.equals((Object)status.getType())) {
                this.btnActivate.setEnabled(false);
            } else if (!status.isEnabled()) {
                this.btnActivate.setText(Messages.getString("LicenseWindow_activate", null));
            } else {
                this.btnActivate.setText(Messages.getString("LicenseWindow_open", null));
            }
        } else {
            this.btnDetails.setEnabled(false);
            this.btnActivate.setEnabled(false);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("LicenseWindow_prodLicenses", null));
    }

    private ExpectedFeature getSelectedFeature() {
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            return (ExpectedFeature)((Object)selectedItem.getData());
        }
        return null;
    }

    private void activate() {
        ExpectedFeature selectedFeature = this.getSelectedFeature();
        if (selectedFeature != null) {
            new ActivateWindow(this.getParentShell(), selectedFeature, !LicenseWindow.getStatus(selectedFeature).isEnabled()).open();
        }
    }

    private void details() {
        new DetailsWindow(this.getShell(), this.getDetails()).open();
    }

    private String getDetails() {
        StringBuilder sb = new StringBuilder();
        ExpectedFeature feature = this.getSelectedFeature();
        if (feature != null) {
            sb.append(feature.getLabel());
            sb.append("\n\n");
            LicenseStatus status = LicenseWindow.getStatus(feature);
            if (LicenseStatus.LicenseStatusType.INITIALIZATION_ERROR.equals((Object)status.getType())) {
                sb.append(status.getStatusText());
            }
            if (LicenseStatus.LicenseStatusType.EXPIRED.equals((Object)status.getType())) {
                sb.append(feature.getHowToProlonge());
            }
            if (LicenseStatus.LicenseStatusType.MISSED.equals((Object)status.getType())) {
                if (!feature.getHowToActivate().isEmpty()) {
                    sb.append(feature.getHowToActivate());
                } else {
                    sb.append(status.getStatusText());
                }
            }
            if (LicenseStatus.LicenseStatusType.ACTIVATED.equals((Object)status.getType()) || LicenseStatus.LicenseStatusType.EVALUATION.equals((Object)status.getType())) {
                String actId;
                try {
                    actId = LicenseUIActivator.getService().fetchLicenseFeature((FNOId)feature).getActivationId();
                }
                catch (LicenseException e) {
                    LicenseCoreActivator.log((int)4, (String)e.getMessage());
                    actId = "error";
                }
                sb.append("ActivationId: ");
                sb.append(actId);
                sb.append("\nEvaluation Days: ");
                sb.append(status.getDaysLeft());
                sb.append("\nFeature Version: ");
                sb.append(feature.getVersion());
                sb.append("\nFeature Status: ");
                sb.append(status);
            }
        }
        return sb.toString();
    }
}

