/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model.watch;

import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicy;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import java.util.Objects;

public class SvdWatchContext {
    private final SvdWatchReadPolicy readPolicy;

    public static Builder builder() {
        return new Builder();
    }

    private SvdWatchContext(SvdWatchReadPolicy readPolicy) {
        if (readPolicy == null) {
            throw new IllegalArgumentException("readPolicy is null");
        }
        this.readPolicy = readPolicy;
    }

    public SvdWatchReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    public int hashCode() {
        return Objects.hash(this.readPolicy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SvdWatchContext)) {
            return false;
        }
        SvdWatchContext other = (SvdWatchContext)obj;
        return Objects.equals(this.readPolicy, other.readPolicy);
    }

    public static class Builder {
        private SvdWatchReadPolicy readPolicy = null;

        public Builder readPolicy(SvdWatchReadPolicy readPolicy) {
            this.readPolicy = readPolicy;
            return this;
        }

        public SvdWatchContext build() {
            return new SvdWatchContext(this.readPolicy);
        }

        public SvdWatchContext build(SvdRegister register) {
            switch (register.getAccessType()) {
                case WRITE_ONLY: 
                case WRITE_ONCE: {
                    this.readPolicy(new SvdWatchReadPolicy(SvdWatchReadPolicyType.READ_NEWER, false));
                    break;
                }
                default: {
                    if (register.isReadOnDemand()) {
                        this.readPolicy(new SvdWatchReadPolicy(SvdWatchReadPolicyType.READ_ON_DEMAND, false));
                        break;
                    }
                    this.readPolicy(new SvdWatchReadPolicy(SvdWatchReadPolicyType.READ_ALWAYS, true));
                }
            }
            return this.build();
        }
    }
}

