/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdAccesible;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdEnumeratedValue;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumUsageType;
import java.util.List;
import java.util.stream.Collectors;

public class SvdField
extends SvdContainer
implements SvdAccesible {
    private final int bitOffset;
    private final int bitLength;
    private final AccessType accessType;
    private final boolean readOnDemand;

    public SvdField(SvdRegister parent, String name, String description, int bitOffset, int bitLength, AccessType accessType, boolean readOnDemand) {
        super(parent, name, description, SvdEnumeratedValue.class);
        this.bitOffset = bitOffset;
        this.bitLength = bitLength;
        this.accessType = accessType;
        this.readOnDemand = readOnDemand;
    }

    public SvdField(SvdRegister parent, SvdField field) {
        this(parent, field.getName(), field.getDescription(), field.bitOffset, field.bitLength, field.accessType, field.readOnDemand);
    }

    @Override
    public SvdRegister getParent() {
        return (SvdRegister)super.getParent();
    }

    protected List<SvdEnumeratedValue> getEnumeratedValues() {
        return this.getElements(SvdEnumeratedValue.class);
    }

    public List<SvdEnumeratedValue> getEnumeratedValuesForRead() {
        return this.getEnumeratedValuesFor(EnumUsageType.READ);
    }

    public List<SvdEnumeratedValue> getEnumeratedValuesForWrite() {
        return this.getEnumeratedValuesFor(EnumUsageType.WRITE);
    }

    private List<SvdEnumeratedValue> getEnumeratedValuesFor(EnumUsageType usageType) {
        return this.getElements(SvdEnumeratedValue.class).stream().filter(v -> v.getUsageType() == usageType || v.getUsageType() == EnumUsageType.READ_WRITE).collect(Collectors.toList());
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    public boolean isReadOnDemand() {
        return this.readOnDemand;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        super.toString(builder).append(", fbitoffset=").append(this.bitOffset).append(", fbitlength=").append(this.bitLength).append(", accessType=").append((Object)this.accessType).append(", readOnDemand=").append(this.readOnDemand);
        return builder;
    }

    @Override
    protected String getChildrenName() {
        return "enumerated values";
    }

    public void fillFrom(SvdField parent) {
        for (SvdEnumeratedValue parentValue : parent.getEnumeratedValues()) {
            SvdEnumeratedValue value = new SvdEnumeratedValue(this, parentValue);
            super.add(value);
        }
    }
}

