/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.debug.core.model.MemoryByte;

public class SvdDsfMemoryRanges {
    public static SvdDsfMemoryRange toRange(SvdRegister register, boolean align) {
        int bytesSize = SvdDsfMemoryRanges.toBytes(register);
        return new SvdDsfMemoryRange(register.getAddress(), bytesSize, align ? bytesSize : 1);
    }

    public static int toBytes(SvdRegister r) {
        return r.getBitLength() / 8;
    }

    public static BigInteger extract(SvdDsfMemoryRange containingRange, MemoryByte[] memoryBytes, SvdDsfMemoryRange range) {
        IAddress address = range.getAddress();
        int offset = containingRange.getAddress().distanceTo(address).intValue();
        if (!SvdDsfMemoryRanges.exists(memoryBytes, offset, range.getSize())) {
            return null;
        }
        if (!memoryBytes[offset].isEndianessKnown()) {
            SvdActivator.getInstance().logError("Endianess is unknown for address " + address);
            return null;
        }
        if (!memoryBytes[offset].isReadable()) {
            return null;
        }
        return SvdDsfMemoryRanges.extract(memoryBytes, offset, range.getSize());
    }

    public static BigInteger extract(MemoryByte[] memoryBytes) {
        return SvdDsfMemoryRanges.extract(memoryBytes, 0, memoryBytes.length);
    }

    public static BigInteger extract(MemoryByte[] memoryBytes, int offset, int size) {
        if (!SvdDsfMemoryRanges.exists(memoryBytes, offset, size)) {
            return null;
        }
        byte[] bytes = new byte[size + 1];
        bytes[0] = 0;
        if (!memoryBytes[offset].isBigEndian()) {
            int i = 0;
            while (i < size) {
                bytes[i + 1] = memoryBytes[offset + size - 1 - i].getValue();
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                bytes[i + 1] = memoryBytes[offset + i].getValue();
                ++i;
            }
        }
        return new BigInteger(bytes);
    }

    private static boolean exists(MemoryByte[] memoryBytes, int offset, int size) {
        int i = offset;
        while (i < offset + size) {
            if (memoryBytes[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

