/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfRequestors;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfConversions;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.osgi.util.NLS;

public class SvdDsfGdbMemoryRequestor
extends DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> {
    private static SvdDsfGdbMemoryRequestor INSTANCE = new SvdDsfGdbMemoryRequestor();

    private SvdDsfGdbMemoryRequestor() {
    }

    public static DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> getInstance() {
        return INSTANCE;
    }

    protected CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>> performRead(final DsfRequest<SvdDsfMemoryRange, ?> request) throws DsfSessionInactiveException {
        final CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>> future = new CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>>();
        final IMemory.IMemoryDMContext memoryContext = SvdDsfRequestors.getMemoryContext(request.idmContext);
        final IGDBMemory iMemory = SvdDsfRequestors.getService(request, IGDBMemory.class);
        request.session.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                iMemory.getMemory(memoryContext, ((SvdDsfMemoryRange)request.base).getAddress(), 0L, 1, ((SvdDsfMemoryRange)request.base).getSize(), (DataRequestMonitor)new DataRequestMonitor<MemoryByte[]>((Executor)iMemory.getExecutor(), null){

                    protected void handleSuccess() {
                        MemoryByte[] data = (MemoryByte[])this.getData();
                        if (data == null) {
                            future.completeExceptionally((Throwable)new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)"Data for range {0} is null!", (Object)request.base))));
                        } else {
                            future.complete(new DsfResponse(request, (Object)data));
                        }
                    }

                    protected void handleCancel() {
                        future.cancel(false);
                    }

                    protected void handleFailure() {
                        future.completeExceptionally((Throwable)new CoreException(this.getStatus()));
                    }
                });
            }
        });
        return future;
    }

    protected CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>> performWrite(final DsfRequest<SvdDsfMemoryRange, BigInteger> request) throws DsfSessionInactiveException {
        final BigInteger value = (BigInteger)request.value;
        final IMemory.IMemoryDMContext memoryContext = SvdDsfRequestors.getMemoryContext(request.idmContext);
        final IGDBMemory iMemory = SvdDsfRequestors.getService(request, IGDBMemory.class);
        if (iMemory == null) {
            CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>> future = new CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>>();
            future.completeExceptionally(new RuntimeException("IGDBMemory service not available"));
            return future;
        }
        boolean isBigEndian = iMemory.isBigEndian(memoryContext);
        final int size = ((SvdDsfMemoryRange)request.base).getSize();
        final byte[] byteBuffer = SvdDsfRequestors.getByteBuffer(value, size, isBigEndian);
        final IAddress address = ((SvdDsfMemoryRange)request.base).getAddress();
        final CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>> future = new CompletableFuture<DsfResponse<SvdDsfMemoryRange, MemoryByte[]>>();
        SvdTrace.trace("address: [{}] size: {} isBigEndian: {} value: {} byteBuffer: [{}]", SvdTrace.lazy(() -> address.getValue().toString(16)), size, isBigEndian, SvdTrace.lazy(() -> value.toString(16)), SvdTrace.lazy(() -> DsfConversions.toHexString((byte[])byteBuffer)));
        request.session.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                iMemory.setMemory(memoryContext, address, 0L, 1, size, byteBuffer, new RequestMonitor((Executor)iMemory.getExecutor(), null){

                    protected void handleSuccess() {
                        SvdTrace.trace("write {} success: {}", request.base, SvdTrace.lazy(() -> value.toString(16)));
                        future.complete(new DsfResponse(request));
                    }

                    protected void handleCancel() {
                        future.cancel(false);
                    }

                    protected void handleFailure() {
                        future.completeExceptionally((Throwable)new CoreException(this.getStatus()));
                    }
                });
            }
        });
        return future;
    }
}

