/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf;

import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersBaseCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfUpdatableCache;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

public abstract class SvdDsfRegistersMapBaseCache<B, V, R>
extends SvdDsfUpdatableCache<B, V, R>
implements SvdDsfRegistersBaseCache {
    protected final Object updateLock = new Object();
    protected final Map<B, BigInteger> values = new HashMap<B, BigInteger>();
    protected final Map<B, BigInteger> prevValues = new HashMap<B, BigInteger>();
    protected IDMContext idmContext;

    public SvdDsfRegistersMapBaseCache(DsfSession session, DsfRequestor<B, V, R> requestor) {
        super(session, requestor);
    }

    @Override
    public void initialize(IDMContext idmContext) {
        this.idmContext = idmContext;
    }

    @Override
    public void dispose() {
    }

    protected abstract B convert(SvdRegister var1);

    protected abstract BigInteger extract(R var1);

    @Override
    public void addRegisters(Collection<SvdRegister> registers) {
        for (SvdRegister r : registers) {
            this.add(this.convert(r), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegisters(Collection<SvdRegister> registers) {
        Object object = this.updateLock;
        synchronized (object) {
            for (SvdRegister r : registers) {
                B range = this.convert(r);
                this.values.remove(range);
                this.prevValues.remove(range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getValue(SvdRegister r) {
        Object object = this.updateLock;
        synchronized (object) {
            return this.values.get(this.convert(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getPrevValue(SvdRegister r) {
        Object object = this.updateLock;
        synchronized (object) {
            return this.prevValues.get(this.convert(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(B range, BigInteger value) {
        Object object = this.updateLock;
        synchronized (object) {
            this.values.put(range, value);
            this.prevValues.remove(range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(B range, R result) {
        Object object = this.updateLock;
        synchronized (object) {
            BigInteger value = this.values.get(range);
            this.prevValues.put(range, value);
            if (result != null) {
                this.values.put(range, this.extract(result));
            } else {
                this.values.put(range, null);
            }
        }
    }
}

