/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.resources;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.AProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.IProcessorDbLink;
import com.nxp.swtools.expert.processordb.IProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public abstract class AProcessorFilterForResourceTable
extends AProcessorFilterForSwTools {
    protected static final IProcessorFilterForSwTools.RequiredDbType DB_TYPE_PERIPHERALS_RESOURCE_TABLES = new IProcessorFilterForSwTools.RequiredDbType("resource_tables", DB_TYPE_VERSION_1_0, DB_TYPE_VERSION_2_0);
    private static final String DEFAULT_RESOURCE_TABLES_DIRECTORY = "resource_tables";
    public static final String COMMON = "$COMMON";
    Set<Triplet<IProcessorFilterForSwTools.RequiredDbType, String, String>> variableReplacement = new HashSet<Triplet<IProcessorFilterForSwTools.RequiredDbType, String, String>>();

    protected AProcessorFilterForResourceTable() {
        this.addVariableReplacement(DB_TYPE_PERIPHERALS_RESOURCE_TABLES, COMMON, DEFAULT_RESOURCE_TABLES_DIRECTORY);
    }

    protected void addVariableReplacement(IProcessorFilterForSwTools.RequiredDbType dbType, String variable, String replacement) {
        this.variableReplacement.add((Triplet<IProcessorFilterForSwTools.RequiredDbType, String, String>)new Triplet((Object)dbType, (Object)variable, (Object)replacement));
    }

    public String getPeripheralsResourceTablesDir(IMcuIdentification mcu) {
        return DataDirectoryUtils.getDbFileWithPath((String)this.getRequiredDbFile(mcu, DB_TYPE_PERIPHERALS_RESOURCE_TABLES), (IMcuIdentification)mcu);
    }

    public boolean isPeripheralsResourceTablesDirDefined(IMcuIdentification mcu) {
        return !UtilsText.isEmpty((String)this.getRequiredDbFile(mcu, DB_TYPE_PERIPHERALS_RESOURCE_TABLES));
    }

    public @Nullable String getRequiredFile(IProcessorMasterToolInfo masterToolInfo, String partNumber, ISupportedDerivativesForSwTools sd, IProcessorFilterForSwTools.RequiredDbType requirement) {
        IProcessorDbLink link;
        Set<Object> replacements = this.variableReplacement.stream().filter(mr -> requirement.equals(mr.getFirst())).collect(Collectors.toSet());
        this.preprocessReplacements(replacements, masterToolInfo, sd);
        String dbFileName = null;
        if (!replacements.isEmpty() && (link = sd.getDbLink(masterToolInfo, partNumber, requirement)) != null) {
            String fileName = link.getRelPath();
            if (!(replacements = replacements.stream().filter(mr -> fileName.startsWith((String)mr.getSecond())).collect(Collectors.toSet())).isEmpty()) {
                dbFileName = fileName;
                for (Triplet triplet : replacements) {
                    dbFileName = dbFileName.replaceFirst(Matcher.quoteReplacement((String)triplet.getSecond()), Matcher.quoteReplacement((String)triplet.getThird()));
                }
                return String.valueOf(dbFileName) + File.separator + masterToolInfo.getSdkVersion();
            }
        }
        dbFileName = sd.getDbFileName(masterToolInfo, partNumber, requirement);
        return dbFileName;
    }

    protected void preprocessReplacements(Set<Triplet<IProcessorFilterForSwTools.RequiredDbType, String, String>> replacements, IProcessorMasterToolInfo masterToolInfo, ISupportedDerivativesForSwTools sd) {
    }
}

