/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.Constraint;
import com.nxp.swtools.resourcetables.model.data.Dependency;
import com.nxp.swtools.resourcetables.model.data.DependencyResponse;
import com.nxp.swtools.resourcetables.properties.Properties;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="validation", strict=false)
public class Validation {
    public static final Logger LOGGER = LogManager.getLogger(Validation.class);
    @ElementList(type=Constraint.class, required=false, inline=true)
    private List<Constraint> constraints;
    @ElementList(type=Dependency.class, required=false, inline=true)
    private List<Dependency> dependencies;
    @ElementList(type=DependencyResponse.class, required=false, inline=true)
    private List<DependencyResponse> dependencyResponses;

    public Validation() {
        this.constraints = new ArrayList<Constraint>();
        this.dependencies = new ArrayList<Dependency>();
        this.dependencyResponses = new ArrayList<DependencyResponse>();
    }

    public Validation(Validation original) {
        this.constraints = new ArrayList<Constraint>(original.getConstraints());
        this.dependencies = new ArrayList<Dependency>(original.getDependencies());
        this.dependencyResponses = new ArrayList<DependencyResponse>(original.getDependencyResponses());
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<DependencyResponse> getDependencyResponses() {
        return this.dependencyResponses;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDependencyResponses(List<DependencyResponse> dependencyResponses) {
        this.dependencyResponses = dependencyResponses;
    }

    public boolean addConstraint(Constraint constraint) {
        return this.constraints.add(constraint);
    }

    public boolean addDependency(Dependency dependency) {
        return this.dependencies.add(dependency);
    }

    public boolean addDependencyResponse(DependencyResponse dependencyResponse) {
        return this.dependencyResponses.add(dependencyResponse);
    }

    public List<Constraint> collectViolatedConstraints(IContext expressionContext, @Nullable String level) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.constraints) {
            boolean shouldBeIgnored;
            boolean nameEquals = level == null || level.equalsIgnoreCase(constraint.getLevel());
            boolean isVerificationConstraint = constraint.getLevel().equalsIgnoreCase("Verification");
            boolean bl = shouldBeIgnored = !Properties.isVerificationOn() && isVerificationConstraint;
            if (!nameEquals || shouldBeIgnored || !constraint.isViolated(expressionContext)) continue;
            result.add(constraint);
            if (!isVerificationConstraint) continue;
            LOGGER.log(Level.SEVERE, "[DATA] Verification level constraint was violated: {0}", constraint.getDescription(expressionContext));
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [constraints=" + this.constraints + ", dependencies=" + this.dependencies + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.constraints.hashCode();
        result = 31 * result + this.dependencies.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Validation other = (Validation)obj;
        if (!this.constraints.equals(other.constraints)) {
            return false;
        }
        return this.dependencies.equals(other.dependencies);
    }

    public void mergeWith(Validation validation) {
        for (Constraint c : validation.getConstraints()) {
            this.addConstraint(c);
        }
        for (Dependency d : validation.getDependencies()) {
            this.addDependency(d);
        }
        for (DependencyResponse r : validation.getDependencyResponses()) {
            this.addDependencyResponse(r);
        }
    }
}

