/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import com.nxp.swtools.resourcetables.model.config.AStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ConfigCopyFactory;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSelectionGroup;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.profiler.Profiler;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class StructConfig
extends AStructuredSettingConfig
implements IPresettable {
    protected final Map<String, ISettingConfig> settings = new LinkedHashMap<String, ISettingConfig>();
    private List<ISettingConfig> settingsList = Collections.emptyList();
    @Nullable
    protected IQuickSelection quickSelection = null;

    public StructConfig(StructConfig original) {
        super(original.id, original.name, original.setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsStructSetting(), original.getChildContext().clone(), original.mcu);
        for (Map.Entry<String, ISettingConfig> entry : original.settings.entrySet()) {
            ISettingConfig copy = ConfigCopyFactory.getCopyOf(entry.getValue());
            if (copy == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Cannot make copy of child from original. Using original child instead of its copy");
                copy = entry.getValue();
            }
            this.settings.put(entry.getKey(), copy);
        }
        CopyOnWriteArrayList storageSettings = ((StoragePeriphsStructSetting)this.storageSetting).getSettings();
        storageSettings.clear();
        this.settings.values().stream().filter(x -> x.isStorable()).forEach(x -> {
            boolean bl = storageSettings.add(x.getStorageSetting());
        });
    }

    protected StructConfig(String id, String name, ISetting setting, ChildContext parentContext, Map<String, ISettingConfig> settings, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsStructSetting(), parentContext, mcu);
        this.settings.putAll(settings);
        CopyOnWriteArrayList storageSettings = ((StoragePeriphsStructSetting)this.storageSetting).getSettings();
        settings.values().stream().filter(x -> x.isStorable()).forEachOrdered(x -> {
            boolean bl = storageSettings.add(x.getStorageSetting());
        });
    }

    protected StructConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsStructSetting(), parentContext, mcu);
        for (ISetting child : ((StructSetting)setting).getSettings().values()) {
            String childId = this.createChildId(child.getId());
            ISettingConfig settingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, child.getId(), child, this.childContext, mcu);
            this.settings.put(child.getId(), settingConfig);
            if (!settingConfig.isStorable()) continue;
            this.getStorageSetting().getSettings().add(settingConfig.getStorageSetting());
        }
        IQuickSelection defaultQS = QuickSelectionHelper.getDefaultQuickSelection(this);
        if (defaultQS != null) {
            this.setQuickSelection(defaultQS);
        }
    }

    @Override
    public void delayedInitAfterCreation() {
        for (ISettingConfig subsetting : this.settings.values()) {
            subsetting.delayedInitAfterCreation();
        }
        IQuickSelection currentQuickSelection = this.getQuickSelection();
        if (currentQuickSelection != null) {
            this.applySelectedQuickSelection();
        }
    }

    private void updateStorageSettings() {
        CopyOnWriteArrayList storages = new CopyOnWriteArrayList();
        this.getChildren().forEach(sc -> {
            boolean bl = storages.add(sc.getStorageSetting());
        });
        this.getStorageSetting().setSettings(storages);
    }

    @Override
    public void applyOther(ISettingConfig config) {
        this.applyOtherInternal(config, false);
    }

    private void applyOtherInternal(ISettingConfig config, boolean checkSynchronization) {
        if (!(config instanceof StructConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), StructConfig.class.getName()));
        }
        StructConfig struct = (StructConfig)config;
        Iterator<Map.Entry<String, ISettingConfig>> theirIt = struct.settings.entrySet().iterator();
        if (this.settings.size() != struct.settings.size()) {
            throw new IllegalArgumentException(String.format("Bad setting size with id %1s", config.getId()));
        }
        Iterator<Map.Entry<String, ISettingConfig>> ourIt = this.settings.entrySet().iterator();
        while (ourIt.hasNext() && theirIt.hasNext()) {
            ISettingConfig value = theirIt.next().getValue();
            ISettingConfig ourItValue = ourIt.next().getValue();
            assert (value != null);
            if (!checkSynchronization) {
                ourItValue.applyOther(value);
                continue;
            }
            if (!ourItValue.isSynchronizationEnabled()) continue;
            ourItValue.applySynchronizedSetting(value);
        }
        this.updateStorageAvailability();
        IQuickSelection structQuickSelection = struct.getQuickSelection();
        IQuickSelection quickSelectionToSet = structQuickSelection == null ? null : this.getModelData().getQuickSelection(structQuickSelection.getId());
        this.setQuickSelection(quickSelectionToSet);
    }

    @Override
    public void applySynchronizedSetting(ISettingConfig config) {
        this.applyOtherInternal(config, true);
    }

    @Override
    public void applyQuickSelection(@Nullable IQuickSelection quickSelectionLoc, IChild relativeTo) {
        if (!this.applyQuickSelectionFromResource(quickSelectionLoc, relativeTo)) {
            StructSetting structSetting = this.getModelData();
            if (structSetting.hasQuickSelections()) {
                IQuickSetting quickSetting = QuickSelectionHelper.getQuickSelection(quickSelectionLoc, this, relativeTo);
                if (quickSetting != null) {
                    this.setQuickSelection(structSetting.getQuickSelection(UtilsText.safeString((String)quickSetting.getValue())));
                } else {
                    this.setQuickSelection(QuickSelectionHelper.getDefaultQuickSelection(this));
                }
                if (SWToolsProperties.isVerificationOn() && quickSelectionLoc != null) {
                    String message = "[DATA] The quick setting %s cannot be applied as the struct setting %s contains nested quick selections";
                    String quickSelectionId = String.valueOf(QuickSelectionHelper.getQuickSelectionId(this, relativeTo)) + ".";
                    quickSelectionLoc.getSettings().stream().filter(qs -> qs.getId().startsWith(quickSelectionId)).forEach(qs -> LOGGER.warning(String.format(message, qs.getId(), this.getId())));
                }
            }
            IQuickSelection quickSelectionToApply = structSetting.hasQuickSelections() ? this.quickSelection : quickSelectionLoc;
            IChild relativeToToApply = structSetting.hasQuickSelections() ? this : relativeTo;
            this.getChildren().forEach(x -> x.applyQuickSelection(quickSelectionToApply, relativeToToApply));
        }
    }

    @Override
    public void applySelectedQuickSelection() {
        Profiler profiler;
        BigInteger index = profiler.start(StructConfig.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : "Apply quick selection on setting " + this.getId()));
        if (this.quickSelection != null) {
            this.getChildren().forEach(x -> x.deInitialize());
            this.getChildren().forEach(x -> x.applyQuickSelection(this.quickSelection, this));
        }
        this.getChildren().forEach(x -> x.initValue());
        profiler.stop(index, StructConfig.class, null);
    }

    protected StructConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsStructSetting storageSetting, ICommonMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsStructuredSetting)storageSetting, parentContext, mcu);
        HashMap<K, @Nullable V> storageSettings = new HashMap();
        storageSetting.getSettings().forEach(x -> {
            AStoragePeriphsSetting aStoragePeriphsSetting = storageSettings.put(x.getName(), x);
        });
        for (ISetting child : ((StructSetting)setting).getSettings().values()) {
            String settingName = child.getId();
            AStoragePeriphsSetting storageChildSetting = (AStoragePeriphsSetting)storageSettings.get(settingName);
            storageSettings.remove(settingName);
            String childId = this.createChildId(settingName);
            ISettingConfig settingConfig = storageChildSetting != null ? this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, child, this.childContext, storageChildSetting, mcu) : this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, settingName, child, this.childContext, mcu);
            this.settings.put(settingName, settingConfig);
        }
        if (!storageSettings.isEmpty()) {
            LOGGER.warning(String.format("[TOOL] The following settings: '%s' of the struct setting with id: '%s' could not be restored", storageSettings.keySet(), setting.getId()));
        }
        this.updateStorageSettings();
        String storageQuickSelection = storageSetting.getQuickSelection();
        if (storageQuickSelection != null) {
            this.setQuickSelection(this.getModelData().getQuickSelection(storageQuickSelection));
        }
    }

    public StoragePeriphsStructSetting getStorageSetting() {
        return (StoragePeriphsStructSetting)this.storageSetting;
    }

    @Override
    public void setQuickSelection(@Nullable IQuickSelection quickSelection) {
        this.quickSelection = quickSelection;
        this.getStorageSetting().setQuickSelection(quickSelection != null ? quickSelection.getId() : null);
    }

    @Override
    public @Nullable IQuickSelection getQuickSelection() {
        return this.quickSelection;
    }

    @Override
    public StructConfig getValue() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value", () -> this);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.settings.get(childName);
    }

    public Map<String, ISettingConfig> getSettings() {
        return CollectionsUtils.unmodifiableMap(this.settings);
    }

    @Override
    public @NonNull StructSetting getModelData() {
        return (StructSetting)super.getModelData();
    }

    public List<ISettingConfig> getChildren() {
        List settingsListLoc = this.settingsList;
        if (settingsListLoc.isEmpty()) {
            this.settingsList = settingsListLoc = CollectionsUtils.unmodifiableList(new ArrayList<ISettingConfig>(this.settings.values()));
        }
        return settingsListLoc;
    }

    @Override
    public @NonNull String getTypeName() {
        return "struct";
    }

    @Override
    public IQuickSelectionGroup getQuickSelectionGroup() {
        return this.getModelData();
    }

    @Override
    public void setDefaultValue() {
        for (ISettingConfig child : this.getChildren()) {
            child.setDefaultValue();
        }
    }

    @Override
    public void dispose() {
        for (Map.Entry<String, ISettingConfig> entry : this.settings.entrySet()) {
            entry.getValue().dispose();
        }
        this.settings.clear();
        this.settingsList = Collections.emptyList();
        super.dispose();
    }

    @Override
    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump(builder, options, this);
    }
}

