/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.SWToolsPlatform;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProjectFileContentCache {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ProjectFileContentCache.class);
    @NonNull
    static @NonNull Map<@NonNull Path, @NonNull Reference<@NonNull CachedProjectFileContent>> projectFileContentMap = new HashMap<Path, Reference<CachedProjectFileContent>>();

    ProjectFileContentCache() {
        assert (false) : "not expected to create instance of this class";
    }

    static @Nullable String getPrjFileContentAsString(@NonNull Path absPath, long modificationStamp) {
        if (SWToolsPlatform.isRunningAsRcp()) assert (absPath.isAbsolute());
        @Nullable Reference<@NonNull CachedProjectFileContent> ref = projectFileContentMap.get(absPath);
        if (ref == null) {
            return null;
        }
        @Nullable CachedProjectFileContent content = ref.get();
        if (Objects.isNull(content) || content.modificationStamp != modificationStamp) {
            return null;
        }
        return content.content;
    }

    static @Nullable InputStream getPrjFileContentAsInpStream(@NonNull Path absPath, long modificationStamp) {
        String content = ProjectFileContentCache.getPrjFileContentAsString(absPath, modificationStamp);
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static @Nullable String readToString(@Nullable InputStream strm) {
        if (strm == null) {
            return null;
        }
        String result = null;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(strm, StandardCharsets.UTF_8));){
                result = ProjectFileContentCache.readLinesToString(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private static @Nullable String readLinesToString(BufferedReader reader) {
        StringBuilder content = new StringBuilder(32768);
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return content.toString();
                }
                content.append(line);
                content.append("\r\n");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "I/O exception", e);
            return null;
        }
    }

    static void putProjectFileContentToCache(@NonNull Path absPath, long modificationStamp, @NonNull String content) {
        assert (!Rap.isActive());
        if (SWToolsPlatform.isRunningAsRcp()) assert (absPath.isAbsolute());
        CachedProjectFileContent cacheRec = new CachedProjectFileContent(modificationStamp, content);
        projectFileContentMap.put(absPath, new SoftReference<CachedProjectFileContent>(cacheRec));
    }

    private static class CachedProjectFileContent {
        final long modificationStamp;
        @NonNull
        final String content;

        CachedProjectFileContent(long modificationStamp, @NonNull String content) {
            this.modificationStamp = modificationStamp;
            this.content = content;
        }
    }
}

