/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeDomainConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeInterrupts;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeIoPort;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeePort;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralsContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Commit;

public class StorageTeeSecurityPeripheralBase
extends StorageTeeSecurityPeripheralsContainer {
    @Attribute(name="id", required=false)
    @Nullable
    private @Attribute(name="id", required=false) @Nullable String id;
    @ElementList(name="domains", entry="domain", type=StorageTeeDomainConfig.class, inline=false, required=false)
    @Nullable
    private @ElementList(name="domains", entry="domain", type=StorageTeeDomainConfig.class, inline=false, required=false) @Nullable ArrayList<StorageTeeDomainConfig> domains;
    @Element(name="interrupts", required=false)
    @Nullable
    private @Element(name="interrupts", required=false) @Nullable StorageTeeInterrupts interrupts;
    @ElementList(inline=false, required=false, type=StorageTeePort.class, name="pins_masks", entry="port")
    @Nullable
    private @ElementList(inline=false, required=false, type=StorageTeePort.class, name="pins_masks", entry="port") @Nullable ArrayList<StorageTeePort> pinMasks;
    @ElementList(inline=false, required=false, type=StorageTeeIoPort.class, name="ports", entry="port")
    @Nullable
    private @ElementList(inline=false, required=false, type=StorageTeeIoPort.class, name="ports", entry="port") @Nullable ArrayList<StorageTeeIoPort> ioPorts;

    @Commit
    private void commit() {
        this.ioPorts = StorageTeeSecurityPeripheralBase.ioPortsFromPinMasks(this.ioPorts, this.pinMasks);
        this.pinMasks = null;
    }

    private static @Nullable ArrayList<StorageTeeIoPort> ioPortsFromPinMasks(@Nullable ArrayList<StorageTeeIoPort> ioPorts, @Nullable List<StorageTeePort> pinMasks) {
        ArrayList<StorageTeeIoPort> ioPortsLoc = ioPorts;
        if (pinMasks != null) {
            for (StorageTeePort port : pinMasks) {
                if (ioPortsLoc == null) {
                    ioPortsLoc = new ArrayList();
                }
                if (!ioPortsLoc.stream().noneMatch(p -> p.getId().equals(port.getId()))) continue;
                ioPortsLoc.add(new StorageTeeIoPort(port));
            }
        }
        return ioPortsLoc;
    }

    @Override
    public void fillYamlStorable(IYamlStorable yaml) {
        ArrayList<StorageTeeIoPort> ioPortsLoc;
        ArrayList<StorageTeeDomainConfig> domainsLoc;
        if (this.id != null) {
            yaml.addYamlChild((IYamlStorable)new YamlStorableValue("id", this.id));
        }
        if (this.domains != null && !(domainsLoc = this.domains).isEmpty()) {
            YamlStorableList yamlStorableList = new YamlStorableList("domains", Boolean.TRUE, true, true);
            domainsLoc.forEach(domain -> domain.fillYamlStorable((IYamlStorable)yamlStorableList));
            yaml.addYamlChild((IYamlStorable)yamlStorableList);
        }
        super.fillYamlStorable(yaml);
        if (this.interrupts != null) {
            this.interrupts.fillYamlStorable(yaml);
        }
        if ((ioPortsLoc = this.ioPorts) != null) {
            YamlStorableList ioPortsYaml = new YamlStorableList("ports", Boolean.FALSE);
            ioPortsLoc.forEach(each -> {
                boolean bl = ioPortsYaml.addYamlChild(YamlStorableHelper.convertToShortForm(each.getYamlStorable(), (String)"masked"));
            });
            yaml.addYamlChild((IYamlStorable)ioPortsYaml);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        StorageTeeInterrupts interruptsLoc = new StorageTeeInterrupts();
        ArrayList<StorageTeePort> pinMasksLoc = new ArrayList<StorageTeePort>();
        ArrayList<StorageTeeIoPort> ioPortsLoc = new ArrayList<StorageTeeIoPort>();
        for (IYamlStorable childYaml : children) {
            IYamlStorable portYaml;
            Iterator iterator;
            Collection portsYamls;
            String yamlId = childYaml.getYamlId();
            if (yamlId.equals("id")) {
                this.id = childYaml.getYamlValue();
                continue;
            }
            if (yamlId.equals("domains")) {
                @NonNull Collection domainsYaml = childYaml.getYamlChildren();
                if (domainsYaml == null) continue;
                ArrayList<StorageTeeDomainConfig> domainsLoc = new ArrayList<StorageTeeDomainConfig>();
                for (IYamlStorable domain : domainsYaml) {
                    StorageTeeDomainConfig domainStorage = new StorageTeeDomainConfig();
                    domainStorage.updateFromYamlStorable(domain);
                    domainsLoc.add(domainStorage);
                }
                this.domains = domainsLoc;
                continue;
            }
            if (yamlId.equals("interrupts")) {
                StorageTeeInterrupts config = new StorageTeeInterrupts();
                if (!config.updateFromYamlStorable(childYaml)) continue;
                interruptsLoc = config;
                continue;
            }
            if (yamlId.equals("pins_masks")) {
                ArrayList<StorageTeePort> pinMasksFromYaml = new ArrayList<StorageTeePort>();
                portsYamls = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)childYaml);
                iterator = portsYamls.iterator();
                while (iterator.hasNext()) {
                    StorageTeePort port = new StorageTeePort();
                    portYaml = (IYamlStorable)iterator.next();
                    IYamlStorable portLongForm = YamlStorableHelper.convertToLongForm((IYamlStorable)portYaml, (String)"masked", (String)"pin");
                    if (!port.updateFromYamlStorable(portLongForm)) continue;
                    pinMasksFromYaml.add(port);
                }
                pinMasksLoc = pinMasksFromYaml;
                continue;
            }
            if (!yamlId.equals("ports")) continue;
            ArrayList<StorageTeeIoPort> ioPortsFromYaml = new ArrayList<StorageTeeIoPort>();
            portsYamls = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)childYaml);
            iterator = portsYamls.iterator();
            while (iterator.hasNext()) {
                StorageTeeIoPort ioPort = new StorageTeeIoPort();
                portYaml = (IYamlStorable)iterator.next();
                if (!ioPort.updateFromYamlStorable(portYaml)) continue;
                ioPortsFromYaml.add(ioPort);
            }
            ioPortsLoc = ioPortsFromYaml;
        }
        this.setInterrupts(interruptsLoc);
        this.setIoPorts(StorageTeeSecurityPeripheralBase.ioPortsFromPinMasks(ioPortsLoc, pinMasksLoc));
        return super.updateFromYamlStorable(yaml);
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public @Nullable String getId() {
        return this.id;
    }

    public @Nullable List<StorageTeeDomainConfig> getDomains() {
        return this.domains;
    }

    public void setDomains(List<StorageTeeDomainConfig> domains) {
        this.domains = new ArrayList<StorageTeeDomainConfig>(domains);
    }

    public @Nullable StorageTeeInterrupts getInterrupts() {
        return this.interrupts;
    }

    public void setInterrupts(@Nullable StorageTeeInterrupts interrupts) {
        this.interrupts = interrupts;
    }

    public @Nullable List<StorageTeeIoPort> getIoPorts() {
        return this.ioPorts;
    }

    public void setIoPorts(@Nullable List<StorageTeeIoPort> ioPorts) {
        this.ioPorts = ioPorts != null ? new ArrayList<StorageTeeIoPort>(ioPorts) : null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.id);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        StorageTeeSecurityPeripheralBase other = (StorageTeeSecurityPeripheralBase)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.domains, other.domains) && Objects.equals(this.interrupts, other.interrupts) && Objects.equals(this.pinMasks, other.pinMasks) && Objects.equals(this.ioPorts, other.ioPorts);
    }
}

