/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGenericRdcMasterDomainAssignment;
import java.util.Collection;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;

@Order(attributes={"secure", "privileged", "enabled", "locked", "domain_id", "domain_bypass", "domain_input"})
public class StorageTeeCommonTrdcMasterDomainAssignment
extends StorageTeeGenericRdcMasterDomainAssignment {
    @Attribute(name="domain_bypass", required=false)
    @Nullable
    private @Attribute(name="domain_bypass", required=false) @Nullable Boolean domainIdBypassed;
    @Attribute(name="domain_input", required=false)
    @Nullable
    private @Attribute(name="domain_input", required=false) @Nullable String domainIdInput;

    public StorageTeeCommonTrdcMasterDomainAssignment() {
    }

    public StorageTeeCommonTrdcMasterDomainAssignment(boolean enabled, boolean locked, int domainId, @Nullable Boolean domainIdBypassed, @Nullable String domainIdInput, @Nullable String secureSelect, @Nullable String privilegedSelect) {
        super(secureSelect, privilegedSelect, enabled, locked, domainId);
        this.domainIdBypassed = domainIdBypassed;
        this.domainIdInput = domainIdInput;
    }

    public @Nullable Boolean getDomainIdBypassed() {
        return this.domainIdBypassed;
    }

    public void setDomainIdBypassed(@Nullable Boolean domainIdBypassed) {
        this.domainIdBypassed = domainIdBypassed;
    }

    public @Nullable String getDomainIdInput() {
        return this.domainIdInput;
    }

    public void setDomainIdInput(@Nullable String domainIdInput) {
        this.domainIdInput = domainIdInput;
    }

    @Override
    public void fillYamlStorable(IYamlStorable yaml) {
        String domainInput;
        super.fillYamlStorable(yaml);
        Boolean domainBypass = this.getDomainIdBypassed();
        if (domainBypass != null) {
            yaml.addYamlChild((IYamlStorable)new YamlStorableValue("domain_bypass", domainBypass.toString()));
        }
        if ((domainInput = this.getDomainIdInput()) != null) {
            yaml.addYamlChild((IYamlStorable)new YamlStorableValue("domain_input", domainInput));
        }
    }

    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        super.updateFromYamlStorable(yaml);
        Boolean domainIdBypassedLoc = null;
        String domainIdInputLoc = null;
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            String s;
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals("domain_input")) {
                s = childYaml.getYamlValue();
                if (s.isEmpty()) continue;
                domainIdInputLoc = s;
                continue;
            }
            if (!childYaml.getYamlId().equals("domain_bypass") || (s = childYaml.getYamlValue()).isEmpty()) continue;
            domainIdBypassedLoc = Boolean.valueOf(s);
        }
        this.setDomainIdBypassed(domainIdBypassedLoc);
        this.setDomainIdInput(domainIdInputLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.domainIdBypassed, this.domainIdInput);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeCommonTrdcMasterDomainAssignment other = (StorageTeeCommonTrdcMasterDomainAssignment)obj;
        return Objects.equals(this.domainIdBypassed, other.domainIdBypassed) && Objects.equals(this.domainIdInput, other.domainIdInput);
    }

    @Override
    public String toString() {
        return String.format("%s [%s, %s=%s, %s=%s]", StorageTeeCommonTrdcMasterDomainAssignment.class.getSimpleName(), super.toString(), "domain_bypass", this.domainIdBypassed, "domain_input", this.domainIdInput);
    }
}

