/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.BigIntRegion;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeBaseMemoryRegionConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeCheckerSlaveConfig;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageTeeCheckerMemorySlaveConfig
extends StorageTeeCheckerSlaveConfig {
    @Element(name="base_region", required=false)
    @Nullable
    private @Element(name="base_region", required=false) @Nullable StorageTeeBaseMemoryRegionConfig memRegion;

    public @Nullable StorageTeeBaseMemoryRegionConfig getMemRegion() {
        return this.memRegion;
    }

    public void setMemRegion(@Nullable StorageTeeBaseMemoryRegionConfig memRegion) {
        this.memRegion = memRegion;
    }

    public @Nullable BigInteger getMemRegionStart() {
        return this.memRegion != null ? this.memRegion.getStart() : null;
    }

    public @Nullable BigInteger getMemRegionSize() {
        return this.memRegion != null ? this.memRegion.getSize() : null;
    }

    @Override
    protected void addUnderlyingYaml(YamlStorableList<IYamlStorable> yamlStorable) {
        if (this.memRegion != null) {
            this.memRegion.fillYamlStorable((IYamlStorable)yamlStorable);
        }
    }

    @Override
    protected boolean updatePropertyFromYaml(IYamlStorable yaml) {
        boolean updated = super.updatePropertyFromYaml(yaml);
        if (!updated) {
            StorageTeeBaseMemoryRegionConfig region;
            String yamlId = yaml.getYamlId();
            if (yaml instanceof YamlStorableList && yamlId.equals("base_region") && (region = new StorageTeeBaseMemoryRegionConfig()).updateFromYamlStorable(yaml)) {
                this.setMemRegion(region);
                updated = true;
            }
        }
        return updated;
    }

    public static void mergeSlavesStorages(List<StorageTeeCheckerMemorySlaveConfig> storagesSlaves) {
        Iterator<StorageTeeCheckerMemorySlaveConfig> iterator = storagesSlaves.iterator();
        if (iterator.hasNext()) {
            StorageTeeCheckerMemorySlaveConfig previousStorage = iterator.next();
            while (iterator.hasNext()) {
                StorageTeeCheckerMemorySlaveConfig currentStorage = iterator.next();
                if (StorageTeeCheckerMemorySlaveConfig.canMerge(previousStorage, currentStorage)) {
                    StorageTeeBaseMemoryRegionConfig previousMemRegion = previousStorage.getMemRegion();
                    StorageTeeBaseMemoryRegionConfig currentMemRegion = currentStorage.getMemRegion();
                    assert (previousMemRegion != null);
                    assert (currentMemRegion != null);
                    previousMemRegion.setSize(previousMemRegion.getSize().add(currentMemRegion.getSize()));
                    iterator.remove();
                    continue;
                }
                previousStorage = currentStorage;
            }
        }
    }

    private static boolean canMerge(StorageTeeCheckerMemorySlaveConfig firstStorage, StorageTeeCheckerMemorySlaveConfig secondStorage) {
        StorageTeeBaseMemoryRegionConfig currentMemRegion = secondStorage.getMemRegion();
        StorageTeeBaseMemoryRegionConfig previousMemRegion = firstStorage.getMemRegion();
        return currentMemRegion != null && previousMemRegion != null && BigIntRegion.create((BigInteger)currentMemRegion.getStart(), (BigInteger)currentMemRegion.getSize()).follows(BigIntRegion.create((BigInteger)previousMemRegion.getStart(), (BigInteger)previousMemRegion.getSize())) && Objects.equals(secondStorage.getSlaveId(), firstStorage.getSlaveId()) && secondStorage.getSlaveDomains().equals(firstStorage.getSlaveDomains());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * prime;
        result = result * prime + Objects.hash(this.memRegion);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeCheckerMemorySlaveConfig other = (StorageTeeCheckerMemorySlaveConfig)obj;
        return Objects.equals(this.memRegion, other.memRegion);
    }

    @Override
    public String toString() {
        return String.format("%s [[%s], memRegion=%s]", StorageTeeCheckerMemorySlaveConfig.class.getSimpleName(), super.toString(), this.memRegion);
    }
}

