/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.StorageValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageRoutedPin {
    static final long serialVersionUID = 1L;
    @NonNull
    @Attribute
    public String peripheral;
    @NonNull
    @Attribute
    public String signal;
    @NonNull
    @Attribute(name="pin_num", required=false)
    public @NonNull @Attribute(name="pin_num", required=false) String pinNum;
    @NonNull
    @Attribute(name="pin_signal", required=false)
    public @NonNull @Attribute(name="pin_signal", required=false) String pinSignal;
    @Nullable
    @ElementList(name="pin_features", entry="pin_feature", required=false)
    public @Nullable @ElementList(name="pin_features", entry="pin_feature", required=false) ArrayList<StorageValue> pinFeatures = null;

    StorageRoutedPin() {
        this.peripheral = "";
        this.signal = "";
        this.pinNum = "";
        this.pinSignal = "";
    }

    public StorageRoutedPin(@NonNull String peripheral, @NonNull String signal, @NonNull String pinNum, @NonNull String pinSignal) {
        this.peripheral = peripheral;
        this.signal = signal;
        this.pinNum = pinNum;
        this.pinSignal = pinSignal;
    }

    public @Nullable List<StorageValue> getPinFeatures() {
        return this.pinFeatures;
    }

    public void setPinFeatures(@Nullable List<StorageValue> pinFeatures) {
        this.pinFeatures = pinFeatures != null ? new ArrayList<StorageValue>(pinFeatures) : null;
    }

    public String toString() {
        return "StorageRoutedPin [peripheral=" + this.peripheral + ", signal=" + this.signal + ", pinNum=" + this.pinNum + ", pinSignal=" + this.pinSignal + ", pinFeatures=" + this.pinFeatures + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (Objects.isNull(this.peripheral) ? 0 : this.peripheral.hashCode());
        result = 31 * result + (this.pinFeatures == null ? 0 : new HashSet<StorageValue>(this.pinFeatures).hashCode());
        result = 31 * result + (Objects.isNull(this.pinNum) ? 0 : this.pinNum.hashCode());
        result = 31 * result + (Objects.isNull(this.pinSignal) ? 0 : this.pinSignal.hashCode());
        result = 31 * result + (Objects.isNull(this.signal) ? 0 : this.signal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageRoutedPin other = (StorageRoutedPin)obj;
        if (!Objects.equals(this.peripheral, other.peripheral)) {
            return false;
        }
        if (!Objects.equals(this.pinNum, other.pinNum)) {
            return false;
        }
        if (!Objects.equals(this.pinSignal, other.pinSignal)) {
            return false;
        }
        if (!Objects.equals(this.signal, other.signal)) {
            return false;
        }
        if (this.pinFeatures == null) {
            if (other.pinFeatures != null) {
                return false;
            }
        } else {
            if (other.pinFeatures == null) {
                return false;
            }
            if (!new HashSet<StorageValue>(this.pinFeatures).equals(new HashSet<StorageValue>(other.pinFeatures))) {
                return false;
            }
        }
        return true;
    }
}

