/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.provider.configuration.storage.common.StorageCommonTool;
import com.nxp.swtools.provider.configuration.storage.dcd.StorageDCDTool;
import com.nxp.swtools.provider.configuration.storage.dcdx.StorageDCDxTool;
import com.nxp.swtools.provider.configuration.storage.ddr.StorageDDRTool;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseTool;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.provider.configuration.storage.ice.StorageIceTool;
import com.nxp.swtools.provider.configuration.storage.ivt.StorageIVTTool;
import com.nxp.swtools.provider.configuration.storage.pbl.StoragePBLTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsTool;
import com.nxp.swtools.provider.configuration.storage.power.StoragePowerTool;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectGeneratorTool;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPITool;
import com.nxp.swtools.provider.configuration.storage.sdkbuilder.StorageSdkBuilderTool;
import com.nxp.swtools.provider.configuration.storage.sdkproject.StorageToolchainProjectTool;
import com.nxp.swtools.provider.configuration.storage.serdes.StorageSERDESTool;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;

@Root(strict=false, name="tools")
public class StorageTools {
    static final long serialVersionUID = 1L;
    @Element(name="pins", required=false)
    @Nullable
    @Element(name="pins", required=false) @Nullable StoragePinsTool pins;
    @Element(name="clocks", required=false)
    @Nullable
    @Element(name="clocks", required=false) @Nullable StorageClocksTool clock;
    @Element(name="power", required=false)
    @Nullable
    @Element(name="power", required=false) @Nullable StoragePowerTool power;
    @Element(name="ddr", required=false)
    @Nullable
    @Element(name="ddr", required=false) @Nullable StorageDDRTool ddr;
    @Element(name="dcd", required=false)
    @Nullable
    @Element(name="dcd", required=false) @Nullable StorageDCDTool dcd;
    @Element(name="dcdx", required=false)
    @Nullable
    @Element(name="dcdx", required=false) @Nullable StorageDCDxTool dcdx;
    @Element(name="ivt", required=false)
    @Nullable
    @Element(name="ivt", required=false) @Nullable StorageIVTTool ivt;
    @Element(name="quadspi", required=false)
    @Nullable
    @Element(name="quadspi", required=false) @Nullable StorageQuadSPITool quadspi;
    @Element(name="efuse", required=false)
    @Nullable
    @Element(name="efuse", required=false) @Nullable StorageEfuseTool efuse;
    @Element(name="gtm", required=false)
    @Nullable
    @Element(name="gtm", required=false) @Nullable StorageGtmTool gtm;
    @Element(name="ice", required=false)
    @Nullable
    @Element(name="ice", required=false) @Nullable StorageIceTool ice;
    @Element(name="sdk_builder", required=false)
    @Nullable
    @Element(name="sdk_builder", required=false) @Nullable StorageSdkBuilderTool sdkBuilder;
    @Element(name="prjgen", required=false)
    @Deprecated
    @Nullable
    @Element(name="prjgen", required=false) @Nullable StorageProjectGeneratorTool projectGenerator;
    @Element(name="periphs", required=false)
    @Nullable
    @Element(name="periphs", required=false) @Nullable StoragePeriphsTool peripherals;
    @Element(name="tee", required=false)
    @Nullable
    @Element(name="tee", required=false) @Nullable StorageTeeTool tee;
    @Element(name="pbl", required=false)
    @Nullable
    @Element(name="pbl", required=false) @Nullable StoragePBLTool pbl;
    @Element(name="serdes", required=false)
    @Nullable
    @Element(name="serdes", required=false) @Nullable StorageSERDESTool serdes;
    @Element(name="common", required=false)
    @Nullable
    @Element(name="common", required=false) @Nullable StorageCommonTool common;
    @Transient
    @NonNull
    StorageToolchainProjectTool sdkProject = StorageToolchainProjectTool.STORAGE_TOOLCHAIN_PROJECT_TOOL;

    public @Nullable StoragePinsTool getPins() {
        return this.pins;
    }

    public void setPins(@Nullable StoragePinsTool pins) {
        this.pins = pins;
    }

    public @Nullable StorageClocksTool getClock() {
        return this.clock;
    }

    public void setClock(@Nullable StorageClocksTool clock) {
        this.clock = clock;
    }

    public @Nullable StoragePowerTool getPower() {
        return this.power;
    }

    public void setPower(@Nullable StoragePowerTool power) {
        this.power = power;
    }

    public @Nullable StorageSdkBuilderTool getSdkBuilder() {
        return this.sdkBuilder;
    }

    public void setSdkBuilder(@Nullable StorageSdkBuilderTool sdkBuilder) {
        this.sdkBuilder = sdkBuilder;
    }

    @Deprecated
    public @Nullable StorageProjectGeneratorTool getProjectGenerator() {
        return this.projectGenerator;
    }

    public void clearProjectGenerator() {
        this.projectGenerator = null;
    }

    public @Nullable StoragePeriphsTool getPeripherals() {
        return this.peripherals;
    }

    public void setPeripherals(@Nullable StoragePeriphsTool peripherals) {
        this.peripherals = peripherals;
    }

    @Deprecated
    public @Nullable StorageCommonTool getCommon() {
        return this.common;
    }

    public @Nullable StorageDCDTool getDCDTool() {
        return this.dcd;
    }

    public void setDCDTool(@Nullable StorageDCDTool dcd) {
        this.dcd = dcd;
    }

    public @Nullable StorageDCDxTool getDCDxTool() {
        return this.dcdx;
    }

    public void setDCDxTool(@Nullable StorageDCDxTool dcdx) {
        this.dcdx = dcdx;
    }

    public @Nullable StorageIVTTool getIVTTool() {
        return this.ivt;
    }

    public void setIVTTool(@Nullable StorageIVTTool ivt) {
        this.ivt = ivt;
    }

    public @Nullable StorageQuadSPITool getQuadSPITool() {
        return this.quadspi;
    }

    public void setQuadSPITool(@Nullable StorageQuadSPITool quadspi) {
        this.quadspi = quadspi;
    }

    public @Nullable StorageEfuseTool getEfuseTool() {
        return this.efuse;
    }

    public void setEfuseTool(@Nullable StorageEfuseTool efuse) {
        this.efuse = efuse;
    }

    public @Nullable StorageGtmTool getGtmTool() {
        return this.gtm;
    }

    public void setGtmTool(@Nullable StorageGtmTool gtm) {
        this.gtm = gtm;
    }

    public @Nullable StorageIceTool getIceTool() {
        return this.ice;
    }

    public void setIceTool(@Nullable StorageIceTool ice) {
        this.ice = ice;
    }

    public void setTeeTool(@Nullable StorageTeeTool teeTool) {
        this.tee = teeTool;
    }

    public @Nullable StorageTeeTool getTeeTool() {
        return this.tee;
    }

    public void setPBLTool(@Nullable StoragePBLTool pblTool) {
        this.pbl = pblTool;
    }

    public @Nullable StoragePBLTool getPBLTool() {
        return this.pbl;
    }

    public void setSERDESTool(@Nullable StorageSERDESTool serdesTool) {
        this.serdes = serdesTool;
    }

    public @Nullable StorageSERDESTool getSERDESTool() {
        return this.serdes;
    }

    public @NonNull Collection<@NonNull StorageTool> getTools() {
        ArrayList<StorageTool> result = new ArrayList<StorageTool>();
        result.add(this.peripherals);
        result.add(this.pins);
        result.add(this.clock);
        result.add(this.sdkBuilder);
        result.add(this.power);
        result.add(this.common);
        result.add(this.projectGenerator);
        result.add(this.dcd);
        result.add(this.ivt);
        result.add(this.ddr);
        result.add(this.efuse);
        result.add(this.gtm);
        result.add(this.ice);
        result.add(this.tee);
        result.add(this.dcdx);
        result.add(this.quadspi);
        result.add(this.pbl);
        result.add(this.serdes);
        result.removeIf(Objects::isNull);
        return result;
    }

    public @Nullable StorageTool getTool(@NonNull String id) {
        return (StorageTool)CollectionsUtils.findAny(this.getTools(), t -> t.getName().equals(id));
    }

    public void setTool(@NonNull StorageTool strgTool) {
        this.setTool(strgTool.getName(), strgTool);
    }

    public void setTool(@NonNull String name, @Nullable StorageTool storage) {
        if ("Clocks".equals(name)) {
            this.setClock((StorageClocksTool)storage);
        } else if ("Pins".equals(name)) {
            this.setPins((StoragePinsTool)storage);
        } else if ("Peripherals".equals(name)) {
            this.setPeripherals((StoragePeriphsTool)storage);
        } else if ("DCD".equals(name)) {
            this.setDCDTool((StorageDCDTool)storage);
        } else if ("IVT".equals(name)) {
            this.setIVTTool((StorageIVTTool)storage);
        } else if ("DDR".equals(name)) {
            this.setDDRTool((StorageDDRTool)storage);
        } else if ("TEE".equals(name)) {
            this.setTeeTool((StorageTeeTool)storage);
        } else if ("DCDx".equals(name)) {
            this.setDCDxTool((StorageDCDxTool)storage);
        } else if ("QuadSPI".equals(name)) {
            this.setQuadSPITool((StorageQuadSPITool)storage);
        } else if ("PBL".equals(name)) {
            this.setPBLTool((StoragePBLTool)storage);
        } else if ("SERDES".equals(name)) {
            this.setSERDESTool((StorageSERDESTool)storage);
        } else if ("eFUSE".equals(name)) {
            this.setEfuseTool((StorageEfuseTool)storage);
        } else if ("GTM".equals(name)) {
            this.setGtmTool((StorageGtmTool)storage);
        } else if ("ICE".equals(name)) {
            this.setIceTool((StorageIceTool)storage);
        } else assert (false) : "Tool with name '" + name + "' is not supported";
    }

    public @Nullable StorageDDRTool getDDRTool() {
        return this.ddr;
    }

    public void setDDRTool(@Nullable StorageDDRTool ddr) {
        this.ddr = ddr;
    }

    public StorageTools createShallowCopy() {
        StorageTools copy = new StorageTools();
        copy.common = this.common;
        this.getConfigurableTools().forEach(copy::setTool);
        return copy;
    }

    public Stream<@NonNull StorageTool> getConfigurableTools() {
        return this.getTools().stream().filter(t -> !"common".equals(t.getName()));
    }

    public void clearAll() {
        this.getConfigurableTools().forEach(t -> this.setTool(t.getName(), null));
    }
}

