/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.analytics;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.kex.analytics.IAnalyticDataProvider;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Event;

public class MouseListenerAnalytics
implements IAnalyticDataProvider {
    @NonNull
    public static final String ACTION_CLICK_TEST_ID = "click-test-id";
    private static final int LEFT_BUTTON = 1;
    private static final int RIGHT_BUTTON = 3;
    @NonNull
    IAnalytics analytics;
    long clicks = 0L;
    long doubleClicks = 0L;
    long[] buttons = new long[4];
    @NonNull
    ISharedConfiguration configuration;
    private final Logger LOGGER = LogManager.getLogger(MouseListenerAnalytics.class);

    public MouseListenerAnalytics(@NonNull IAnalytics analytics) {
        this.analytics = analytics;
        this.configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
    }

    public void mouseDown(Event e) {
        if (e.count == 1) {
            ++this.clicks;
        } else {
            ++this.doubleClicks;
        }
        if (e.button >= 0 && e.button < this.buttons.length) {
            int n = e.button;
            this.buttons[n] = this.buttons[n] + 1L;
        }
        if (e.widget != null) {
            Object data = e.widget.getData("test-id");
            if (data instanceof String) {
                Object detailObj = e.widget.getData("analytics-detail");
                String detail = detailObj instanceof String ? (String)detailObj : null;
                this.analytics.logUserAction(2, this.configuration.getUUID(), ACTION_CLICK_TEST_ID, (String)data, detail);
                this.LOGGER.fine(() -> MessageFormat.format("test-id: Clicked on: {0}", data));
            } else {
                this.LOGGER.fine(() -> MessageFormat.format("test-id: Class {0} does not have the attribute set.", event.widget.getClass().getCanonicalName()));
            }
        }
    }

    public void flushData(IAnalytics analyticsInstance) {
        analyticsInstance.logUserAction("session_statistics", "clicks", Long.toString(this.clicks));
        analyticsInstance.logUserAction("session_statistics", "doubleClicks", Long.toString(this.doubleClicks));
        analyticsInstance.logUserAction("session_statistics", "button1Count", Long.toString(this.buttons[1]));
        analyticsInstance.logUserAction("session_statistics", "button3Count", Long.toString(this.buttons[3]));
    }
}

