/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.analytics;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class ActionWithAnalytics
extends Action {
    private final Logger LOGGER = LogManager.getLogger(ActionWithAnalytics.class);

    public ActionWithAnalytics() {
    }

    public ActionWithAnalytics(@NonNull String text, int style) {
        super(text, style);
    }

    public ActionWithAnalytics(@NonNull String text, @Nullable ImageDescriptor image) {
        super(text, image);
    }

    public ActionWithAnalytics(@NonNull String text) {
        super(text);
    }

    public @NonNull String getAnalyticsId() {
        String actionId = this.getId();
        if (actionId == null) {
            this.LOGGER.warning("Action ID for analytics not defined");
            actionId = ((Object)((Object)this)).getClass().getCanonicalName();
            assert (actionId != null) : "Null actionId for " + (Object)((Object)this);
        }
        return actionId;
    }

    public void logAnalytics() {
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SWToolsPlatform.getAnalytics().logUserAction(configuration.getUUID(), "click-test-id", this.getAnalyticsId());
    }

    public void run() {
        super.run();
        this.logAnalytics();
    }
}

