/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.preferences.internal.ui;

import com.nxp.s32ds.cle.ide.variables.preferences.CleVariablesManager;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSValueVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariableEditDialog;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesFilteredTreeViewer;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesGroup;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class S32DSVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TreeViewer treeViewer;
    private Button editButton;
    private S32DSVariablesGroup[] input;

    public S32DSVariablesPreferencePage() {
        this.setDescription(Messages.S32DSVariablesPreferencePage_configure_s32ds_variables);
        this.input = (S32DSVariablesGroup[])CleVariablesManager.getInstance().getCategories().stream().map(c -> new S32DSVariablesGroup(c.getName(), c.getVariables().stream().map(S32DSVariable::create).collect(Collectors.toList()))).toArray(S32DSVariablesGroup[]::new);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        this.createTree(composite);
        this.createEditButton(composite);
        this.noDefaultAndApplyButton();
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        Arrays.stream(this.input).flatMap(g -> g.getChildren().stream()).filter(S32DSVariable::isChanged).forEach(S32DSVariable::applyChanges);
        return super.performOk();
    }

    protected void performDefaults() {
        Arrays.stream(this.input).flatMap(g -> g.getChildren().stream()).filter(S32DSVariable::isChanged).forEach(S32DSVariable::restoreDefault);
        this.treeViewer.refresh();
        super.performDefaults();
    }

    private void createTree(Composite parent) {
        S32DSVariablesFilteredTreeViewer filteredTreeViewer = new S32DSVariablesFilteredTreeViewer(parent);
        this.treeViewer = filteredTreeViewer.getViewer();
        this.treeViewer.setInput((Object)this.input);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!S32DSVariablesPreferencePage.this.treeViewer.getSelection().isEmpty() && S32DSVariablesPreferencePage.this.editButton.isEnabled()) {
                    S32DSVariablesPreferencePage.this.handleEdit();
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                S32DSVariablesPreferencePage.this.handleSelectionChanged(event);
            }
        });
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (sel.size() == 1) {
            Object firstElement = sel.getFirstElement();
            this.editButton.setEnabled(firstElement instanceof S32DSVariable && !((S32DSVariable)firstElement).isReadOnly());
        } else {
            this.editButton.setEnabled(false);
        }
    }

    private void createEditButton(Composite parent) {
        this.editButton = new Button(parent, 8);
        this.editButton.setText(Messages.S32DSVariablesPreferencePage_edit);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                S32DSVariablesPreferencePage.this.handleEdit();
            }
        });
        this.editButton.setEnabled(false);
    }

    private void handleEdit() {
        Object firstElement = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (firstElement instanceof S32DSValueVariable) {
            S32DSValueVariable var = (S32DSValueVariable)firstElement;
            S32DSVariableEditDialog dlg = new S32DSVariableEditDialog(this.getShell(), var);
            if (dlg.open() == 0) {
                this.treeViewer.update((Object)var, null);
            }
        }
    }
}

