/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.preferences.internal.ui;

import com.nxp.s32ds.cle.ide.variables.preferences.CleDynamicVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.CleValueVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.CleVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSDynamicVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSValueVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesGroup;
import java.util.Objects;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public abstract class S32DSVariable {
    private S32DSVariablesGroup parent;
    protected final CleVariable variable;
    protected String value;

    public static S32DSVariable create(CleVariable variable) {
        if (variable instanceof CleDynamicVariable) {
            return new S32DSDynamicVariable((CleDynamicVariable)variable);
        }
        if (variable instanceof CleValueVariable) {
            return new S32DSValueVariable((CleValueVariable)variable);
        }
        throw new IllegalStateException("Unknown variable type " + variable.getClass().getName());
    }

    protected S32DSVariable(CleVariable variable) {
        this.variable = variable;
        this.value = this.extractValue();
    }

    protected abstract String extractValue();

    public CleVariable getCleVariable() {
        return this.variable;
    }

    protected IStringVariable getEclipseVariable() {
        return this.variable.getEclipseVariable();
    }

    public String getName() {
        return this.getEclipseVariable().getName();
    }

    public String getDescription() {
        return this.getEclipseVariable().getDescription();
    }

    public void setDescription(String description) {
        throw new UnsupportedOperationException();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean isChanged() {
        return false;
    }

    public void applyChanges() {
    }

    public void restoreDefault() {
    }

    public String getContributor() {
        return VariablesPlugin.getDefault().getStringVariableManager().getContributingPluginId(this.getEclipseVariable());
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setParent(S32DSVariablesGroup parent) {
        this.parent = parent;
    }

    public S32DSVariablesGroup getParent() {
        return this.parent;
    }

    public String asStringForClipboard() {
        return NLS.bind((String)Messages.S32DSVariable_0_1_2_3, (Object[])new Object[]{this.getName(), this.value, this.getDescription(), this.getContributor()});
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.variable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof S32DSVariable)) {
            return false;
        }
        S32DSVariable other = (S32DSVariable)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.variable, other.variable);
    }
}

