/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionBase;
import java.util.ArrayList;
import java.util.Arrays;

public class SdkOptionSimple
extends SdkOptionBase {
    @NonNull
    protected final String value;

    public SdkOptionSimple(@NonNull String optionId, @NonNull String name, @NonNull String value, @NonNull String typeAsString, @NonNull String @NonNull [] variants) {
        super(optionId, name, typeAsString, variants);
        assert (!this.getType().equals((Object)SdkOptionBase.SdkOptionType.STRING_LIST));
        this.value = value;
    }

    public SdkOptionSimple(@NonNull String optionId, @NonNull String name, @NonNull String value, @NonNull SdkOptionBase.SdkOptionType type, @NonNull String @NonNull [] variants) {
        super(optionId, name, type.getId(), variants);
        assert (!this.getType().equals((Object)SdkOptionBase.SdkOptionType.STRING_LIST));
        this.value = value;
    }

    public @NonNull String getValue() {
        return this.value;
    }

    public boolean getBooleanValue() {
        if (this.type != SdkOptionBase.SdkOptionType.BOOLEAN) {
            throw new IllegalStateException("Method is applicable only for the BOOLEAN type. Current type is: " + this.type.toString());
        }
        return Boolean.parseBoolean(this.getValue());
    }

    @Override
    public SdkOptionBase resolveVariables(SdkManifestDescriptor.ManifestHelper variablesResolver) {
        switch (this.getType()) {
            case STRING: 
            case STATE: 
            case ENUM: {
                String resolvedValue = variablesResolver.resolveVariables(this.getValue());
                if (resolvedValue.equals(this.getValue())) {
                    return this;
                }
                return new SdkOptionSimple(this.optionId, this.name, resolvedValue, this.type, this.variants);
            }
            case BOOLEAN: {
                return this;
            }
        }
        assert (false);
        return this;
    }

    @Override
    public SdkOptionBase clone4Configuration(@NonNull String configuration) {
        assert ((this.getConfigurationName() == null || this.getConfigurationName().isEmpty()) && !configuration.isEmpty());
        ArrayList<@NonNull String> list4arr = new ArrayList<String>();
        list4arr.addAll(Arrays.asList(this.variants));
        list4arr.add("Configuration_" + configuration);
        return new SdkOptionSimple(this.optionId, this.name, this.value, this.type, CollectionsUtils.toStringArr(list4arr));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SdkOptionSimple)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SdkOptionSimple opt = (SdkOptionSimple)obj;
        if (!this.value.equals(opt.value)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 11 + this.value.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getId()) + '/' + this.getName() + ':' + this.typeString + '=' + this.value;
    }
}

