/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;

@NonNullByDefault
public class SdkIncludePath {
    private final String path;
    @Nullable
    private final String pathSdk;
    @Nullable
    final String compiler;
    @Nullable
    private final Collection<@NonNull String> deviceCoreIds;
    @Nullable
    private final Collection<@NonNull String> toolchains;
    final IncludeType type;

    public SdkIncludePath(String path, @Nullable String pathSdk, @Nullable String compilerId, @Nullable Collection<@NonNull String> deviceCoreIds, @Nullable Collection<@NonNull String> toolchains, IncludeType type) {
        assert (compilerId == null || toolchains == null);
        this.path = path;
        this.pathSdk = pathSdk;
        this.compiler = compilerId;
        this.deviceCoreIds = deviceCoreIds != null ? CollectionsUtils.unmodifiableCollection(deviceCoreIds) : null;
        this.toolchains = toolchains != null ? CollectionsUtils.unmodifiableCollection(toolchains) : null;
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public @Nullable String getPathSdk() {
        return this.pathSdk;
    }

    public @Nullable String getCompilerId() {
        return this.compiler;
    }

    public @Nullable Collection<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public boolean isForToolchain(String toolchainId) {
        return this.toolchains != null ? this.toolchains.contains(toolchainId) : true;
    }

    public boolean isDeviceCoreSupported(String coreId) {
        return this.deviceCoreIds != null ? this.deviceCoreIds.contains(coreId) : true;
    }

    public IncludeType getType() {
        return this.type;
    }

    public static @Nullable List<@NonNull SdkIncludePath> loadCompIncludePath(Element componentElem) {
        List<SdkIncludePath> list = SdkIncludePath.loadIncludePath(componentElem, "project_relative_path", "relative_path");
        String projBasePath = componentElem.getAttribute("project_base_path");
        String packBasePath = componentElem.getAttribute("package_base_path");
        return list == null ? null : (List)list.stream().map(f -> {
            String srcPath = UtilsFile.toEclipsePath((String)Paths.get(projBasePath, f.getPath()).normalize().toString());
            String sdkSrcPath = f.getPathSdk();
            if (sdkSrcPath != null) {
                sdkSrcPath = UtilsFile.toEclipsePath((String)Paths.get(packBasePath, sdkSrcPath).normalize().toString());
            }
            return new SdkIncludePath(srcPath, sdkSrcPath, f.compiler, f.deviceCoreIds, f.toolchains, f.type);
        }).collect(CollectorsUtils.toList());
    }

    public static @Nullable List<@NonNull SdkIncludePath> loadExamIncludePath(Element exampleElem) {
        return SdkIncludePath.loadIncludePath(exampleElem, "project_relative_path", "path");
    }

    public static @Nullable List<SdkIncludePath> loadOldCompExamIncludePath_manifest3_7(Element parentElem) {
        return SdkIncludePath.loadIncludePath(parentElem, "path", null);
    }

    static @Nullable List<SdkIncludePath> loadIncludePath(Element parentElem, String incPathAttributeName, @Nullable String pacakgeIncPathAttributeName) {
        Element inclPathsElem = ManifestLoaderUtils.getChildElementByName(parentElem, "include_paths");
        if (inclPathsElem == null) {
            return null;
        }
        ArrayList<@NonNull SdkIncludePath> result = new ArrayList<SdkIncludePath>();
        List<Element> includePathElems = ManifestLoaderUtils.getChildrenElements(inclPathsElem, "include");
        includePathElems.addAll(ManifestLoaderUtils.getChildrenElements(inclPathsElem, "include_path"));
        for (Element inclPath : includePathElems) {
            String srcPath = inclPath.hasAttribute(incPathAttributeName) || pacakgeIncPathAttributeName == null ? inclPath.getAttribute(incPathAttributeName) : inclPath.getAttribute(pacakgeIncPathAttributeName);
            String sdkSrcPath = pacakgeIncPathAttributeName != null ? inclPath.getAttribute(pacakgeIncPathAttributeName) : null;
            String compilerId = inclPath.hasAttribute("compiler") ? inclPath.getAttribute("compiler") : null;
            List<String> toolchains = null;
            List<String> deviceCoreIds = null;
            if (inclPath.hasAttribute("device_cores")) {
                deviceCoreIds = Arrays.asList(inclPath.getAttribute("device_cores").split(" "));
            }
            if (inclPath.hasAttribute("toolchain")) {
                toolchains = Arrays.asList(inclPath.getAttribute("toolchain").split(" "));
            }
            String type = inclPath.getAttribute("type");
            if (srcPath.isEmpty()) continue;
            result.add(new SdkIncludePath(srcPath, UtilsText.isEmpty((String)sdkSrcPath) ? null : sdkSrcPath, compilerId, deviceCoreIds, toolchains, IncludeType.get(type)));
        }
        return result;
    }

    public static enum IncludeType {
        GENERAL_INCLUDE(""),
        C_INCLUDE("c_include"),
        ASM_INCLUDE("asm_include");

        private String typeName;

        private IncludeType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public static IncludeType get(String manifestTypeName) throws IllegalArgumentException {
            IncludeType result = (IncludeType)((Object)CollectionsUtils.findAny(Arrays.stream(IncludeType.values()), t -> manifestTypeName.equals(t.getTypeName())));
            if (result == null) {
                throw new IllegalArgumentException("Unsupported include type in defition:" + manifestTypeName);
            }
            return result;
        }
    }
}

