/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.ASdkProjectExample;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;

@NonNullByDefault
public class SdkBoardExample
extends ASdkProjectExample {
    @Nullable
    private SdkBoardsDescriptor.SdkBoardDescriptor parentBoard;
    @Nullable
    private final String mcuXpressoExmplPrjRelPath;
    @Nullable
    private final String linkedSlaveProjectIds;
    @Nullable
    private SdkBoardExample linkedSlaveProject = null;
    @Nullable
    private SdkBoardExample linkedMasterProject = null;

    public SdkBoardExample(String id, String name, String category, String path, @Nullable String description, List<@NonNull SdkSourceFile> srcFiles, @Nullable List<@NonNull SdkIncludePath> includePaths, Collection<@NonNull String> dependencies, @Nullable Collection<@NonNull String> devices, @Nullable Collection<@NonNull String> toolchains, @Nullable Collection<@NonNull String> compilers, @Nullable String mcuXpressoExmplPrjRelPath, @Nullable String deviceCoreId, @Nullable String linkedProject, ASdkProjectExample.ProjectExampleType type) {
        super(id, name, category, path, description, srcFiles, includePaths, dependencies, devices, toolchains, compilers, deviceCoreId, type);
        this.mcuXpressoExmplPrjRelPath = mcuXpressoExmplPrjRelPath;
        this.linkedSlaveProjectIds = linkedProject;
    }

    @Override
    public @Nullable String getMcuXpressoExamplePrjRelPath() {
        return this.mcuXpressoExmplPrjRelPath;
    }

    @Override
    public @Nullable SdkDeviceDescriptor getParentProcessor() {
        SdkBoardsDescriptor.SdkBoardDescriptor board = this.getParentBoard();
        return board == null ? null : board.getProcessor();
    }

    public void setParentBoard(SdkBoardsDescriptor.SdkBoardDescriptor board) {
        this.parentBoard = board;
    }

    @Override
    public  @Nullable SdkBoardsDescriptor.SdkBoardDescriptor getParentBoard() {
        return this.parentBoard;
    }

    @Override
    public String getFullName4UI() {
        return this.getLinkedProjectIds().isEmpty() ? String.valueOf(this.category) + '/' + this.name : this.category;
    }

    @Override
    public String getFullName4CmdLineTest() {
        int pp;
        String brdId;
        String result = this.id;
        SdkBoardsDescriptor.SdkBoardDescriptor brd = this.getParentBoard();
        String string = brdId = brd != null ? brd.getId() : "#_unknwon_board_@";
        if (result.startsWith(brdId)) {
            result = result.substring(brdId.length() + 1);
        }
        if (result.endsWith("_example")) {
            result = result.substring(0, result.length() - 8);
        }
        if ((pp = result.indexOf("_examples_")) > 0 && (result = String.valueOf(result.substring(0, pp)) + result.substring(pp + 9)).substring(pp + 1, 2 * pp + 2).equals(result.substring(0, pp + 1))) {
            result = result.substring(pp + 1);
        }
        return UtilsText.isIdentifier((CharSequence)result) ? result : UtilsText.toCIdentifier((String)result);
    }

    public @Nullable String getLinkedProjectIdsString() {
        return this.linkedSlaveProjectIds;
    }

    @Override
    public Collection<@NonNull String> getLinkedProjectIds() {
        String ids = this.linkedSlaveProjectIds;
        if (UtilsText.isEmpty((String)ids)) {
            return Collections.emptyList();
        }
        assert (ids != null);
        return Arrays.asList(ids.split(" "));
    }

    public void setLinkedSlaveProject(SdkBoardExample slaveExamplePrj) {
        this.linkedSlaveProject = slaveExamplePrj;
        slaveExamplePrj.setLinkedMasterProject(this);
        if (!this.category.equals(slaveExamplePrj.category)) {
            LOGGER.log(Level.SEVERE, "slave and master project path are in different categories");
            assert (false);
        }
    }

    @Override
    public @Nullable SdkBoardExample getLinkedSlaveProject() {
        SdkBoardExample result = this.linkedSlaveProject;
        String otherPrjId = this.linkedSlaveProjectIds;
        if (otherPrjId != null ? !$assertionsDisabled && result == null && (this.linkedMasterProject == null || !otherPrjId.equals(Objects.requireNonNull(this.linkedMasterProject).id)) : !$assertionsDisabled && result != null) {
            throw new AssertionError();
        }
        return result;
    }

    public void setLinkedMasterProject(SdkBoardExample masterExamplePrj) {
        this.linkedMasterProject = masterExamplePrj;
        assert (this.getLinkedSlaveProject() == null);
    }

    @Override
    public @Nullable SdkBoardExample getLinkedMasterProject() {
        return this.linkedMasterProject;
    }

    @Override
    public boolean isBoardSpecific() {
        return true;
    }
}

