/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.gdb.internal.memory.Messages;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;

public class GdbMemoryBlock
extends DsfMemoryBlock
implements IMemorySpaceAwareMemoryBlock {
    private final String fMemorySpaceID;

    public GdbMemoryBlock(DsfMemoryBlockRetrieval retrieval, IMemory.IMemoryDMContext context, String modelId, String expression, BigInteger address, int word_size, long length, String memorySpaceID) {
        super(retrieval, context, modelId, expression, address, word_size, length);
        String string = this.fMemorySpaceID = memorySpaceID != null && !memorySpaceID.isEmpty() ? memorySpaceID : null;
        assert (memorySpaceID == null || !memorySpaceID.isEmpty());
        if (memorySpaceID != null) {
            assert (context instanceof IMemorySpaces.IMemorySpaceDMContext);
            assert (memorySpaceID.equals(((IMemorySpaces.IMemorySpaceDMContext)context).getMemorySpaceId()));
        } else if (context instanceof IMemorySpaces.IMemorySpaceDMContext) assert (((IMemorySpaces.IMemorySpaceDMContext)context).getMemorySpaceId() == null);
    }

    public String getMemorySpaceID() {
        return this.fMemorySpaceID;
    }

    public String getExpression() {
        if (this.fMemorySpaceID != null) {
            assert (!this.fMemorySpaceID.isEmpty());
            GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
            return retrieval.encodeAddress(super.getExpression(), this.fMemorySpaceID);
        }
        return super.getExpression();
    }

    public int getAddressSize() throws DebugException {
        GdbMemoryBlockRetrieval retrieval = (GdbMemoryBlockRetrieval)this.getMemoryBlockRetrieval();
        IGDBMemory memoryService = (IGDBMemory)retrieval.getServiceTracker().getService();
        if (memoryService != null) {
            return memoryService.getAddressSize(this.getContext());
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, Messages.Err_MemoryServiceNotAvailable, null));
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        super.eventDispatched(e);
        if (e.getReason() == IRunControl.StateChangeReason.BREAKPOINT || e.getReason() == IRunControl.StateChangeReason.EVENT_BREAKPOINT || e.getReason() == IRunControl.StateChangeReason.WATCHPOINT) {
            DebugEvent debugEvent = new DebugEvent((Object)this, 2, 16);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }

    public static class MemorySpaceDMContext
    extends AbstractDMContext
    implements IMemorySpaces.IMemorySpaceDMContext {
        private final String fMemorySpaceId;

        public MemorySpaceDMContext(String sessionId, String memorySpaceId, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            assert (memorySpaceId != null);
            this.fMemorySpaceId = memorySpaceId == null ? "" : memorySpaceId;
        }

        public String getMemorySpaceId() {
            return this.fMemorySpaceId;
        }

        public boolean equals(Object other) {
            if (other instanceof MemorySpaceDMContext) {
                MemorySpaceDMContext dmc = (MemorySpaceDMContext)((Object)other);
                return super.baseEquals(other) && dmc.fMemorySpaceId.equals(this.fMemorySpaceId);
            }
            return false;
        }

        public int hashCode() {
            return super.baseHashCode() + this.fMemorySpaceId.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".memoryspace[" + this.fMemorySpaceId + ']';
        }
    }
}

