/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.viewers;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.manifest.xml.BoardType;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.ExampleType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.Manifest;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.s32ds.cle.uct.ui.types.Category;
import com.nxp.s32ds.cle.uct.ui.types.WrapperType;
import com.nxp.s32ds.cle.uct.ui.viewers.ISDKPropertiesPage;
import com.nxp.s32ds.cle.uct.ui.viewers.IdentifierSorter;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;

public class IdentifiableViewer
extends Composite
implements ISelectionProvider {
    private static final String DECORATOR_TEXT = Messages.IdentifiableViewer_UnselOtherComp;
    public static final String ADD_ONS = "add.ons";
    public static final String STANDARD_TOOLS = "standard.tools";
    private static Image IMG_CATEGORY = Activator.getDefault().getImage("img.examples.category");
    private static Image IMG_EXAMPLE = Activator.getDefault().getImage("img.examples.item");
    private static Image IMG_COMPONENT = Activator.getDefault().getImage("img.view.sdk.component");
    private String[] columnProperties = new String[]{Messages.IdentifiableViewer_Name, Messages.IdentifiableViewer_Version};
    public int[] columnWeights = new int[]{60, 30};
    private CheckboxTreeViewer fViewer;
    private DeviceFilter filter;
    private Object userSelected = null;
    private List<IdentifiableType> elements = new ArrayList<IdentifiableType>();
    private boolean mutualExclusive = false;
    public BoardType board;
    public ISDKManifest manifest;
    public static Color COLOR_BLACK = Display.getCurrent().getSystemColor(2);
    public static Color COLOR_LINKED = Display.getCurrent().getSystemColor(8);
    public static Color COLOR_EXTERNAL = Display.getCurrent().getSystemColor(9);
    public static Color COLOR_ERROR = Display.getCurrent().getSystemColor(3);
    public static Color COLOR_DEPENDENCY = Display.getCurrent().getSystemColor(15);
    private List<ComponentType> dependencies = new ArrayList<ComponentType>();
    public static final int CHECKED_ALL = 0;
    public static final int CHECKED_NONE = 1;
    public static final int CHECKED_SOME = 2;
    public static final int CHECKED_NULL = 3;
    protected static final Logger LOGGER = LogManager.getLogger(IdentifiableViewer.class);
    public static final String KEY_MANIFEST = "manifest";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_PROJECT_CONTENT = "project.content";
    public static final String KEY_EXAMPLES_IMPORTED = "wizard.examples.imported";
    public static final String KEY_DEVICE_CORE = "device.core";
    public static final String KEY_CORE_ROLE = "core.role";
    private ComponentTypeEnum componentType;
    private NameFilter nameFilter = new NameFilter();
    private Text filterText;
    private Action selectAll;
    private Action deselectAll;
    private Action cleanFilter;
    private ISelectionChangedListener listener;
    private boolean border = true;
    private boolean initialized = false;
    private Action expandAll;
    private Action collapseAll;
    private ISDKPropertiesPage page;
    private String title;
    private ToolBarManager toolBarManager;
    private Section section;
    private Composite sectionClient;
    private ControlDecoration dec;
    private ICheckStateProvider checkstateProvider = new ICheckStateProvider(){

        public boolean isGrayed(Object element) {
            if (element instanceof Category) {
                int result = IdentifiableViewer.this.checkCategorySelected((Category)element);
                return result == 2;
            }
            return false;
        }

        public boolean isChecked(Object element) {
            if (element instanceof Category) {
                int result = IdentifiableViewer.this.checkCategorySelected((Category)element);
                return result == 2 || result == 0;
            }
            if (element instanceof WrapperType) {
                boolean result = IdentifiableViewer.this.elements.contains(((WrapperType)element).getElement());
                if (element.equals(IdentifiableViewer.this.userSelected) && result) {
                    IdentifiableViewer.this.dec.show();
                    IdentifiableViewer.this.dec.showHoverText(DECORATOR_TEXT);
                } else if (element.equals(IdentifiableViewer.this.userSelected) && !result) {
                    IdentifiableViewer.this.userSelected = null;
                    IdentifiableViewer.this.dec.hide();
                    IdentifiableViewer.this.dec.hideHover();
                }
                return result;
            }
            return false;
        }
    };

    private static String getPath(Category category) {
        String string = new String();
        Category cat = category;
        while (cat != null) {
            if (cat.getName() != null) {
                string = String.valueOf(cat.getName()) + (string.length() == 0 ? "" : "/") + string;
            }
            cat = cat.getParent();
        }
        return string;
    }

    private static List<WrapperType> getCategoryItem(String path, List<WrapperType> items) {
        ArrayList<WrapperType> catItem = new ArrayList<WrapperType>();
        for (WrapperType item : items) {
            if (item.getElement().getCategory() == null || !item.getElement().getCategory().equals(path) || catItem.contains(item)) continue;
            catItem.add(item);
        }
        return catItem;
    }

    public static void addCategoryItem(List<Category> categories, List<WrapperType> items, Boolean external, Category root) {
        for (Category category : categories) {
            for (WrapperType item : IdentifiableViewer.getCategoryItem(IdentifiableViewer.getPath(category), items)) {
                if (item.getElement() instanceof ComponentType && ((ComponentType)item.getElement()).isUserVisible()) {
                    category.getItems().add(item);
                } else if (item.getElement() instanceof ExampleType) {
                    category.getItems().add(item);
                }
                item.setCategory(category);
            }
            IdentifiableViewer.addCategoryItem(category.getChildren(), items, external, root);
        }
        for (WrapperType item : items) {
            if (item.getElement().getCategory() != null || root.getItems().contains(item)) continue;
            if (item.getElement() instanceof ComponentType && ((ComponentType)item.getElement()).isUserVisible()) {
                root.getItems().add(item);
            } else if (item.getElement() instanceof ExampleType) {
                root.getItems().add(item);
            }
            item.setCategory(root);
        }
    }

    public static void addChildrenCategory(Category parent, String[] tokens, int i) {
        if (i <= tokens.length - 1) {
            Category category = null;
            String name = tokens[i];
            for (Category cat : parent.getChildren()) {
                if (!cat.getName().equals(name)) continue;
                category = cat;
                break;
            }
            if (category == null) {
                category = new Category();
                category.setName(name);
                category.setParent(parent);
                parent.getChildren().add(category);
            }
            IdentifiableViewer.addChildrenCategory(category, tokens, i + 1);
        }
    }

    public static List<Category> buildCategories(Category root, List<WrapperType> items) {
        for (WrapperType item : items) {
            String catString = item.getElement().getCategory();
            if (catString == null) continue;
            String[] tokens = catString.split("/");
            IdentifiableViewer.addChildrenCategory(root, tokens, 0);
        }
        return root.getChildren();
    }

    public static void markExternal(ViewerCell cell, String text) {
        StyleRange myStyledRange = new StyleRange(0, text.length(), COLOR_EXTERNAL, null);
        StyleRange[] range = new StyleRange[]{myStyledRange};
        cell.setStyleRanges(range);
    }

    public boolean isDependency(ComponentType element) {
        return this.dependencies.contains(element);
    }

    public static void markLinked(ViewerCell cell, String text) {
        int start = text.indexOf(": ");
        StyleRange myStyledRange = new StyleRange(start, text.length(), COLOR_LINKED, null);
        StyleRange[] range = new StyleRange[]{myStyledRange};
        cell.setStyleRanges(range);
    }

    public IdentifiableViewer(Composite parent, Class<? extends IdentifiableType> cls, String title, FormToolkit toolkit, boolean mutualExclusive, ISDKPropertiesPage page, int[] weight) {
        super(parent, 0);
        this.page = page;
        this.title = title;
        this.mutualExclusive = mutualExclusive;
        if (weight != null) {
            this.columnWeights = weight;
        }
        this.build(cls, title, toolkit, mutualExclusive);
    }

    private void refreshViewer() {
        this.fViewer.getControl().setRedraw(false);
        TreePath[] paths = this.fViewer.getExpandedTreePaths();
        if (paths == null || paths.length == 0) {
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                int i = 0;
                while (i < path.getSegmentCount()) {
                    this.expandElement(path.getSegment(i), true);
                    ++i;
                }
                ++n2;
            }
            this.fViewer.refresh(true);
        }
        this.fViewer.getControl().setRedraw(true);
    }

    private boolean isExampleSupported(ExampleType example, DeviceType device) {
        List toolchains = example.getToolchain();
        List compilers = example.getCompiler();
        ArrayList<ToolchainType> listTC = new ArrayList<ToolchainType>();
        ArrayList<CompilerType> listComp = new ArrayList<CompilerType>();
        if (!toolchains.isEmpty()) {
            for (Object def : toolchains) {
                ToolchainType toolchain;
                if (!(def instanceof Manifest.ExternalDefinitions.Definition) || (toolchain = (ToolchainType)this.manifest.findReference((Manifest.ExternalDefinitions.Definition)def, ToolchainType.class)) == null) continue;
                listTC.add(toolchain);
            }
        } else if (!toolchains.isEmpty() && toolchains.get(0) instanceof ToolchainType) {
            listTC.addAll(toolchains);
        }
        if (!compilers.isEmpty() && compilers.get(0) instanceof Manifest.ExternalDefinitions.Definition) {
            for (Object def : compilers) {
                CompilerType compiler = (CompilerType)this.manifest.findReference((Manifest.ExternalDefinitions.Definition)def, CompilerType.class);
                if (compiler == null) continue;
                listComp.add(compiler);
            }
        } else if (!compilers.isEmpty() && compilers.get(0) instanceof CompilerType) {
            listComp.addAll(compilers);
        }
        if (SDKManifestProvider.isToolchainSupported(listTC) && SDKManifestProvider.isCompilerSupported(listComp)) {
            List cDevice = example.getDevice();
            for (Object d : cDevice) {
                DeviceType dev;
                Manifest.ExternalDefinitions.Definition def;
                if (!(d instanceof Manifest.ExternalDefinitions.Definition ? (def = (Manifest.ExternalDefinitions.Definition)d).getExtID().equals(device.getId()) : d instanceof DeviceType && (dev = (DeviceType)d).getId().equals(device.getId()))) continue;
                return true;
            }
            if (cDevice.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void build(final Class<? extends IdentifiableType> cls, String title, FormToolkit toolkit, boolean mutualExclusive) {
        this.setMutualExclusive(mutualExclusive);
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        int style = 64;
        if (title != null) {
            style |= 0x100;
        }
        this.section = toolkit.createSection((Composite)this, style);
        this.section.setLayout((Layout)layout);
        this.section.setLayoutData((Object)new GridData(4, 4, true, true));
        if (title != null) {
            this.section.setText(title);
        }
        this.section.setExpanded(true);
        this.sectionClient = toolkit.createComposite((Composite)this.section);
        this.sectionClient.setLayout((Layout)layout);
        this.sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        this.section.setClient((Control)this.sectionClient);
        this.toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = this.toolBarManager.createControl((Composite)this.section);
        toolbar.setCursor(Display.getDefault().getSystemCursor(21));
        this.toolBarManager.add((IContributionItem)new GroupMarker(ADD_ONS));
        this.toolBarManager.add((IContributionItem)new GroupMarker(STANDARD_TOOLS));
        this.addActions(this.toolBarManager);
        this.section.setTextClient((Control)toolbar);
        if (this.border) {
            this.filterText = new Text(this.sectionClient, 2048);
            this.filterText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.filterText.setMessage(Messages.IdentifiableViewer_TypeToFilter);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IdentifiableViewer.this.nameFilter.setFilterText(IdentifiableViewer.this.filterText.getText());
                    IdentifiableViewer.this.refreshViewer();
                    IdentifiableViewer.this.fViewer.refresh(true);
                }
            });
        }
        Composite composite = toolkit.createComposite(this.sectionClient, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        composite.setLayoutData((Object)gridData);
        this.fViewer = new CheckboxTreeViewer(composite, 0x304 | (this.border ? 2048 : 0) | 0x10000);
        this.fViewer.setColumnProperties(this.columnProperties);
        this.fViewer.setComparator((ViewerComparator)new IdentifierSorter());
        this.dec = new ControlDecoration(this.fViewer.getControl(), 132096);
        this.dec.setImage(Activator.getDefault().getImage("img.decorator.assistant"));
        this.dec.setShowOnlyOnFocus(false);
        this.dec.setShowHover(true);
        this.dec.setDescriptionText(DECORATOR_TEXT);
        this.dec.hideHover();
        this.dec.hide();
        int i = 0;
        while (i < this.columnProperties.length) {
            String columnProperty = this.columnProperties[i];
            TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)this.fViewer, 0);
            tvc.setLabelProvider((CellLabelProvider)new IdentifiableLabelProvider(i));
            final TreeColumn column = tvc.getColumn();
            final int c = i;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IdentifierSorter sorter = (IdentifierSorter)IdentifiableViewer.this.fViewer.getComparator();
                    sorter.doSort(c);
                    int dir = sorter.getDirection();
                    IdentifiableViewer.this.fViewer.getTree().setSortDirection(dir);
                    IdentifiableViewer.this.fViewer.getTree().setSortColumn(column);
                    IdentifiableViewer.this.fViewer.refresh();
                }
            });
            column.setText(columnProperty);
            column.setResizable(true);
            column.setMoveable(false);
            treeLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(this.columnWeights[i], true));
            ++i;
        }
        this.fViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.filter = new DeviceFilter();
        this.fViewer.setFilters(new ViewerFilter[]{this.filter, this.nameFilter});
        this.fViewer.getTree().setHeaderVisible(this.border);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean checked = event.getChecked();
                if (IdentifiableViewer.this.isMutualExclusive()) {
                    IdentifiableViewer.this.checkAll(false, true);
                    checked = IdentifiableViewer.this.subTreeChecked(element, checked, true);
                } else {
                    IdentifiableViewer.this.userSelected = null;
                    if (!checked && !ExampleType.class.equals((Object)cls)) {
                        IdentifiableViewer.this.userSelected = element;
                    }
                    checked = IdentifiableViewer.this.subTreeChecked(element, checked, true);
                }
                if (checked || ExampleType.class.equals((Object)cls)) {
                    IdentifiableViewer.this.fireListener();
                }
            }
        });
        this.fViewer.setCheckStateProvider(this.checkstateProvider);
    }

    /*
     * WARNING - void declaration
     */
    private int checkCategorySelected(Category category) {
        void var5_10;
        int result = 2;
        int count = 0;
        int size = 0;
        for (Category category2 : category.getChildren()) {
            int res = this.checkCategorySelected(category2);
            if (res != 2 && res != 0) continue;
            ++count;
        }
        for (WrapperType wrapperType : category.getItems()) {
            if (wrapperType.getElement() instanceof ComponentType) {
                ComponentType component = (ComponentType)wrapperType.getElement();
                if (!component.isUserVisible() || !this.elements.contains(wrapperType.getElement())) continue;
                ++count;
                continue;
            }
            if (!this.elements.contains(wrapperType.getElement())) continue;
            ++count;
        }
        boolean bl = false;
        for (WrapperType item : category.getItems()) {
            if (item.getElement() instanceof ComponentType) {
                ComponentType component = (ComponentType)item.getElement();
                if (!component.isUserVisible()) continue;
                ++var5_10;
                continue;
            }
            ++var5_10;
        }
        size = category.getChildren().size() + var5_10;
        result = size == 0 ? 3 : (count >= size ? 0 : (count == 0 ? 1 : 2));
        return result;
    }

    private boolean subTreeChecked(Object element, boolean checked, boolean checkDependencies) {
        if (!this.isElementVisible(element)) {
            return checked;
        }
        if (element instanceof WrapperType) {
            this.checkElement(element, checked, checkDependencies);
        } else {
            if (element instanceof IdentifiableType) {
                return this.checkElement(element, checked, checkDependencies);
            }
            if (element instanceof Category) {
                Category cat = (Category)element;
                ArrayList<Object> items = new ArrayList<Object>();
                items.addAll(cat.getChildren());
                items.addAll(cat.getItems());
                if (checked) {
                    this.fViewer.setExpandedState(element, true);
                }
                for (Object e : items) {
                    this.subTreeChecked(e, checked, checkDependencies);
                }
                this.fViewer.setChecked(element, checked);
                this.checkParent(cat.getParent());
            }
        }
        return checked;
    }

    private boolean isElementVisible(Object element) {
        if (element instanceof WrapperType) {
            return this.nameFilter.select((Viewer)this.fViewer, ((WrapperType)element).getCategory(), element);
        }
        if (element instanceof Category) {
            return this.nameFilter.select((Viewer)this.fViewer, ((Category)element).getParent(), element);
        }
        if (element instanceof IdentifiableType) {
            if (element instanceof ComponentType) {
                ComponentType component = (ComponentType)element;
                return component.isUserVisible();
            }
            return true;
        }
        return false;
    }

    private void checkParent(Category category) {
        if (category == null) {
            return;
        }
        int result = this.checkCategorySelected(category);
        boolean grayed = false;
        boolean checked = false;
        switch (result) {
            case 0: {
                grayed = false;
                checked = true;
                break;
            }
            case 3: {
                grayed = false;
                checked = false;
                break;
            }
            case 1: {
                grayed = false;
                checked = true;
                break;
            }
            case 2: {
                grayed = true;
                checked = true;
            }
        }
        this.fViewer.setChecked((Object)category, checked);
        this.fViewer.setGrayed((Object)category, grayed);
        this.checkParent(category.getParent());
    }

    private boolean checkElement(Object element, boolean checked, boolean checkDependencies) {
        this.getParent().setCursor(Display.getDefault().getSystemCursor(1));
        ComponentType component = null;
        if (element instanceof ComponentType) {
            component = (ComponentType)element;
            ArrayList listCompCores = new ArrayList();
            List cores = component.getDeviceCores();
            ISDKManifest pack = (ISDKManifest)this.page.getProps().get(KEY_MANIFEST);
            CoreType core = (CoreType)this.page.getProps().get(KEY_DEVICE_CORE);
            String role = (String)this.page.getProps().get(KEY_CORE_ROLE);
            SDKManifestProvider.buildCoresList((ISDKManifest)pack, listCompCores, (List)cores);
            if (!SDKManifestProvider.isCoreSupported(listCompCores, (CoreType)core, (String)role)) {
                String message = NLS.bind((String)Messages.IdentifiableViewer_SelItemNotAvail, (Object[])new Object[]{component.getName(), core.getType().value(), role != null ? " ('" + role + "')" : ""});
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.title, (String)message);
                this.fViewer.setChecked(element, false);
                this.addRemove(element, false, checkDependencies);
                this.getParent().setCursor(Display.getDefault().getSystemCursor(0));
                return false;
            }
        }
        if (element instanceof ExampleType && !this.isExampleSupported((ExampleType)element, (DeviceType)this.page.getProps().get(KEY_DEVICE))) {
            this.getParent().setCursor(Display.getDefault().getSystemCursor(0));
            return false;
        }
        if (element instanceof WrapperType) {
            WrapperType wrapper = (WrapperType)element;
            ComponentType componentType = component = wrapper.getElement() instanceof ComponentType ? (ComponentType)wrapper.getElement() : null;
            if (wrapper.getElement() instanceof ExampleType && !this.isExampleSupported((ExampleType)wrapper.getElement(), (DeviceType)this.page.getProps().get(KEY_DEVICE))) {
                this.getParent().setCursor(Display.getDefault().getSystemCursor(0));
                return false;
            }
        }
        if (this.isMutualExclusive() && checked && !this.elements.isEmpty() && (component == null || component.isUserVisible())) {
            this.checkAll(false, checkDependencies);
        }
        this.fViewer.setChecked(element, checked);
        if (element instanceof WrapperType) {
            this.addRemove(((WrapperType)element).getElement(), checked, checkDependencies);
            Category category = ((WrapperType)element).getCategory();
            this.checkParent(category);
        } else {
            this.addRemove(element, checked, checkDependencies);
        }
        this.checkLinked(element, checked);
        this.getParent().setCursor(Display.getDefault().getSystemCursor(0));
        return checked;
    }

    private void checkLinked(Object element, boolean checked) {
        WrapperType wrapper;
        ExampleType example = null;
        if (element instanceof ExampleType) {
            example = (ExampleType)element;
        } else if (element instanceof WrapperType && (wrapper = (WrapperType)element).getElement() instanceof ExampleType) {
            example = (ExampleType)wrapper.getElement();
        }
        if (example != null && !example.getLinkedProjects().isEmpty()) {
            for (Object linked : example.getLinkedProjects()) {
                ExampleType ex;
                if (linked instanceof ExampleType) {
                    this.setChecked(new WrapperType((IdentifiableType)linked, null), checked, false);
                    continue;
                }
                if (!(linked instanceof Manifest.ExternalDefinitions.Definition) || (ex = (ExampleType)this.manifest.findReference((Manifest.ExternalDefinitions.Definition)linked, ExampleType.class)) != null) continue;
                ex = this.findExternalExamples(((Manifest.ExternalDefinitions.Definition)linked).getExtID());
                if (ex != null && this.page.getProps().get(KEY_EXAMPLES_IMPORTED) != null) {
                    ((List)this.page.getProps().get(KEY_EXAMPLES_IMPORTED)).add(ex);
                }
                if (ex == null) break;
                this.setChecked(new WrapperType((IdentifiableType)ex, null), checked, false);
                break;
            }
        }
    }

    private void addActions(ToolBarManager toolBarManager) {
        this.cleanFilter = new Action("clean.filter"){

            public void run() {
                IdentifiableViewer.this.nameFilter.setFilterText("");
                IdentifiableViewer.this.refreshViewer();
                IdentifiableViewer.this.filterText.setText("");
            }
        };
        this.cleanFilter.setToolTipText(Messages.IdentifiableViewer_ClearFilter);
        this.cleanFilter.setImageDescriptor(Activator.getDefault().getImageDescriptor("img.clean.filter"));
        this.selectAll = new Action("select.all"){

            public void run() {
                IdentifiableViewer.this.checkAll(true, true);
            }
        };
        this.selectAll.setToolTipText(Messages.IdentifiableViewer_SelAll);
        this.selectAll.setImageDescriptor(Activator.getDefault().getImageDescriptor("img.select.all"));
        this.deselectAll = new Action("deselect.all"){

            public void run() {
                IdentifiableViewer.this.checkAll(false, false);
            }
        };
        this.deselectAll.setToolTipText(Messages.IdentifiableViewer_DeselAll);
        this.deselectAll.setImageDescriptor(Activator.getDefault().getImageDescriptor("img.select.none"));
        this.expandAll = new Action("expand.all"){

            public void run() {
                IdentifiableViewer.this.fViewer.expandAll();
            }
        };
        this.expandAll.setToolTipText(Messages.IdentifiableViewer_ExpandAll);
        this.expandAll.setImageDescriptor(Activator.getDefault().getImageDescriptor("img.expand.all"));
        this.collapseAll = new Action("collapse.all"){

            public void run() {
                IdentifiableViewer.this.fViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(Messages.IdentifiableViewer_CollapseAll);
        this.collapseAll.setImageDescriptor(Activator.getDefault().getImageDescriptor("img.collapse.all"));
        if (this.border) {
            toolBarManager.appendToGroup(STANDARD_TOOLS, (IAction)this.cleanFilter);
        }
        if (!this.isMutualExclusive()) {
            toolBarManager.appendToGroup(STANDARD_TOOLS, (IAction)this.selectAll);
            toolBarManager.appendToGroup(STANDARD_TOOLS, (IAction)this.deselectAll);
        }
        toolBarManager.appendToGroup(STANDARD_TOOLS, (IContributionItem)new Separator());
        toolBarManager.appendToGroup(STANDARD_TOOLS, (IAction)this.expandAll);
        toolBarManager.appendToGroup(STANDARD_TOOLS, (IAction)this.collapseAll);
        toolBarManager.update(true);
    }

    private void checkAll(boolean checked, boolean checkDependencies) {
        if (checked) {
            this.fViewer.expandAll();
        } else {
            this.fViewer.collapseAll();
        }
        Object input = this.fViewer.getInput();
        if (input != null && input instanceof List) {
            List elements = (List)input;
            for (Object element : elements) {
                this.subTreeChecked(element, checked, checkDependencies);
            }
        } else if (input != null && input instanceof Map) {
            Map elements = (Map)input;
            for (Object element : elements.values()) {
                for (Object item : (List)element) {
                    this.subTreeChecked(item, checked, checkDependencies);
                }
            }
        }
        this.fireListener();
    }

    private void fireListener() {
        if (this.listener != null) {
            this.listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(this.getContent())));
        }
    }

    public void initialize(List<? extends ComponentType> components, List<ComponentType> dependencies) {
        if (components != null) {
            for (ComponentType componentType : components) {
                this.setChecked(new WrapperType((IdentifiableType)componentType, null), true, dependencies.contains(componentType));
            }
            if (this.fViewer != null) {
                this.fViewer.refresh(true);
            }
        }
    }

    public void setInput(ISDKManifest pack, Map<Boolean, List<WrapperType>> input, DeviceType device, BoardType board) {
        this.manifest = pack;
        if (pack != null) {
            List<WrapperType> list;
            if (this.board != board || board == null) {
                this.board = board;
                this.filter.setDevice(device);
                this.fViewer.setInput(input);
                this.fViewer.refresh(true);
                this.initialized = false;
            }
            if (!this.initialized && input != null && (list = input.get(Boolean.FALSE)) != null) {
                for (WrapperType item : list) {
                    ComponentType component;
                    if (!(item.getElement() instanceof ComponentType) || !(component = (ComponentType)item.getElement()).getType().equals((Object)ComponentTypeEnum.OS) || !component.getName().equalsIgnoreCase("baremetal")) continue;
                    this.setChecked(new WrapperType((IdentifiableType)component, null), true, false);
                    this.addRemove(component, true, true);
                    this.initialized = true;
                    this.fViewer.refresh(true);
                    break;
                }
            }
        } else {
            this.elements.clear();
            this.filter.setDevice(null);
            this.fViewer.setInput(null);
        }
    }

    public void setEnabled(boolean enabled) {
        this.cleanFilter.setEnabled(enabled);
        this.deselectAll.setEnabled(enabled);
        this.selectAll.setEnabled(enabled);
        this.fViewer.getTree().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public List<? extends IdentifiableType> getContent() {
        return this.elements;
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.fViewer.addPostSelectionChangedListener(listener);
        this.listener = listener;
    }

    public boolean isMutualExclusive() {
        return this.mutualExclusive;
    }

    public void setMutualExclusive(boolean mutualExclusive) {
        this.mutualExclusive = mutualExclusive;
    }

    public CheckboxTreeViewer getViewer() {
        return this.fViewer;
    }

    public BoardType getBoard() {
        return this.board;
    }

    public ISDKManifest getManifest() {
        return this.manifest;
    }

    public ComponentTypeEnum getComponentType() {
        return this.componentType;
    }

    public void setComponentType(ComponentTypeEnum componentType) {
        this.componentType = componentType;
    }

    private void addRemove(Object element, boolean checked, boolean checkDependencies) {
        block8: {
            block9: {
                ComponentType component;
                if (!(element instanceof IdentifiableType)) break block8;
                IdentifiableType type = (IdentifiableType)element;
                if (type instanceof ComponentType && !(component = (ComponentType)type).isUserVisible()) {
                    return;
                }
                if (!checked) break block9;
                boolean add = true;
                for (IdentifiableType item : this.elements) {
                    if (!item.getId().equals(type.getId())) continue;
                    add = false;
                    break;
                }
                if (!add) break block8;
                this.elements.add(type);
                if (!(type instanceof ComponentType)) break block8;
                try {
                    this.manifest.getDependencies((ComponentType)type, this.dependencies);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                this.fViewer.refresh(true);
                break block8;
            }
            this.dependencies.clear();
            this.elements.remove(element);
            if (checkDependencies) {
                for (IdentifiableType item : this.elements) {
                    if (!(item instanceof ComponentType)) continue;
                    try {
                        this.manifest.getDependencies((ComponentType)item, this.dependencies);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    this.fViewer.refresh(true);
                }
            }
        }
    }

    private ExampleType findExternalExamples(String id) {
        Map map;
        List list;
        Object input = this.fViewer.getInput();
        if (input instanceof Map && (list = (List)(map = (Map)input).get(Boolean.TRUE)) != null) {
            for (WrapperType example : list) {
                ExampleType ex;
                if (example.getElement() == null || !(example.getElement() instanceof ExampleType) || !(ex = (ExampleType)example.getElement()).getId().equals(id)) continue;
                return ex;
            }
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public boolean setFocus() {
        if (this.filterText != null) {
            return this.filterText.setFocus();
        }
        return super.setFocus();
    }

    public void setChecked(WrapperType element, boolean checked, boolean isDependency) {
        if (this.fViewer.getInput() == null) {
            return;
        }
        boolean canCheck = false;
        Map input = (Map)this.fViewer.getInput();
        Set keys = input.keySet();
        for (Boolean key : keys) {
            List value = (List)input.get(key);
            if (!value.contains(element)) continue;
            canCheck = true;
            break;
        }
        if (!canCheck) {
            return;
        }
        if (element.getElement().getCategory() == null) {
            this.checkElement(element, checked, true);
        } else {
            ArrayList<WrapperType> items = new ArrayList<WrapperType>();
            items.add(element);
            Category root = new Category();
            List<Category> categories = IdentifiableViewer.buildCategories(root, items);
            IdentifiableViewer.addCategoryItem(categories, items, Boolean.FALSE, root);
            this.checkElement(element, checked, true);
        }
        if (isDependency && checked && !this.dependencies.contains(element.getElement())) {
            this.dependencies.add((ComponentType)element.getElement());
        }
        this.expandElement(element, checked);
    }

    private void expandElement(Object element, boolean checked) {
        block4: {
            block3: {
                if (!checked) {
                    return;
                }
                if (!(element instanceof WrapperType)) break block3;
                WrapperType wrapper = (WrapperType)element;
                if (!this.elements.contains(wrapper.getElement())) break block4;
                this.fViewer.setExpandedState((Object)wrapper, true);
                if (wrapper.getCategory() == null) break block4;
                Category parent = wrapper.getCategory();
                this.expandElement(parent, checked);
                break block4;
            }
            if (element instanceof Category) {
                Category parent = (Category)element;
                while (parent != null) {
                    this.fViewer.setExpandedState((Object)parent, true);
                    parent = parent.getParent();
                }
            }
        }
    }

    public void refresh() {
        if (this.fViewer != null) {
            this.refreshViewer();
        }
    }

    private class DeviceFilter
    extends ViewerFilter {
        private DeviceType device;

        private DeviceFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.device != null) {
                if (element instanceof ComponentType) {
                    ComponentType component = (ComponentType)element;
                    if (SDKManifestProvider.isToolchainSupported((List)component.getToolchain()) && SDKManifestProvider.isCompilerSupported((List)component.getCompiler()) && component.isUserVisible()) {
                        List cDevice = component.getDevices();
                        if (cDevice.size() != 0) {
                            for (DeviceType d : cDevice) {
                                boolean visible = component.isUserVisible();
                                if (!d.getId().equals(this.device.getId()) || !visible) continue;
                                return true;
                            }
                        } else {
                            return true;
                        }
                    }
                    return false;
                }
                if (element instanceof ExampleType) {
                    ExampleType example = (ExampleType)element;
                    return IdentifiableViewer.this.isExampleSupported(example, this.device);
                }
                if (element instanceof WrapperType) {
                    return this.select(viewer, parentElement, ((WrapperType)element).getElement());
                }
            }
            return true;
        }

        public void setDevice(DeviceType device) {
            this.device = device;
        }
    }

    private class IdentifiableLabelProvider
    extends StyledCellLabelProvider {
        private final String ERROR_STR = Messages.IdentifiableViewer_Error;
        private int column;

        public IdentifiableLabelProvider(int column) {
            this.column = column;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IdentifiableType) {
                String tooltip;
                IdentifiableType type = (IdentifiableType)element;
                String string = tooltip = type.getBrief() != null ? type.getBrief().trim() : "";
                if (tooltip.length() != 0) {
                    tooltip = String.valueOf(tooltip) + "<br/>";
                }
                tooltip = String.valueOf(tooltip) + (type.getDescription() != null ? type.getDescription().trim() : "");
                Object htmlText = SDKManifestProvider.getMetadata((IdentifiableType)type, (String)"html", (boolean)true);
                if (htmlText instanceof Element) {
                    String content = ((Element)htmlText).getTextContent();
                    tooltip = String.valueOf(tooltip) + "<br/>" + content;
                }
                if (tooltip.length() != 0) {
                    return tooltip.trim();
                }
            } else {
                Category category;
                if (element instanceof WrapperType) {
                    return this.getToolTipText(((WrapperType)element).getElement());
                }
                if (element instanceof Category && (category = (Category)element).isExternal() && category.getFirstElement() != null && category.getFirstElement().getXmlPath() != null) {
                    return String.valueOf(Messages.IdentifiableViewer_ExLoadedFrom) + category.getFirstElement().getXmlPath();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IdentifiableType) {
                IdentifiableType type = (IdentifiableType)element;
                switch (columnIndex) {
                    case 0: {
                        if (type instanceof ExampleType) {
                            ExampleType example = (ExampleType)type;
                            StringBuffer buffer = new StringBuffer();
                            if (!example.getLinkedProjects().isEmpty()) {
                                buffer.append(Messages.IdentifiableViewer_AutomaticImport);
                                for (Object linked : example.getLinkedProjects()) {
                                    if (linked instanceof ExampleType) {
                                        buffer.append(String.valueOf(((ExampleType)linked).getName()) + ";");
                                        continue;
                                    }
                                    if (!(linked instanceof Manifest.ExternalDefinitions.Definition)) continue;
                                    ExampleType ex = (ExampleType)IdentifiableViewer.this.manifest.findReference((Manifest.ExternalDefinitions.Definition)linked, ExampleType.class);
                                    if (ex == null && (ex = IdentifiableViewer.this.findExternalExamples(((Manifest.ExternalDefinitions.Definition)linked).getExtID())) != null && IdentifiableViewer.this.page.getProps().get(IdentifiableViewer.KEY_EXAMPLES_IMPORTED) != null) {
                                        ((List)IdentifiableViewer.this.page.getProps().get(IdentifiableViewer.KEY_EXAMPLES_IMPORTED)).add(ex);
                                    }
                                    if (ex != null) {
                                        buffer.append(String.valueOf(ex.getName()) + ";");
                                        continue;
                                    }
                                    buffer = new StringBuffer(" " + this.ERROR_STR + Messages.IdentifiableViewer_NotFoundLinkedPrj + ((Manifest.ExternalDefinitions.Definition)linked).getExtID());
                                    break;
                                }
                            }
                            return String.valueOf(type.getName()) + buffer.toString();
                        }
                        return type.getName();
                    }
                    case 1: {
                        return type.getVersion();
                    }
                }
            } else if (element instanceof Category) {
                Category type = (Category)element;
                switch (columnIndex) {
                    case 0: {
                        return type.getName();
                    }
                }
            } else if (element instanceof WrapperType) {
                return this.getColumnText(((WrapperType)element).getElement(), columnIndex);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Category && columnIndex == 0) {
                return IMG_CATEGORY;
            }
            if (element instanceof ComponentType && columnIndex == 0) {
                return IMG_COMPONENT;
            }
            if (element instanceof ExampleType && columnIndex == 0) {
                return IMG_EXAMPLE;
            }
            if (element instanceof WrapperType && columnIndex == 0) {
                return this.getColumnImage(((WrapperType)element).getElement(), columnIndex);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            String text = this.getColumnText(element, this.column);
            Image image = this.getColumnImage(element, this.column);
            if (text != null) {
                cell.setText(text);
            }
            if (image != null) {
                cell.setImage(image);
            }
            if (text != null && element instanceof Category) {
                Category category = (Category)element;
                if (category.isExternal()) {
                    IdentifiableViewer.markExternal(cell, text);
                }
            } else if (text != null && element instanceof WrapperType && ((WrapperType)element).getElement() instanceof ComponentType) {
                WrapperType component = (WrapperType)element;
                this.markDependency(cell, text, IdentifiableViewer.this.isDependency((ComponentType)component.getElement()) && IdentifiableViewer.this.elements.contains(component.getElement()));
            } else if (text != null && element instanceof WrapperType && ((WrapperType)element).getElement() instanceof ExampleType) {
                WrapperType example = (WrapperType)element;
                if (text.contains(this.ERROR_STR)) {
                    this.markError(cell, text);
                } else {
                    ExampleType ex;
                    if (example.isExternal()) {
                        IdentifiableViewer.markExternal(cell, text);
                    }
                    if (example.getElement() instanceof ExampleType && !(ex = (ExampleType)example.getElement()).getLinkedProjects().isEmpty()) {
                        IdentifiableViewer.markLinked(cell, text);
                    }
                }
            }
        }

        public void markDependency(ViewerCell cell, String text, boolean isDep) {
            StyleRange myStyledRange = new StyleRange(0, text.length(), isDep ? COLOR_DEPENDENCY : COLOR_BLACK, null);
            StyleRange[] range = new StyleRange[]{myStyledRange};
            cell.setStyleRanges(range);
        }

        public void markError(ViewerCell cell, String text) {
            int start = text.indexOf(this.ERROR_STR);
            StyleRange myStyledRange = new StyleRange(start, text.length(), COLOR_ERROR, null);
            StyleRange[] range = new StyleRange[]{myStyledRange};
            cell.setStyleRanges(range);
        }
    }

    private class NameFilter
    extends ViewerFilter {
        private String filterText = "";

        private NameFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filterText.length() != 0) {
                if (element instanceof IdentifiableType) {
                    ComponentType component;
                    if (element instanceof ComponentType && !(component = (ComponentType)element).isUserVisible()) {
                        return false;
                    }
                    IdentifiableType type = (IdentifiableType)element;
                    return this.selectParent(parentElement) || type.getName().toLowerCase().contains(this.filterText.toLowerCase());
                }
                if (element instanceof WrapperType) {
                    WrapperType type = (WrapperType)element;
                    return this.selectParent(parentElement) || this.select(viewer, parentElement, type.getElement());
                }
                if (element instanceof Category) {
                    Category type = (Category)element;
                    if (this.selectParent(parentElement) || type.getName().toLowerCase().contains(this.filterText.toLowerCase())) {
                        return true;
                    }
                    return this.selectChild(type.getChildren(), type.getItems());
                }
            }
            return true;
        }

        private boolean selectParent(Object parent) {
            if (parent instanceof Category) {
                Category type = (Category)parent;
                if (this.selectParent(type.getParent()) || type.getName() != null && type.getName().toLowerCase().contains(this.filterText.toLowerCase())) {
                    return true;
                }
                this.selectParent(type.getParent());
            }
            return false;
        }

        private boolean selectChild(List<Category> children, List<WrapperType> examples) {
            for (WrapperType example : examples) {
                if (!this.selectParent(example.getCategory()) && !this.select(null, null, example)) continue;
                return true;
            }
            for (Category child : children) {
                if (!this.selectParent(child.getParent()) && !this.select(null, null, child)) continue;
                return true;
            }
            return false;
        }

        public void setFilterText(String filterText) {
            this.filterText = filterText;
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private Object input;

        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                Category root = new Category();
                List<Category> categories = IdentifiableViewer.buildCategories(root, (List)inputElement);
                IdentifiableViewer.addCategoryItem(categories, (List)inputElement, Boolean.FALSE, root);
                return categories.toArray();
            }
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                Set keys = map.keySet();
                Iterator it = keys.iterator();
                ArrayList<Category> categories = new ArrayList<Category>();
                Category root = new Category();
                while (it.hasNext()) {
                    Boolean key = (Boolean)it.next();
                    List list = (List)map.get(key);
                    List<Category> catList = IdentifiableViewer.buildCategories(root, list);
                    IdentifiableViewer.addCategoryItem(catList, list, key, root);
                    for (Category cat : catList) {
                        if (categories.contains(cat) || !this.hasChildren(cat)) continue;
                        categories.add(cat);
                    }
                }
                ArrayList<Object> result = new ArrayList<Object>();
                result.addAll(categories);
                result.addAll(root.getItems());
                return result.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Category) {
                Category category = (Category)parentElement;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Category cat : category.getChildren()) {
                    if (!this.hasChildren(cat)) continue;
                    list.add(cat);
                }
                for (WrapperType ex : category.getItems()) {
                    if (!IdentifiableViewer.this.filter.select((Viewer)IdentifiableViewer.this.getViewer(), parentElement, ex)) continue;
                    list.add(ex);
                }
                return list.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof WrapperType) {
                WrapperType wrapper = (WrapperType)element;
                Category category = wrapper.getCategory();
                if (category != null) {
                    return category.getParent();
                }
            } else {
                if (element instanceof Category) {
                    Category category = (Category)element;
                    return category.getParent();
                }
                if (element == null) {
                    return this.input;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Category) {
                Category category = (Category)element;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Category cat : category.getChildren()) {
                    if (!this.hasChildren(cat)) continue;
                    list.add(cat);
                }
                for (WrapperType ex : category.getItems()) {
                    if (!IdentifiableViewer.this.filter.select((Viewer)IdentifiableViewer.this.getViewer(), element, ex)) continue;
                    list.add(ex);
                }
                return !list.isEmpty();
            }
            return false;
        }
    }
}

