/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.viewers;

import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ComponentPeripheralsDialog
extends Dialog {
    @NonNull
    private @NonNull Map<String, @Nullable List<@NonNull String>> peripheralsPerComponent;
    @NonNull
    private Map<String, String> selectedPeripherals = new HashMap<String, String>();

    public ComponentPeripheralsDialog(Shell parentShell, Map<String, @Nullable List<@NonNull String>> peripheralsPerComponent) {
        super(parentShell);
        this.peripheralsPerComponent = peripheralsPerComponent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddDependenciesDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainContainer = (Composite)super.createDialogArea(parent);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(mainContainer);
        toolkit.decorateFormHeading(form.getForm());
        form.setLayout((Layout)new GridLayout());
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite mainScrollContainer = form.getBody();
        mainScrollContainer.setLayout((Layout)new GridLayout());
        mainScrollContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        for (Map.Entry<String, List<String>> mapEntry : this.peripheralsPerComponent.entrySet()) {
            final List<String> peripherals = mapEntry.getValue();
            final String key = mapEntry.getKey();
            if (peripherals == null) {
                this.selectedPeripherals.put(key, null);
                continue;
            }
            this.selectedPeripherals.put(key, peripherals.get(0));
            Label componentLabel = new Label(mainScrollContainer, 0);
            componentLabel.setText(String.valueOf(Messages.AddDependenciesDialog_PeripheralsMessage) + key.split(":")[0] + ":");
            TableViewer componentTableViewer = new TableViewer(mainScrollContainer, 2052);
            componentTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            final Table peripheralsTable = componentTableViewer.getTable();
            TableViewerColumn componentTableViewerColumn = new TableViewerColumn(componentTableViewer, 0);
            componentTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            peripheralsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComponentPeripheralsDialog.this.selectedPeripherals.put(key, (String)peripherals.get(peripheralsTable.getSelectionIndex()));
                }
            });
            componentTableViewer.setInput(peripherals);
            peripheralsTable.select(0);
            componentTableViewerColumn.getColumn().pack();
            peripheralsTable.pack();
            peripheralsTable.setLinesVisible(false);
            peripheralsTable.setHeaderVisible(false);
            GridData peripheralsContentData = new GridData(1808);
            peripheralsTable.setLayoutData((Object)peripheralsContentData);
            peripheralsTable.setLayout((Layout)new GridLayout());
        }
        mainScrollContainer.setSize(mainScrollContainer.computeSize(-1, -1));
        return mainContainer;
    }

    public Map<String, String> getResult() {
        return this.selectedPeripherals;
    }

    protected boolean isResizable() {
        return true;
    }
}

