/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.refactoring.internal.ui;

import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextDocumentContext;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextSimpleDocumentContext;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class IdeTextDirtyDocumentsHandler
implements RcpStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        return IdeTextDirtyDocumentsHandler.getDirtyDocuments();
    }

    private static Map<IFile, IdeTextDocumentContext> getDirtyDocuments() {
        return Arrays.stream(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(w -> Arrays.stream(w.getPages())).flatMap(p -> Arrays.stream(p.getEditorReferences())).map(r -> r.getEditor(false)).filter(e -> e instanceof ITextEditor && e.isDirty() && e.getEditorInput() instanceof IFileEditorInput).map(e -> (ITextEditor)e).collect(Collectors.groupingBy(e -> ((IFileEditorInput)e.getEditorInput()).getFile())).entrySet().stream().map(e -> new AbstractMap.SimpleEntry<IFile, IDocument>((IFile)e.getKey(), ((List)e.getValue()).stream().map(ed -> IdeTextDirtyDocumentsHandler.getDocument(ed)).filter(v -> v != null).findFirst().orElse(null))).filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> new IdeTextSimpleDocumentContext((IDocument)e.getValue())));
    }

    private static IDocument getDocument(ITextEditor editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        IFile file = input.getFile();
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return editor.getDocumentProvider().getDocument((Object)input);
    }
}

