/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.svd.utils.BitFieldInfo;
import com.nxp.swtools.common.uct.svd.utils.PeripheralInfo;
import com.nxp.swtools.common.uct.svd.utils.RegisterInfo;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeItemSetting;
import com.nxp.swtools.common.uct.utils.CustomMap;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.uct.xml.settings.VisibleState;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.registers.RegistersFactory;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.BitField;
import com.nxp.swtools.gtm.model.utils.GtmExpressions;
import com.nxp.swtools.gtm.model.utils.GtmRegister;
import com.nxp.swtools.gtm.model.xml.settings.AssignElement;
import com.nxp.swtools.gtm.model.xml.settings.ConfigurationElement;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEntities;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmValidationRule;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlConfiguration;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlInstance;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class GtmUtils {
    private static final Logger LOGGER = LogManager.getLogger(GtmUtils.class);

    public static GtmStructSetting getGtmLayoutContent(GtmXmlConfiguration gtmConfig) {
        GtmStructSetting parentLayoutContent = new GtmStructSetting();
        parentLayoutContent.getStructSettings().clear();
        Iterator<GtmStructSetting> iterator = gtmConfig.getLayoutComponents().getParentLayoutContent().getStructSettings().iterator();
        while (iterator.hasNext()) {
            GtmStructSetting struct;
            GtmStructSetting currentStruct = struct = iterator.next();
            currentStruct.setVisibleState(struct.getInitVisibleState());
            GtmUtils.initCurrentValuesForAllScalarComponents(currentStruct);
            for (GtmStructSetting structRef : struct.getRefs().getStructSettings()) {
                GtmStructSetting typeStruct = gtmConfig.getLayoutComponents().getComponentTypes().getStructTypeById(structRef.getTypeComponentId());
                if (typeStruct == null) continue;
                GtmStructSetting newStruct = new GtmStructSetting(structRef.getId(), structRef.getLabel(), structRef.getConstraintsRef(), typeStruct);
                newStruct.setVisibleState(structRef.getInitVisibleState());
                GtmUtils.initCurrentValuesForAllScalarComponents(newStruct);
                GtmUtils.checkChildStructsRefs(structRef, newStruct);
                currentStruct.getStructSettings().add(newStruct);
            }
            parentLayoutContent.getStructSettings().add(currentStruct);
        }
        return parentLayoutContent;
    }

    private static void checkChildStructsRefs(GtmStructSetting parentStructRef, GtmStructSetting newStructSetting) {
        block0: for (GtmStructSetting childStructRef : parentStructRef.getRefs().getStructSettings()) {
            GtmStructSetting newStructType = newStructSetting.getStructSettingById(childStructRef.getTypeComponentId());
            if (newStructType != null) {
                newStructSetting.getStructSettings().add(GtmUtils.createStructSettingBasedOnTypeStruct(newStructType, childStructRef));
                continue;
            }
            ArrayList<GtmStructSetting> newStructs = new ArrayList<GtmStructSetting>();
            for (GtmStructSetting struct : newStructSetting.getStructSettings()) {
                newStructType = struct.getStructSettingById(childStructRef.getTypeComponentId());
                if (newStructType == null) continue;
                newStructs.add(GtmUtils.createStructSettingBasedOnTypeStruct(newStructType, childStructRef));
                struct.getStructSettings().addAll(newStructs);
                continue block0;
            }
        }
    }

    private static GtmStructSetting createStructSettingBasedOnTypeStruct(GtmStructSetting typeStruct, GtmStructSetting structRef) {
        GtmStructSetting newStruct = !structRef.getRowStrValue().isEmpty() && !structRef.getColumnStrValue().isEmpty() ? new GtmStructSetting(structRef.getId(), structRef.getLabel(), structRef.getConstraintsRef(), typeStruct, structRef.getRowStrValue(), structRef.getColumnStrValue()) : new GtmStructSetting(structRef.getId(), structRef.getLabel(), structRef.getConstraintsRef(), typeStruct);
        for (ABaseUIComponentSetting newComponentChild : newStruct.getChildrenComponents()) {
            String newId = String.valueOf(structRef.getId()) + "." + newComponentChild.getId();
            newComponentChild.setId(newId);
        }
        newStruct.setVisibleState(structRef.getInitVisibleState());
        GtmUtils.initCurrentValuesForAllScalarComponents(newStruct);
        return newStruct;
    }

    public static List<ABaseUIComponentSetting> getAllUIComponentsSettings(GtmStructSetting gtmLayoutContent) {
        ArrayList<ABaseUIComponentSetting> allUIComponents = new ArrayList<ABaseUIComponentSetting>();
        for (GtmStructSetting structSetting : gtmLayoutContent.getStructSettings()) {
            GtmUtils.addToListAllScalarSettingFromStruct(structSetting, allUIComponents);
        }
        return allUIComponents;
    }

    public static @Nullable ABaseUIComponentSetting getUIComponentSettingById(IGtmMcu selectedMcu, String id) {
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            if (!id.equals(componentSetting.getId())) continue;
            return componentSetting;
        }
        return null;
    }

    public static @Nullable ABaseUIComponentSetting getChildFromStructSetting(GtmStructSetting structSetting, String childID) {
        ABaseUIComponentSetting childComponent = null;
        for (ABaseUIComponentSetting currentChild : structSetting.getChildrenComponents()) {
            if (!childID.equalsIgnoreCase(currentChild.getId())) continue;
            childComponent = currentChild;
            break;
        }
        if (childComponent == null) {
            for (GtmStructSetting childStruct : structSetting.getStructSettings()) {
                childComponent = GtmUtils.getChildFromStructSetting(childStruct, childID);
            }
        }
        return childComponent;
    }

    public static @Nullable GtmStructSetting getParentStructSettingContainingChild(GtmStructSetting gtmLayoutContent, ABaseUIComponentSetting setting) {
        for (GtmStructSetting structSetting : gtmLayoutContent.getStructSettings()) {
            for (GtmBoolSetting boolSetting : structSetting.getBoolSettings()) {
                if (!boolSetting.equals(setting)) continue;
                return structSetting;
            }
            for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
                if (!integerSetting.equals(setting)) continue;
                return structSetting;
            }
            for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
                if (!enumSetting.equals(setting)) continue;
                return structSetting;
            }
            for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
                GtmStructSetting childSetting = GtmUtils.getParentStructSettingContainingChild(childStructSetting, setting);
                if (childSetting == null) continue;
                return childSetting;
            }
        }
        return null;
    }

    private static void addToListAllScalarSettingFromStruct(GtmStructSetting structSetting, List<ABaseUIComponentSetting> list) {
        GtmUtils.initCurrentValuesForAllScalarComponents(structSetting);
        list.addAll(structSetting.getChildrenComponents());
        structSetting.setVisibleState(structSetting.getInitVisibleState());
        for (GtmStructSetting childStruct : structSetting.getStructSettings()) {
            GtmUtils.addToListAllScalarSettingFromStruct(childStruct, list);
        }
    }

    public static void initCurrentValuesForAllScalarComponents(GtmStructSetting structSetting) {
        for (GtmBoolSetting boolSetting : structSetting.getBoolSettings()) {
            boolSetting.setCurrentValue(boolSetting.getInitValue());
            boolSetting.setParent(structSetting);
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            ItemSetting defaultItem = enumSetting.getItemById(enumSetting.getInitValue());
            if (defaultItem != null) {
                enumSetting.setCurrentValue(defaultItem.getId());
                enumSetting.setCurrentSelection(defaultItem.getLabel());
            }
            enumSetting.setParent(structSetting);
        }
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.setCurrentValue("0x" + Long.toHexString(UctUtils.getLongValueFromString((String)integerSetting.getInitValue())));
            integerSetting.setParent(structSetting);
        }
    }

    public static void checkAllComponentsConstraints(GtmXmlConfiguration xmlConfig, IGtmMcu selectedMcu) {
        GtmConstraintsTable constraints = xmlConfig.getConstraints();
        for (ABaseUIComponentSetting componentSetting : selectedMcu.getAllGuiComponentSettings()) {
            if (!(componentSetting instanceof GtmStructSetting)) continue;
            GtmStructSetting structSetting = (GtmStructSetting)componentSetting;
            GtmUtils.checkStructSettingConstraints(selectedMcu, constraints, structSetting);
        }
    }

    public static void checkStructSettingConstraints(IGtmMcu selectedMcu, GtmConstraintsTable constraints, GtmStructSetting structSetting) {
        GtmUtils.checkComponentConstraints(selectedMcu, constraints, structSetting);
        for (ABaseUIComponentSetting aBaseUIComponentSetting : structSetting.getIntegerSettings()) {
            GtmUtils.checkComponentConstraints(selectedMcu, constraints, aBaseUIComponentSetting);
        }
        for (ABaseUIComponentSetting aBaseUIComponentSetting : structSetting.getBoolSettings()) {
            GtmUtils.checkComponentConstraints(selectedMcu, constraints, aBaseUIComponentSetting);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettings()) {
            GtmUtils.checkComponentConstraints(selectedMcu, constraints, (ABaseUIComponentSetting)enumSetting);
        }
        for (ABaseUIComponentSetting aBaseUIComponentSetting : structSetting.getTextSettings()) {
            GtmUtils.checkComponentConstraints(selectedMcu, constraints, aBaseUIComponentSetting);
        }
        for (GtmStructSetting gtmStructSetting : structSetting.getStructSettings()) {
            GtmUtils.checkStructSettingConstraints(selectedMcu, constraints, gtmStructSetting);
        }
    }

    public static void checkComponentConstraints(IGtmMcu selectedMcu, GtmConstraintsTable constraints, ABaseUIComponentSetting componentSetting) {
        String[] constraintsRefList = componentSetting.getConstraintsReferences();
        boolean lastVisibleState = true;
        boolean lastDisableState = false;
        String[] stringArray = constraintsRefList;
        int n = constraintsRefList.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintReference = stringArray[n2];
            if (!constraintReference.isEmpty()) {
                DisableState disableState;
                VisibleState visibleState = constraints.getVisibleStateById(constraintReference);
                if (visibleState != null && lastVisibleState) {
                    componentSetting.setVisibleStateCondition(visibleState);
                    boolean state = UctUtils.isComponentVisible((IMcu)selectedMcu, (ABaseUIComponentSetting)componentSetting);
                    componentSetting.setVisibleState(state);
                    UctUtils.setChildrenVisibility((ABaseUIComponentSetting)componentSetting, (boolean)state);
                    lastVisibleState = state;
                } else if (!lastDisableState && (disableState = constraints.getDisableStateById(constraintReference)) != null) {
                    componentSetting.setDisableStateCondition(disableState);
                    boolean state = UctUtils.isComponentDisable((IMcu)selectedMcu, (ABaseUIComponentSetting)componentSetting);
                    componentSetting.setDisableState(state);
                    lastDisableState = state;
                }
                GtmValidationRule gtmValidationRule = constraints.getValidationRuleById(constraintReference);
                if (gtmValidationRule != null) {
                    String tempValue = componentSetting.getCurrentValue();
                    componentSetting.setCurrentValue(" ");
                    componentSetting.setCurrentValue(tempValue);
                }
            }
            ++n2;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Map<String, GtmRegister> getGtmRegistersFromDB(ISupportedDerivativesForSwTools supportedDerivatives, IMcuIdentification mcuSelection, Collection<ProcessorCore> cores, GtmXmlConfiguration gtmConfig) {
        IRegistersDatabaseAPI registersDB = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (registersDB == null) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("Cannot load registers for: {0}", mcuSelection));
            }
            return new HashMap<String, GtmRegister>();
        }
        @NonNull CustomMap peripherals = UctUtils.parseRegisterDb((IRegistersDatabaseAPI)registersDB, cores);
        Map<@NonNull String, GtmRegister> registers = GtmUtils.getGtmRegisters((Map<String, PeripheralInfo>)peripherals, gtmConfig);
        return registers;
    }

    public static Map<String, GtmRegister> getGtmRegisters(Map<String, PeripheralInfo> peripheralsList, GtmXmlConfiguration xmlConfig) {
        HashMap<String, GtmRegister> registers = new HashMap<String, GtmRegister>();
        GtmEntities gtmEntities = xmlConfig.getGtmEntities();
        for (GtmXmlInstance xmlInstance : gtmEntities.getXmlInstances()) {
            for (ConfigurationElement configElement : xmlInstance.getConfigElements()) {
                for (AssignElement assign : configElement.getAssignsTable().getAssignsList()) {
                    GtmRegister gtmRegister;
                    PeripheralInfo peripheralInfo = peripheralsList.get(assign.getPeripheralName());
                    if (peripheralInfo == null) continue;
                    RegisterInfo registerInfo = (RegisterInfo)peripheralInfo.getRegisters().get(assign.getRegisterName());
                    if (registerInfo != null && registers.containsKey(registerInfo.getName())) {
                        gtmRegister = (GtmRegister)registers.get(registerInfo.getName());
                        if (gtmRegister == null) continue;
                        GtmUtils.setBitFieldValueExpression(gtmRegister, assign);
                        continue;
                    }
                    if (registerInfo == null) continue;
                    gtmRegister = new GtmRegister(registerInfo.getName(), NumberFormatValidator.getLongValueFromString((String)registerInfo.getAddress()), NumberFormatValidator.getIntValueFromString((String)registerInfo.getSize()), NumberFormatValidator.getLongValueFromString((String)registerInfo.getResetValue()));
                    GtmUtils.createGtmRegisterBits(gtmRegister, assign, registerInfo);
                    registers.put(gtmRegister.getName(), gtmRegister);
                }
            }
        }
        return registers;
    }

    private static void createGtmRegisterBits(GtmRegister gtmRegister, AssignElement assign, RegisterInfo registerInfo) {
        HashMap<String, BitField> bitFields = new HashMap<String, BitField>();
        for (Map.Entry bitFieldInfoEntry : registerInfo.getBitfields().entrySet()) {
            BitFieldInfo bitFieldInfo = (BitFieldInfo)bitFieldInfoEntry.getValue();
            BitField newBitField = new BitField(bitFieldInfo.getName(), NumberFormatValidator.getIntValueFromString((String)bitFieldInfo.getOffset()), NumberFormatValidator.getIntValueFromString((String)bitFieldInfo.getWidth()), bitFieldInfo.getResetValue());
            if (bitFieldInfo.getName().equals(assign.getFieldName())) {
                newBitField.setValueExpression(assign.getValueExpression());
            }
            bitFields.put(bitFieldInfo.getName(), newBitField);
        }
        gtmRegister.getBitFields().putAll(bitFields);
    }

    private static void setBitFieldValueExpression(GtmRegister gtmRegister, AssignElement assign) {
        BitField bitField = gtmRegister.getBitFields().get(assign.getFieldName());
        if (bitField != null) {
            bitField.setValueExpression(assign.getValueExpression());
        }
    }

    public static void calculateRegistersValue(IGtmMcu selectedMcu) {
        for (Map.Entry<String, GtmRegister> registerEntry : selectedMcu.getGtmRegisters().entrySet()) {
            GtmRegister register = registerEntry.getValue();
            long registerValue = register.getCurrentValue();
            for (Map.Entry<String, BitField> bitFieldEntry : register.getBitFields().entrySet()) {
                BitField bitField = bitFieldEntry.getValue();
                if (!bitField.getValueExpression().isEmpty()) {
                    long bitValue = GtmExpressions.getLongValueFromExpression(selectedMcu, bitField.getValueExpression());
                    bitField.setCurrentValue(bitValue != -1L ? bitValue : bitField.getResetValue());
                }
                int bitFieldOffset = bitField.getOffset();
                int bitFieldSize = bitField.getSize();
                registerValue = (registerValue & GtmUtils.getBitsMaskInRegister(bitFieldOffset, bitFieldSize)) + (bitField.getCurrentValue() << bitFieldOffset);
                register.setCurrentValue(registerValue);
            }
        }
    }

    public static double getGtmInputClockFreq() {
        double queryValue = 0.0;
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IDependencyQuery queryEngine = DependencyQueryFactory.getQueryInstance((ISharedConfiguration)configuration);
        Collection queryResults = queryEngine.query(configuration, "ClockSetting", "P0_GTM_CLK.outFreq", "value");
        for (IDependencyQueryResult queryResult : queryResults) {
            Object queryRsltValue = queryResult.getValue();
            if (queryRsltValue == null) continue;
            queryValue = Double.parseDouble(queryRsltValue.toString());
        }
        return queryValue;
    }

    private static long getBitsMaskInRegister(int offset, int bitsLength) {
        ByteBuffer maskBuffer = ByteBuffer.allocate(32);
        Arrays.fill(maskBuffer.array(), (byte)1);
        int i = 0;
        while (i < bitsLength) {
            maskBuffer.put(offset + i, (byte)0);
            ++i;
        }
        long result = 0L;
        int i2 = 0;
        while (i2 < 31) {
            result += (long)(maskBuffer.get(i2) << i2);
            ++i2;
        }
        if (maskBuffer.get(31) == 1) {
            result += 0x80000000L;
        }
        return result;
    }

    public static void initAllUiComponents(GtmXmlConfiguration gtmConfig) {
        List<ABaseUIComponentSetting> components = GtmUtils.getAllUIComponentsSettings(GtmUtils.getGtmLayoutContent(gtmConfig));
        for (ABaseUIComponentSetting component : components) {
            if (!(component instanceof GtmStructSetting)) continue;
            GtmUtils.initCurrentValuesForAllScalarComponents((GtmStructSetting)component);
        }
    }

    public static void sortActiveChannels(@Nullable List<GtmStructSetting> activePwmChannels) {
        if (activePwmChannels != null && activePwmChannels.size() > 1) {
            Collections.sort(activePwmChannels, (firstSetting, secondSetting) -> {
                Matcher firstSettingMatcher = GtmExpressions.GET_CHANNEL_INFO.matcher(firstSetting.getId());
                Matcher secondSettingMatcher = GtmExpressions.GET_CHANNEL_INFO.matcher(secondSetting.getId());
                if (firstSettingMatcher != null && secondSettingMatcher != null && firstSettingMatcher.find() && secondSettingMatcher.find()) {
                    return UctUtils.compareMathcerGroups((Matcher)firstSettingMatcher, (Matcher)secondSettingMatcher);
                }
                return 0;
            });
        }
    }

    public static boolean getValidationResult(IMcu selectedMcu, ABaseUIComponentSetting component, String complexCondition) {
        boolean state = true;
        if (!complexCondition.isBlank()) {
            for (String condition : UctUtils.getAllOrConditions((String)complexCondition)) {
                Matcher paranthesisGroupMatcher = UctUtils.PARENTHESIS_GROUP_REGEX.matcher(condition);
                if (paranthesisGroupMatcher.find() && paranthesisGroupMatcher.groupCount() == 1) {
                    String exprString = paranthesisGroupMatcher.group(1);
                    if (exprString == null) continue;
                    List allAndConditions = UctUtils.getAllAndConditions((String)exprString);
                    state = GtmUtils.evaluateAndConditions(selectedMcu, component, allAndConditions, true);
                    continue;
                }
                state |= GtmUtils.evaluateCondition(selectedMcu, component, condition, true);
            }
        }
        return state;
    }

    private static boolean evaluateAndConditions(IMcu selectedMcu, ABaseUIComponentSetting component, List<String> conditions, boolean conditionState) {
        boolean result = true;
        for (String condition : conditions) {
            result &= GtmUtils.evaluateCondition(selectedMcu, component, condition, conditionState);
        }
        return result;
    }

    private static boolean evaluateCondition(IMcu selectedMcu, ABaseUIComponentSetting component, String condition, boolean conditionState) {
        ABaseUIComponentSetting conditionComponent;
        boolean result = false;
        String condValue = UctXmlSettingsUtils.getConditionValue((String)condition);
        if (condValue != null && (conditionComponent = UctUtils.getComponentSettingByConstraint((IMcu)selectedMcu, (ABaseUIComponentSetting)component, (String)condition)) != null) {
            result = conditionState ? conditionComponent.getCurrentValue().equals(condValue) : !conditionComponent.getCurrentValue().equals(condValue);
        }
        return result;
    }

    public static @Nullable TreeItemSetting searchForUnitInTreeMenu(List<TreeItemSetting> treeItemSettings, String unitPanelID) {
        for (TreeItemSetting treeItemSetting : treeItemSettings) {
            if (treeItemSetting.getId().equals(unitPanelID)) {
                return treeItemSetting;
            }
            TreeItemSetting childSetting = GtmUtils.searchForUnitInTreeMenu(treeItemSetting.getTreeItems(), unitPanelID);
            if (childSetting == null) continue;
            return childSetting;
        }
        return null;
    }

    public static @Nullable ABaseUIComponentSetting getNestedChildStructSetting(ABaseUIComponentSetting initialSetting, String finalChildId) {
        ArrayDeque<@NonNull ABaseUIComponentSetting> childSettingsDeque = new ArrayDeque<ABaseUIComponentSetting>();
        childSettingsDeque.push(initialSetting);
        while (!childSettingsDeque.isEmpty()) {
            try {
                @NonNull ABaseUIComponentSetting polledChildSetting = (ABaseUIComponentSetting)childSettingsDeque.remove();
                if (polledChildSetting.getId().equals(finalChildId)) {
                    return polledChildSetting;
                }
                if (!(polledChildSetting instanceof GtmStructSetting)) continue;
                childSettingsDeque.addAll(((GtmStructSetting)polledChildSetting).getChildrenComponents());
            }
            catch (NoSuchElementException noSuchElementException) {
                LOGGER.log(Level.SEVERE, "Cannot get nested component based on ID, setting is null");
            }
        }
        return null;
    }

    public static @Nullable String getParentId(GtmStructSetting gtmLayoutContentStruct, String childId) {
        for (GtmStructSetting struct : gtmLayoutContentStruct.getStructSettings()) {
            if (struct.getStructSettingById(childId) != null) {
                return struct.getId();
            }
            GtmUtils.getParentId(struct, childId);
        }
        return null;
    }
}

