/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.importWizards;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.convertor.EpcToPeriphConvertor;
import com.nxp.swtools.asr.convertor.ImportEpcResultEnum;
import com.nxp.swtools.asr.epc.model.EpcConfig;
import com.nxp.swtools.asr.importWizards.Messages;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.framework.ui.newconfig.containers.IProcessorSelectionContainer;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorSelectionContainer;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportEpcWizardPage
extends WizardPage {
    private static final Logger LOGGER = LogManager.getLogger(ImportEpcWizardPage.class);
    private ArrayList<@NonNull String> filterName;
    private ArrayList<@NonNull String> filterExts;
    @Nullable
    protected Text importText = null;
    private ProcessorSelectionContainer selectionContainer;
    boolean importAsNew = false;
    boolean checkVersion = true;
    protected boolean hasVariants = false;
    private ISharedConfiguration targetConfig;
    List<EpcConfig> epcConfigs;
    @Nullable
    private IProcessorSelectionContainer immutableSelection;
    protected String[] allowedExts;
    protected boolean importResult = true;
    protected boolean selectionContainerStatus = false;
    private Map<String, StoragePeriphsFuncGroup> functionalGroups = new HashMap<String, StoragePeriphsFuncGroup>();

    public ImportEpcWizardPage(ISharedConfiguration targetConfig) {
        super(Messages.get().ImportWizardTitle);
        StoragePeriphsTool stPeriphTool;
        this.setTitle(Messages.get().ImportWizardPageTitle);
        this.setMessage(Messages.get().FileDialogText);
        this.filterName = new ArrayList<String>(Arrays.asList("ARXML files (*.arxml)", "All Files (*.*)"));
        this.filterExts = new ArrayList<String>(Arrays.asList("*.arxml", "*.*"));
        this.allowedExts = new String[]{".arxml", ""};
        this.targetConfig = targetConfig;
        this.importAsNew = targetConfig.isEmpty();
        this.epcConfigs = new ArrayList<EpcConfig>();
        this.selectionContainer = new ProcessorSelectionContainer(canFinish -> {
            this.setSelectionContainerStatus((boolean)canFinish);
            this.checkPageComplete();
        }, finish -> {
            this.checkPageComplete();
            if (finish.booleanValue() && this.isToolSupported()) {
                this.performFinish();
            }
        });
        if (!targetConfig.isEmpty() && (stPeriphTool = targetConfig.getTools().getPeripherals()) != null && stPeriphTool.isEnabled()) {
            stPeriphTool.getFuncGroups().forEach(fcGr -> {
                StoragePeriphsFuncGroup storagePeriphsFuncGroup = this.functionalGroups.put(fcGr.getName(), (StoragePeriphsFuncGroup)fcGr);
            });
        }
    }

    public void createControl(@Nullable Composite parent) {
        final Composite pageComposite = new Composite(Objects.requireNonNull(parent), 0);
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)pageComposite);
        Label importLabel = new Label(pageComposite, 0);
        importLabel.setText(Messages.get().ImportFromFileLabel);
        importLabel.setToolTipText(Messages.get().ImportFromFileLabelTooltip);
        Text newImportText = new Text(pageComposite, 2562);
        newImportText.setLayoutData((Object)new GridData(4, 128, true, false));
        newImportText.setToolTipText(Messages.get().SelectedSourcesToImport);
        newImportText.addModifyListener(e -> this.readEpcFiles(this.getFileNames(), ""));
        this.importText = newImportText;
        Button findButton = new Button(pageComposite, 0);
        findButton.setText(Messages.get().ImportWizardPage_Browse);
        findButton.setToolTipText(Messages.get().SelectSourcesTooltip);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        findButton.setLayoutData((Object)gridData);
        findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                FileDialog fd = new FileDialog(ImportEpcWizardPage.this.getShell(), 4098);
                fd.setText(Messages.get().FileDialogText);
                String[] exts = ImportEpcWizardPage.this.filterExts.toArray(new String[0]);
                String[] names = ImportEpcWizardPage.this.filterName.toArray(new String[0]);
                if (!$assertionsDisabled && exts == null && names == null) {
                    throw new AssertionError();
                }
                SWTFactoryProxy.INSTANCE.setFilterExtensionNames(fd, exts, names);
                SWTFactoryProxy.INSTANCE.setFilterPath(fd, KEPreferences.getLastSaveFolderPath());
                String dialogFileName = fd.open();
                if (dialogFileName == null) {
                    return;
                }
                if (ImportEpcWizardPage.this.importText != null) {
                    ImportEpcWizardPage.this.readEpcFiles(fd.getFileNames(), dialogFileName);
                }
            }
        });
        Button importNew = new Button(pageComposite, 16);
        importNew.setText(Messages.get().ImportAsNewButtonMessage);
        importNew.setToolTipText(Messages.get().ImportAsNewButtonTooltip);
        Button importMerge = new Button(pageComposite, 16);
        importMerge.setText(Messages.get().ImportMergeButtonMessage);
        importMerge.setToolTipText(Messages.get().ImportMergeButtonTooltip);
        final Button checkVersionButton = new Button(pageComposite, 32);
        checkVersionButton.setText(Messages.get().CheckVersionButtonMessage);
        checkVersionButton.setToolTipText(Messages.get().CHeckVersionButtonTooltip);
        checkVersionButton.setSelection(true);
        checkVersionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ImportEpcWizardPage.this.checkVersion = checkVersionButton.getSelection();
            }
        });
        final Composite selContainerComposite = new Composite(pageComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)selContainerComposite);
        selContainerComposite.setLayout((Layout)new GridLayout(1, true));
        this.selectionContainer.createControls(selContainerComposite);
        importNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ImportEpcWizardPage.this.importAsNew = true;
                ImportEpcWizardPage.changeVisibility((Control)selContainerComposite, true);
                pageComposite.requestLayout();
                ImportEpcWizardPage.this.checkPageComplete();
            }
        });
        importMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                ImportEpcWizardPage.this.importAsNew = false;
                ImportEpcWizardPage.changeVisibility((Control)selContainerComposite, false);
                pageComposite.requestLayout();
                ImportEpcWizardPage.this.checkPageComplete();
            }
        });
        if (this.targetConfig.isEmpty() || this.functionalGroups.isEmpty()) {
            this.importAsNew = true;
            importNew.setSelection(true);
            importMerge.setEnabled(false);
        } else {
            importMerge.setSelection(true);
            ImportEpcWizardPage.changeVisibility((Control)selContainerComposite, false);
        }
        pageComposite.requestLayout();
        this.checkPageComplete();
    }

    public ImportEpcResultEnum performFinish() {
        if (this.importAsNew) {
            boolean success;
            IProcessorSelectionContainer currentSelection = this.immutableSelection;
            if (currentSelection == null) {
                return ImportEpcResultEnum.FAIL;
            }
            String mcu = currentSelection.getSelectedMcu();
            String sdkVersion = currentSelection.getSelectedSdk();
            String board = currentSelection.getSelectedBoard();
            String kit = currentSelection.getSelectedKit();
            String partNum = currentSelection.getSelectedPackage();
            String configName = currentSelection.getConfigurationName();
            ProcessorCore selCore = currentSelection.getSelectedCore();
            ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            ISharedConfiguration sharedConfig = SharedConfigurationFactory.createSharedConfiguration();
            if (mcu == null || sdkVersion == null) {
                return ImportEpcResultEnum.FAIL;
            }
            IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
            boolean bl = success = (!UtilsText.isEmpty((String)mcu) || !UtilsText.isEmpty((String)sdkVersion)) && info != null;
            if (success) {
                if (UtilsText.isEmpty((String)partNum)) {
                    partNum = !UtilsText.isEmpty((String)board) || !UtilsText.isEmpty((String)kit) ? sharedConfig.getCommonConfig().getPackage() : Objects.requireNonNull(info).getDefaultPartNumber();
                }
                if (!UtilsText.isEmpty((String)configName)) {
                    sharedConfig.setConfigurationName(configName);
                }
                sharedConfig.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)mcu, (String)Objects.requireNonNull(partNum), (String)sdkVersion, (String)UtilsText.safeString((String)board), (String)UtilsText.safeString((String)kit), (String)""));
                SWToolsPlatform.applyCores((ISharedConfiguration)sharedConfig, (ISupportedDerivativesForSwTools)derivatives);
                Tools.disableToolsWithUnsupportedProcessor((ISharedConfiguration)sharedConfig);
                if (selCore != null) {
                    sharedConfig.getCommonConfig().setSelectedCore(selCore);
                }
                SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)sharedConfig, (ISharedConfiguration)this.targetConfig, (ConfigChangeReason)ConfigChangeReason.NEW_CONFIG);
            }
        }
        ImportEpcResultEnum result = ImportEpcResultEnum.FAIL;
        EpcToPeriphConvertor epcConvertor = new EpcToPeriphConvertor(this.epcConfigs, this.targetConfig, this.checkVersion, this.importAsNew);
        result = epcConvertor.convertEpc();
        return result;
    }

    public boolean checkFiles(String[] fileNamesToCheck) {
        return ImportHelper.checkFiles((String[])fileNamesToCheck, (String[])this.allowedExts);
    }

    public String[] getFileNames() {
        String text;
        if (this.importText != null && !UtilsText.isEmpty((String)(text = this.importText.getText()))) {
            String[] fileNamesLoc = text.split(UtilsText.platformEOL);
            return fileNamesLoc;
        }
        return new String[0];
    }

    protected void readEpcFiles(String[] fileNamesWithExt, String dialogFileName) {
        StringBuilder filesText = new StringBuilder();
        String path = UtilsFile.getFilePath((String)dialogFileName);
        if (!UtilsText.isEmpty((String)path)) {
            KEPreferences.setLastSaveFolderPath((String)path);
        }
        int currLine = 1;
        String[] stringArray = fileNamesWithExt;
        int n = fileNamesWithExt.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            String fileNameWithExt = stringArray[n2];
            String string = fileName = UtilsText.isEmpty((String)path) ? fileNameWithExt : String.valueOf(path) + File.separator + fileNameWithExt;
            if (currLine++ > 1) {
                filesText.append(UtilsText.platformEOL);
            }
            filesText.append(fileName);
            ++n2;
        }
        Text importTextTmp = this.importText;
        if (importTextTmp != null && !filesText.toString().equals(importTextTmp.getText())) {
            importTextTmp.setText(filesText.toString());
        }
        this.importResult = this.canImport();
        AsrImporterHelper.getInstance().buildArPackageDOM(Arrays.asList(this.getFileNames()));
        this.checkPageComplete();
    }

    protected void checkPageComplete() {
        @NonNull String[] fileNamesLoc = this.getFileNames();
        if (fileNamesLoc.length == 0 || !this.importResult) {
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            boolean filesStatus = this.checkFiles(fileNamesLoc);
            if (!filesStatus) {
                this.setErrorMessage(Messages.get().Error_FileOrInvalidExt);
                this.setPageComplete(filesStatus);
            } else {
                if (this.importAsNew && !this.selectionContainerStatus) {
                    this.setErrorMessage(Messages.get().SelectMcuErrorMessage);
                    this.setPageComplete(false);
                    return;
                }
                this.setPageComplete(true);
            }
        }
    }

    protected boolean canImport() {
        this.setErrorMessage(null);
        String[] fileNames = this.getFileNames();
        if (!this.checkFiles(fileNames)) {
            this.setErrorMessage(Messages.get().Error_FileOrInvalidExt);
            return false;
        }
        ArrayList<String> unmatchFiles = new ArrayList<String>();
        ArrayList<String> variantFiles = new ArrayList<String>();
        this.epcConfigs.clear();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File currentFile = new File(fileName);
            if (!currentFile.exists()) {
                LOGGER.warning("File " + fileName + " not found");
            } else {
                EpcConfig epcContainer = EpcConfig.loadEpcFile(currentFile);
                if (epcContainer != null) {
                    this.epcConfigs.add(epcContainer);
                    if (epcContainer.hasVariants()) {
                        variantFiles.add(currentFile.getName());
                    }
                } else if (!AsrImporterHelper.getInstance().isFileBswmdModule(fileName)) {
                    unmatchFiles.add(currentFile.getName());
                }
            }
            ++n2;
        }
        if (!unmatchFiles.isEmpty()) {
            if (unmatchFiles.size() == fileNames.length) {
                this.setErrorMessage(MessageFormat.format(Messages.get().FilesCouldNotBeLoadedMessage, String.join((CharSequence)",", unmatchFiles)));
                return false;
            }
            this.setMessage(MessageFormat.format(Messages.get().FilesWillNotBeLoadedMessage, String.join((CharSequence)",", unmatchFiles)), 2);
        } else {
            this.setMessage(null);
        }
        this.hasVariants = !variantFiles.isEmpty();
        return true;
    }

    protected static void changeVisibility(Control control, boolean visible) {
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData layoutData = (GridData)data;
            layoutData.exclude = !visible;
            control.setVisible(visible);
        }
    }

    private void setSelectionContainerStatus(boolean status) {
        this.selectionContainerStatus = status;
    }

    public void resolveSelection() {
        this.immutableSelection = this.selectionContainer.getImmutableSelection();
    }

    public boolean isToolSupported() {
        this.resolveSelection();
        IProcessorSelectionContainer currentSelection = this.immutableSelection;
        if (currentSelection != null) {
            String mcu = currentSelection.getSelectedMcu();
            String sdkVersion = currentSelection.getSelectedSdk();
            if (mcu != null && sdkVersion != null) {
                IProcessorMasterToolInfo info = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getProcessorMasterToolInfo(mcu, sdkVersion);
                if (info != null && SupportedToolsByProcessor.isToolSuported((IProcessorMasterToolInfo)info, (String)"Peripherals")) {
                    return true;
                }
                LOGGER.log(Level.SEVERE, Messages.get().ToolIsNotSupportedErrorMessage);
                if (!SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode") && !SWToolsProperties.isHeadlessOn()) {
                    MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.get().ErrorDialogTitle, (String)Messages.get().ToolIsNotSupportedErrorMessage);
                }
            }
        }
        return false;
    }
}

