/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.convertor;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ClockSelectSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksIdValue;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksOutput;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksSource;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ClocksImporterHelper {
    public static void createAndStoreClockSetting(String settingId, String settingValue, StorageClocksConfiguration clockConfiguration, String stringClockSettingType) {
        ISetting setting = UiController.getInstance().getProfile().getMcu().getSettings().findSettingWithId(settingId);
        String settingValueLoc = ClocksImporterHelper.getSettingValueFromMappingFile(settingValue);
        if (settingValueLoc == null) {
            String concatenatedId = String.valueOf(settingId) + "." + settingValue;
            settingValueLoc = ClocksImporterHelper.getSettingValueFromMappingFile(concatenatedId);
        }
        if (settingValueLoc == null && setting != null && (settingValueLoc = ClocksImporterHelper.getSettingStorageValue(setting, settingValue)) == null) {
            settingValueLoc = settingValue;
        }
        if (Boolean.FALSE.toString().equals(settingValueLoc)) {
            settingValueLoc = "Disabled";
        } else if (Boolean.TRUE.toString().equals(settingValueLoc)) {
            settingValueLoc = "Enabled";
        }
        if (setting != null && settingValueLoc != null) {
            switch (setting.getType()) {
                case FREQUENCY_GATE: 
                case ENABLE_DISABLE: 
                case GLOBAL_CONFIG_ELEMENT: 
                case LOCAL_CONFIG_ELEMENT: 
                case BIT_FIELD: 
                case OTHER: {
                    ClocksImporterHelper.addClockSettingToStorage(clockConfiguration, settingId, settingValueLoc, setting.isLockedByDefault(), stringClockSettingType);
                    break;
                }
                case FREQUENCY_OUTPUT: {
                    long value = new BigDecimal(settingValueLoc).longValue();
                    if (value >= 1000L) {
                        long kHz = ClocksImporterHelper.convertHzTokHz(settingValueLoc);
                        if (kHz / 1000L < 1L) {
                            settingValueLoc = ClocksImporterHelper.addUnit(kHz, FrequencyUnit.KILO_HERTZ);
                        } else {
                            long mHz = ClocksImporterHelper.convertHzToMHz(settingValueLoc);
                            settingValueLoc = ClocksImporterHelper.addUnit(mHz, FrequencyUnit.MEGA_HERTZ);
                        }
                    } else {
                        settingValueLoc = ClocksImporterHelper.addUnit(new BigDecimal(settingValueLoc).longValue(), FrequencyUnit.HERTZ);
                    }
                    ClocksImporterHelper.addClockSettingToStorage(clockConfiguration, settingId, settingValueLoc, setting.isLockedByDefault(), stringClockSettingType);
                    break;
                }
                case FREQUENCY_MODIFIER: {
                    if (!(setting instanceof ClockSelectSetting)) {
                        float divisorValue = Float.parseFloat(settingValueLoc);
                        settingValueLoc = String.valueOf(divisorValue);
                    }
                    ClocksImporterHelper.addClockSettingToStorage(clockConfiguration, settingId, settingValueLoc, setting.isLockedByDefault(), stringClockSettingType);
                    break;
                }
            }
        }
    }

    private static @Nullable String getSettingStorageValue(ISetting setting, String uiValue) {
        List settingValues;
        IClocksConfig clockConfig = UiController.getInstance().getProfile().getActiveConfig();
        if (clockConfig != null && (settingValues = setting.getValues(clockConfig)) != null) {
            for (SettingValue settingValue : settingValues) {
                if (!settingValue.getUiValue().equals(uiValue)) continue;
                return settingValue.getValue().toString();
            }
        }
        return null;
    }

    private static long convertHzTokHz(String value) {
        long freq = new BigDecimal(value).longValue();
        return freq /= 1000L;
    }

    private static long convertHzToMHz(String value) {
        value = String.valueOf(ClocksImporterHelper.convertHzTokHz(value));
        long freq = new BigDecimal(value).longValue();
        return freq /= 1000L;
    }

    private static String addUnit(long value, FrequencyUnit unit) {
        return String.valueOf(String.valueOf(value)) + " " + unit.toString();
    }

    private static void addClockSettingToStorage(StorageClocksConfiguration clockConfiguration, String id, String value, boolean locked, String stringClockSettingType) {
        switch (stringClockSettingType) {
            case "clock_setting": {
                StorageClocksIdValue clockSetting = new StorageClocksIdValue();
                clockSetting.setId(id);
                clockSetting.setValue(value);
                clockSetting.setLocked(locked);
                clockConfiguration.getSettings().add(clockSetting);
                break;
            }
            case "clock_output": {
                StorageClocksOutput clockOutput = new StorageClocksOutput();
                clockOutput.setId(id);
                clockOutput.setValue(value);
                clockOutput.setLocked(locked);
                clockConfiguration.getOutputs().add(clockOutput);
                break;
            }
            case "clock_source": {
                StorageClocksSource clockSource = new StorageClocksSource();
                clockSource.setId(id);
                clockSource.setValue(value);
                clockSource.setLocked(locked);
                clockSource.setEnabled(true);
                clockConfiguration.getSources().add(clockSource);
                break;
            }
        }
    }

    public static @Nullable StorageClocksConfiguration getOrCreateClockConfiguration(ISharedConfiguration sharedConfig, String containerId, String name) {
        StorageClocksTool clockStorage;
        if (containerId.equals("McuClockSettingConfig") && (clockStorage = sharedConfig.getTools().getClock()) != null) {
            ArrayList clockConfigs = clockStorage.getConfigurations();
            for (StorageClocksConfiguration clockConfig : clockConfigs) {
                if (!clockConfig.getName().equals(name)) continue;
                return clockConfig;
            }
            StorageClocksConfiguration clockConfiguration = new StorageClocksConfiguration();
            clockConfiguration.setName(name);
            clockStorage.getConfigurations().add(clockConfiguration);
            return clockConfiguration;
        }
        return null;
    }

    public static void clearClockConfigurations(ISharedConfiguration sharedConfig) {
        StorageClocksTool clockStorage = sharedConfig.getTools().getClock();
        if (clockStorage != null) {
            clockStorage.getConfigurations().clear();
            UiController.getInstance().getProfile().removeAllConfigs();
        }
    }

    private static @Nullable String getSettingValueFromMappingFile(String key) {
        return AsrImporterHelper.getInstance().getPeripheralClocksMapping().get(key);
    }
}

