/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.convertor;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.convertor.EpcToPeriphConvertor;
import com.nxp.swtools.asr.epc.model.EpcConfig;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsrCmdApplication
implements ICmdApplication {
    private static final Logger LOGGER = LogManager.getLogger(AsrCmdApplication.class);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean run(@NonNull CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        boolean importAsNew = !keys.contains("-Load");
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "-ImportEcuConf": {
                    ISharedConfiguration targetConf = SharedConfigurationFactory.getSharedConfigurationSingleton();
                    if (targetConf.isEmpty()) {
                        LOGGER.log(Level.SEVERE, "No configuration found. ECU Configuration will not be loaded.");
                        result = false;
                        break;
                    }
                    StoragePeriphsTool stPeriphs = targetConf.getTools().getPeripherals();
                    StoragePeriphsFuncGroup fcGroup = null;
                    if (stPeriphs != null) {
                        if (cmdSection.hasOption("-FunctionalGroup")) {
                            String fcGrName = cmdSection.getOptionValue("-FunctionalGroup");
                            for (StoragePeriphsFuncGroup fcGr : stPeriphs.getFuncGroups()) {
                                if (!fcGr.getName().equals(fcGrName)) continue;
                                fcGroup = fcGr;
                                break;
                            }
                        }
                        if (fcGroup == null) {
                            fcGroup = (StoragePeriphsFuncGroup)stPeriphs.getFuncGroups().get(0);
                            LOGGER.log(Level.WARNING, "Default functional group will be used:" + fcGroup.getName());
                        }
                    } else {
                        LOGGER.log(Level.SEVERE, "The selected processor doesn't have support for the Peripherals Tool. The ECU Configuration can't be imported.");
                        result = false;
                        break;
                    }
                    @NonNull List filePathsToImport = cmdSection.getOptionValues("-ImportEcuConf");
                    ArrayList<EpcConfig> epcConfigs = new ArrayList<EpcConfig>();
                    if (filePathsToImport != null) {
                        AsrImporterHelper.getInstance().buildArPackageDOM(filePathsToImport);
                        for (String file : filePathsToImport) {
                            File fileInst = new File(file);
                            EpcConfig epcConf = EpcConfig.loadEpcFile(fileInst);
                            if (epcConf != null) {
                                epcConfigs.add(epcConf);
                                continue;
                            }
                            LOGGER.log(Level.WARNING, "ECU Configuration couldn't be loaded from the " + file);
                        }
                        if (epcConfigs.isEmpty()) {
                            result = false;
                            break;
                        }
                        boolean checkVersion = !cmdSection.hasOption("-DisableEcuVersionCheck");
                        EpcToPeriphConvertor convertorInstance = new EpcToPeriphConvertor(epcConfigs, targetConf, checkVersion, importAsNew);
                        convertorInstance.convertEpc();
                        result = true;
                        break;
                    }
                    result = false;
                    LOGGER.log(Level.SEVERE, "ECU Configuration files wasn't provided to the \"-ImportEcuConf\" option");
                    break;
                }
            }
        }
        return result;
    }
}

