/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.queuelist;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueData;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueDataType;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.views.queuelist.QueueDataTreeChildItem;
import java.util.LinkedList;
import java.util.List;

class QueueDataItem
extends TadItem {
    private QueueData queueData;
    private List<QueueDataTreeChildItem> treeChildren;

    QueueDataItem(QueueData queueData) {
        super(queueData.getId());
        this.queueData = queueData;
        this.treeChildren = new LinkedList<QueueDataTreeChildItem>();
        if (queueData.hasData()) {
            int i = 0;
            for (Long data : queueData.getData()) {
                this.treeChildren.add(new QueueDataTreeChildItem(this, queueData.getAddress() + (long)(i++ * 4), data));
            }
        }
    }

    @Override
    public List<? extends TadItem> getTreeChildren() {
        return this.treeChildren;
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ID, TadColumnId.ADDRESS, TadColumnId.DATA_BYTES, TadColumnId.DATA_HEX, TadColumnId.DATA_BIN, TadColumnId.DATA_TEXT}, separator);
    }

    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ID: {
                    return String.format("%d", this.queueData.getId());
                }
                case ADDRESS: {
                    return String.format("0x%08x", this.queueData.getAddress());
                }
                case DATA_BYTES: {
                    return this.queueData.toString(QueueDataType.DECIMAL);
                }
                case DATA_HEX: {
                    return this.queueData.toString(QueueDataType.HEXADECIMAL);
                }
                case DATA_BIN: {
                    return this.queueData.toString(QueueDataType.BINARY);
                }
                case DATA_TEXT: {
                    return this.queueData.toString(QueueDataType.ASCII);
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ID: {
                return this.queueData.getId();
            }
            case ADDRESS: {
                return this.queueData.getAddress();
            }
        }
        return null;
    }
}

