/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.column;

import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.view.column.TadColumnCopyable;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.column.TadColumnWeight;
import com.nxp.freertos.gdb.tad.view.providers.TadBarGraphProvider;

public class TadColumn {
    private TadColumnId id;
    private String name;
    private String tooltip;
    private FreeRTOSConfig dependency;
    private TadColumnWeight weight;
    private TadBarGraphProvider styledCell;
    private TadColumnCopyable copyable;

    public TadColumn(TadColumnId id, String name, String tooltip, TadColumnWeight weight, TadColumnCopyable copyable, TadBarGraphProvider styledCell, FreeRTOSConfig dependency) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
        this.weight = weight;
        this.copyable = copyable;
        this.styledCell = styledCell;
        this.dependency = dependency;
    }

    public TadColumn(TadColumnId id, String name, String tooltip, TadColumnWeight weight, TadColumnCopyable copyable) {
        this(id, name, tooltip, weight, copyable, null, null);
    }

    public TadColumnId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public int getWeight() {
        switch (this.weight) {
            case NARROW: {
                return 2;
            }
            case SMALL: {
                return 5;
            }
            case WIDE: {
                return 15;
            }
        }
        return 10;
    }

    public TadBarGraphProvider getStyledCell() {
        return this.styledCell;
    }

    public FreeRTOSConfig getDependency() {
        return this.dependency;
    }

    public boolean isCopyable() {
        return this.copyable == TadColumnCopyable.COPYABLE;
    }
}

