/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.wizards.processordata;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.downloadmanager.DataManager;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.wizards.processordata.ExportImportProcessorDataUtils;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.utils.ConfigurationUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExportProcessorDataPage
extends WizardPage {
    @Nullable
    protected Text userFileNameText = null;
    @Nullable
    protected CheckboxTreeViewer viewer;
    final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();

    ExportProcessorDataPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.get().ExportProcessorDataPage_ExportProcessorData);
    }

    String getSelectedFile() {
        Text exportTextLoc = this.userFileNameText;
        assert (exportTextLoc != null);
        return exportTextLoc.getText();
    }

    Object[] getSelection() {
        return ExportImportProcessorDataUtils.getSelection(this.getViewer());
    }

    void selectDependencies() {
        List<Object> selectedObjects = Arrays.asList(this.getSelection());
        List<String> missingItems = DataManager.computeProcessorDependencies(selectedObjects, mcu -> false);
        for (String item : missingItems) {
            this.derivatives.getProcessorMasterToolInfos(item).forEach(info -> {
                boolean bl = this.getViewer().setChecked(info, true);
            });
        }
        selectedObjects.stream().filter(ITemplateInfo.class::isInstance).map(ITemplateInfo.class::cast).filter(it -> ITemplateInfo.TemplateType.ttKit == it.getTemplateType()).forEach(it -> {
            ITemplateInfo brd;
            String boardName;
            ISharedConfiguration config = ConfigurationUtils.loadBoardConfiguration((String)it.getId(), (String)it.getSdkVersion(), null);
            if (config != null && !UtilsText.isEmpty((String)(boardName = config.getCommonConfig().getBoard())) && (brd = this.derivatives.getBoardById(UtilsText.safeString((String)boardName), it.getSdkVersion())) != null) {
                this.getViewer().setChecked((Object)brd, true);
            }
        });
    }

    private CheckboxTreeViewer getViewer() {
        assert (this.viewer != null);
        return this.viewer;
    }

    public void createControl(Composite parent) {
        Text userFileNameTextLoc;
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(600, 200).create());
        this.setControl((Control)pageComposite);
        Composite dirComposite = new Composite(pageComposite, 0);
        dirComposite.setLayout((Layout)new GridLayout(3, false));
        dirComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).create());
        Label userFileNameLabel = new Label(dirComposite, 0);
        GridData gridData = new GridData();
        userFileNameLabel.setLayoutData((Object)gridData);
        userFileNameLabel.setText(Messages.get().ExportProcessorDataPage_ToArchive);
        this.userFileNameText = userFileNameTextLoc = new Text(dirComposite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)userFileNameTextLoc, "DownloadProcessorDataCustomDirectoryText");
        userFileNameTextLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        userFileNameTextLoc.addModifyListener(e -> this.validatePage());
        Button findButton = new Button(dirComposite, 0);
        findButton.setText(Messages.get().ExportProcessorDataPage_Browse);
        findButton.addListener(13, event -> {
            Shell shell = parent.getShell();
            String title = UtilsText.safeString((String)Messages.get().ExportProcessorDataPage_SelectTargetArchive);
            FileDialog fd = new FileDialog(shell, 8192);
            fd.setText(title);
            fd.setFilterExtensions(ExportImportProcessorDataUtils.ZIP_EXTENSIONS);
            fd.setFileName(UtilsFile.getFileNameWithExtension((String)userFileNameTextLoc.getText()));
            fd.setFilterPath(UtilsFile.getFilePath((String)userFileNameTextLoc.getText()));
            fd.setOverwrite(true);
            String selectedPath = fd.open();
            if (selectedPath != null && !selectedPath.isEmpty()) {
                userFileNameTextLoc.setText(selectedPath);
            }
        });
        Label seriesLabel = new Label(pageComposite, 0);
        gridData = new GridData();
        seriesLabel.setLayoutData((Object)gridData);
        seriesLabel.setText(Messages.get().ExportProcessorDataPage_SelectWhatToExport);
        CheckboxTreeViewer viewerLoc = this.viewer = ExportImportProcessorDataUtils.createTreeWithProcessorData(pageComposite, this.derivatives);
        viewerLoc.addCheckStateListener(this::checkStateChanged);
        this.setInitialSelection();
        this.validatePage();
    }

    private void setInitialSelection() {
        ProcessorNode node = new ProcessorNode(Messages.get().ProcessorProvider_ComponentsNode);
        this.getViewer().setChecked((Object)node, true);
        DataManager.checkSubTreeAndParents(this.getViewer(), node, true);
    }

    private void checkStateChanged(CheckStateChangedEvent event) {
        DataManager.checkSubTreeAndParents(event);
        this.validatePage();
    }

    protected void validatePage() {
        String errMessage = null;
        boolean valid = true;
        if (!UtilsFile.isFileNameValid((String)UtilsFile.getFileNameWithExtension((String)this.getSelectedFile()))) {
            errMessage = Messages.get().ExportProcessorDataPage_InvalidFileName;
            valid = false;
        } else if (new File(this.getSelectedFile()).isDirectory()) {
            errMessage = Messages.get().ExportProcessorDataPage_DirectoryNotExpected;
            valid = false;
        }
        if (valid && this.getSelection().length == 0) {
            errMessage = Messages.get().ExportProcessorDataPage_NoDataSelected;
            valid = false;
        }
        this.setErrorMessage(errMessage);
        this.setPageComplete(valid);
    }
}

