/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.views;

import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.framework.Messages;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class FrameworkView
extends ViewPart {
    @Nullable
    Composite mainComposite;
    private Font font;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createPartControl(Composite composite) {
        this.font = new Font((Device)composite.getDisplay(), "Arial Black", 14, 0);
        this.mainComposite = composite;
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.get().FrameworkView_WelcomeText);
        label.setFont(this.font);
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 0x1000000).indent(10, 100).applyTo((Control)label);
        @NonNull Collection products = SwToolsProductConfiguration.getRegisteredProducts();
        int productSize = products.size();
        int gridColumns = Math.max(productSize, 1);
        Composite buttonPanel = new Composite(composite, 0);
        buttonPanel.setLayout((Layout)new GridLayout(gridColumns, true));
        GridDataFactory.swtDefaults().grab(true, false).indent(10, 20).align(0x1000000, 128).applyTo((Control)buttonPanel);
        products.stream().filter(p -> !UtilsText.isEmpty((String)p.getPerspectiveID())).sorted((p1, p2) -> p1.getProductName().compareTo(p2.getProductName())).forEach(tool -> this.createToolButton((SwToolsProduct)tool, buttonPanel));
    }

    public void dispose() {
        super.dispose();
        Font fontLoc = this.font;
        this.font = null;
        if (fontLoc != null) {
            fontLoc.dispose();
        }
    }

    void createToolButton(@NonNull SwToolsProduct tool, @NonNull Composite parent) {
        Button btn = new Button(parent, 8);
        btn.setText(tool.getProductName());
        Image toolIcon = UtilsImage.getCachedImage((String)tool.getIconLocation(), (boolean)false);
        btn.setImage(toolIcon);
        btn.addListener(13, e -> Application.setSelectedTool(tool));
    }

    public void setFocus() {
        Composite mainCompositeLoc = this.mainComposite;
        if (mainCompositeLoc != null) {
            mainCompositeLoc.setFocus();
        }
    }
}

