/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig.containers;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.wizards.WizardUtils;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ModeSelectionContainer {
    @NonNull
    private Runnable settingsChangedCallback;
    private static final int LABEL_HORIZ_OFFSET = 24;
    @NonNull
    WizardData wizardData;
    @Nullable
    CCombo openMexPath;
    @Nullable
    Text importPrjPath;

    public ModeSelectionContainer(@NonNull WizardData wizardData, @NonNull Runnable settingsChangedCallback) {
        this.wizardData = wizardData;
        this.settingsChangedCallback = settingsChangedCallback;
    }

    private static @NonNull Button newRadioModeOption(@NonNull Composite parent, @Nullable String caption) {
        String text;
        Button result = new Button(parent, 16);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)result.getFont()).setStyle(1).increaseHeight(1);
        Font boldFont = boldDescriptor.createFont((Device)result.getDisplay());
        result.setFont(boldFont);
        String string = text = UtilsText.isEmpty((String)caption) ? "ERROR: Missing localized description" : caption;
        assert (text != null);
        result.setText(text);
        return result;
    }

    public void createControls(@NonNull Composite composite) {
        int n;
        Composite group;
        Composite mainComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(mainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        Button defaultRadioButton = null;
        int longLabelWithdHint = ShellProvider.getAnyShellParent().getBounds().width * 3 / 5;
        ArrayList<DataBindingContext> dataBindingContexts = new ArrayList<DataBindingContext>();
        if (Platform.getBundle((String)"com.nxp.swtools.projectcloner.rcp") != null) {
            Button radioCloneExam = ModeSelectionContainer.newRadioModeOption(mainComposite, WizardData.Mode.CLONE_EXAMPLE.getUiCaption());
            SWTFactoryProxy.INSTANCE.setTestId((Widget)radioCloneExam, "NewConfig_CreateNewCfgForClonedExample_Radio");
            defaultRadioButton = radioCloneExam;
            radioCloneExam.setSelection(true);
            this.wizardData.setMode(WizardData.Mode.CLONE_EXAMPLE);
            radioCloneExam.addListener(13, e -> this.setMode(WizardData.Mode.CLONE_EXAMPLE));
            GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)radioCloneExam);
            Composite cloneLabelComposite = new Composite(mainComposite, 0);
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(cloneLabelComposite);
            GridDataFactory.fillDefaults().grab(true, false).indent(20, 0).span(2, 1).applyTo((Control)cloneLabelComposite);
            Label label = new Label(cloneLabelComposite, 64);
            label.setText(Messages.get().NewConfigurationModeSelectionPage_RadioCloneExample_ExtraText);
            GridDataFactory.swtDefaults().align(16384, 128).hint(longLabelWithdHint, -1).grab(true, false).applyTo((Control)label);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)radioCloneExam, Messages.get().NewConfigurationModeSelectionPage_RadioCloneExample_ExtraText);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)label, Messages.get().NewConfigurationModeSelectionPage_RadioCloneExample_ExtraText);
        }
        if (!SwToolsProduct.isImxProduct()) {
            Button newCfgInToolchainPrj = ModeSelectionContainer.newRadioModeOption(mainComposite, WizardData.Mode.IMPORT_TOOLCHAIN_PROJECT.getUiCaption());
            SWTFactoryProxy.INSTANCE.setTestId((Widget)newCfgInToolchainPrj, "NewConfig_ImportToolchainProject_Radio");
            newCfgInToolchainPrj.setSelection(false);
            newCfgInToolchainPrj.addListener(13, e -> this.setMode(WizardData.Mode.IMPORT_TOOLCHAIN_PROJECT));
            group = new Composite(mainComposite, 0);
            Composite browseToolchainParent = this.createBrowseToolchainPrjComposite(group);
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(group);
            GridDataFactory.fillDefaults().grab(true, false).indent(20, 0).span(2, 1).applyTo((Control)group);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)browseToolchainParent);
            DataBindingContext ctx = new DataBindingContext();
            dataBindingContexts.add(ctx);
            ISWTObservableValue radioNewCfgInToolchainPrjSelection = WidgetProperties.widgetSelection().observe((Widget)newCfgInToolchainPrj);
            Control[] controlArray = browseToolchainParent.getChildren();
            n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                ISWTObservableValue ctrlObservable = WidgetProperties.enabled().observe((Widget)ctrl);
                ctx.bindValue((IObservableValue)ctrlObservable, (IObservableValue)radioNewCfgInToolchainPrjSelection);
                ++n2;
            }
            assert (!SWToolsPlatform.isRunningInEclipseIde());
            Label descriptionLabel = new Label(group, 64);
            descriptionLabel.setText(Messages.get().DlgModeSelection_RadioImportToolchainPrj_ExtraText);
            GridDataFactory.swtDefaults().align(16384, 128).hint(longLabelWithdHint, -1).grab(true, false).applyTo((Control)descriptionLabel);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)newCfgInToolchainPrj, Messages.get().DlgModeSelection_RadioImportToolchainPrj_ExtraText);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)descriptionLabel, Messages.get().DlgModeSelection_RadioImportToolchainPrj_ExtraText);
        }
        if (this.wizardData.wizardType.equals((Object)WizardData.WizardType.STARTUP)) {
            Button radioOpenMex = ModeSelectionContainer.newRadioModeOption(mainComposite, WizardData.Mode.OPEN_EXISTING_CFG.getUiCaption());
            SWTFactoryProxy.INSTANCE.setTestId((Widget)radioOpenMex, "NewConfig_OpenExistingMexFile_Radio");
            radioOpenMex.setSelection(false);
            radioOpenMex.addListener(13, e -> this.setMode(WizardData.Mode.OPEN_EXISTING_CFG));
            GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)radioOpenMex);
            group = new Composite(mainComposite, 0);
            Label descriptionLabel = new Label(group, 64);
            descriptionLabel.setText(Messages.get().DlgModeSelection_RadioOpenExistingMex_ExtraText);
            GridDataFactory.swtDefaults().align(16384, 128).hint(longLabelWithdHint, -1).grab(true, false).applyTo((Control)descriptionLabel);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)radioOpenMex, Messages.get().DlgModeSelection_RadioOpenExistingMex_ExtraText);
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)descriptionLabel, Messages.get().DlgModeSelection_RadioOpenExistingMex_ExtraText);
            Composite browseParent = this.createBrowsePrevConfigurationComposite(group, radioOpenMex);
            if (radioOpenMex.getSelection()) {
                if (defaultRadioButton != null) {
                    defaultRadioButton.setSelection(false);
                }
                defaultRadioButton = radioOpenMex;
            }
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(group);
            GridDataFactory.fillDefaults().grab(true, false).indent(20, 0).span(2, 1).applyTo((Control)group);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)browseParent);
            DataBindingContext ctx = new DataBindingContext();
            dataBindingContexts.add(ctx);
            ISWTObservableValue radioNewCfgInToolchainPrjSelection = WidgetProperties.widgetSelection().observe((Widget)radioOpenMex);
            Control[] controlArray = browseParent.getChildren();
            int n3 = controlArray.length;
            n = 0;
            while (n < n3) {
                Control ctrl = controlArray[n];
                ISWTObservableValue ctrlObservable = WidgetProperties.enabled().observe((Widget)ctrl);
                ctx.bindValue((IObservableValue)ctrlObservable, (IObservableValue)radioNewCfgInToolchainPrjSelection);
                ++n;
            }
        }
        Button radioNewCfgNoPrj = ModeSelectionContainer.newRadioModeOption(mainComposite, WizardData.Mode.CREATE_NEW_CFG.getUiCaption());
        SWTFactoryProxy.INSTANCE.setTestId((Widget)radioNewCfgNoPrj, "NewConfig_CreateNewCfgForMcuBoard_Radio");
        radioNewCfgNoPrj.setSelection(defaultRadioButton == null);
        radioNewCfgNoPrj.addListener(13, e -> this.setMode(WizardData.Mode.CREATE_NEW_CFG));
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)radioNewCfgNoPrj);
        Label label = new Label(mainComposite, 64);
        label.setText(Messages.get().NewConfigurationModeSelectionPage_RadioNewCfg_ExtraText);
        GridDataFactory.swtDefaults().indent(24, 0).span(2, 1).align(16384, 128).hint(longLabelWithdHint, -1).grab(true, false).applyTo((Control)label);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)radioNewCfgNoPrj, Messages.get().NewConfigurationModeSelectionPage_RadioNewCfg_ExtraText);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)label, Messages.get().NewConfigurationModeSelectionPage_RadioNewCfg_ExtraText);
        for (DataBindingContext ctx : dataBindingContexts) {
            ctx.updateTargets();
        }
        if (OSDetect.isMac()) {
            mainComposite.getDisplay().asyncExec(() -> ((Composite)composite).layout());
        }
    }

    @NonNull Composite createBrowseToolchainPrjComposite(@NonNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.get().DlgModeSelection_LblSelectToolchainProject);
        Text text = new Text(composite, 2052);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)text, "NewConfig_ImportToolchainProjectPath_Text");
        this.importPrjPath = text;
        text.addListener(24, e -> {
            this.wizardData.setPath(UtilsText.safeString((String)text.getText()));
            this.settingsChangedCallback.run();
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).minSize(100, -1).applyTo((Control)text);
        Button button = new Button(composite, 8);
        button.setText(Messages.get().NewConfigurationSdkSelectionPage_BrowseButton);
        button.addListener(13, e -> this.browseForToolchainProjectDir(text));
        return composite;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNull Composite createBrowsePrevConfigurationComposite(@NonNull Composite parent, @NonNull Button radio) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(3).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.get().DlgModeSelection_LblSelectExistingMEX);
        Composite comboComposite = new Composite(composite, 2048);
        comboComposite.setLayout((Layout)new FillLayout());
        CCombo combo = new CCombo(comboComposite, 0);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "NewConfig_OpenExistingMexFilePath_Combo");
        @NonNull List recentConfigs = KEPreferences.getRecentConfigFileNames();
        radio.setSelection(!recentConfigs.isEmpty());
        combo.setItems(recentConfigs.toArray(new String[0]));
        this.openMexPath = combo;
        if (!recentConfigs.isEmpty()) {
            radio.setSelection(true);
            this.wizardData.setMode(WizardData.Mode.OPEN_EXISTING_CFG);
            combo.setText((String)recentConfigs.get(0));
            this.wizardData.setPath((String)recentConfigs.get(0));
        } else {
            radio.setSelection(false);
        }
        combo.addListener(24, e -> {
            this.wizardData.setPath(UtilsText.safeString((String)combo.getText()));
            this.settingsChangedCallback.run();
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).minSize(100, -1).applyTo((Control)comboComposite);
        Button button = new Button(composite, 8);
        button.setText(Messages.get().NewConfigurationSdkSelectionPage_BrowseButton);
        button.addListener(13, e -> this.browseForExistingConfiguration(combo));
        Label dummyLbl = new Label(composite, 0);
        dummyLbl.setText("");
        Button check = new Button(composite, 32);
        check.setText(Messages.get().DlgModeSelection_CheckAlwaysOpenLastConfiguration);
        check.setToolTipText(com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_AskForLoadPreviousMexTooltip);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)check, "NewConfig_AlwaysOpenExistingMexFile_Checkbox");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)check);
        check.addListener(13, e -> KEPreferences.setAutoLoadPreviousMexPreference((boolean)check.getSelection()));
        return composite;
    }

    void browseForToolchainProjectDir(@NonNull Text text) {
        DirectoryDialog dd = new DirectoryDialog(text.getShell(), 4096);
        dd.setText("Select toolchain project folder");
        dd.setFilterPath(text.getText());
        String selectedDir = dd.open();
        if (selectedDir != null) {
            text.setText(selectedDir);
            this.wizardData.setPath(selectedDir);
            this.settingsChangedCallback.run();
        }
    }

    void browseForExistingConfiguration(@NonNull CCombo combo) {
        FileDialog fdlg = new FileDialog(combo.getShell(), 4096);
        fdlg.setText("Select MEX configuration");
        String mexFileName = UtilsText.safeString((String)combo.getText());
        if (!mexFileName.isEmpty()) {
            fdlg.setFileName(mexFileName);
        }
        SWTFactoryProxy.INSTANCE.setFilterExtensionNames(fdlg, WizardUtils.CONFIGURATION_FILTER_EXTS, WizardUtils.CONFIGURATION_FILTER_NAMES);
        String selectedPath = fdlg.open();
        if (selectedPath != null) {
            combo.setText(selectedPath);
            this.wizardData.setPath(selectedPath);
            this.settingsChangedCallback.run();
        }
    }

    void setMode(@NonNull WizardData.Mode mode) {
        this.wizardData.setMode(mode);
        switch (mode) {
            case CREATE_NEW_CFG: 
            case SWITCH_PROCESSOR: 
            case CLONE_EXAMPLE: {
                this.wizardData.setPath("");
                break;
            }
            case IMPORT_TOOLCHAIN_PROJECT: {
                Text t = this.importPrjPath;
                assert (t != null);
                this.wizardData.setPath(UtilsText.safeString((String)t.getText()));
                break;
            }
            case OPEN_EXISTING_CFG: {
                CCombo c = this.openMexPath;
                assert (c != null);
                this.wizardData.setPath(UtilsText.safeString((String)c.getText()));
            }
        }
        this.settingsChangedCallback.run();
    }

    public String validatePage() {
        switch (this.wizardData.getMode()) {
            case CREATE_NEW_CFG: 
            case SWITCH_PROCESSOR: 
            case CLONE_EXAMPLE: {
                return null;
            }
            case IMPORT_TOOLCHAIN_PROJECT: {
                if (this.wizardData.getPath().isEmpty()) {
                    return Messages.get().DlgModeSelection_ErrNoPathSelected;
                }
                try {
                    Paths.get(this.wizardData.getPath(), new String[0]);
                }
                catch (InvalidPathException invalidPathException) {
                    return Messages.get().DlgModeSelection_ErrPathIsInavalid;
                }
                if (!new File(this.wizardData.getPath()).isDirectory()) {
                    return Messages.get().DlgModeSelection_ErrPathDoesNotExist;
                }
                return null;
            }
            case OPEN_EXISTING_CFG: {
                if (this.wizardData.getPath().isEmpty()) {
                    return Messages.get().DlgModeSelection_ErrMexFileNotSelected;
                }
                if (!this.wizardData.getPath().endsWith(".mex")) {
                    return String.valueOf(Messages.get().DlgModeSelection_ErrInvalidMexFileExtension) + ".mex";
                }
                if (!new File(this.wizardData.getPath()).isFile()) {
                    return Messages.get().DlgModeSelection_ErrSelectedMexDoesNotExist;
                }
                return null;
            }
        }
        return null;
    }
}

