/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.httpserver.AHandler;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import java.util.logging.Logger;

@NonNullByDefault
public class HttpConfigurationMEXLocationHandler
extends AHandler {
    protected static final Logger LOGGER = LogManager.getLogger(HttpConfigurationMEXLocationHandler.class);
    public static final String PREFIX = "/common/configuration/mex_location";

    public void handle(HttpRequest request) {
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (configuration.isModificationInProgress()) {
            request.setResponse(new Response(500, "Configuration is being modified right now"));
            return;
        }
        String locationOnDisk = configuration.getLocationOnDisk();
        if (locationOnDisk == null) {
            request.setResponse(new Response(500, "Location of MEX file is not yet specified in configuration"));
            return;
        }
        request.setResponse(new Response(200, locationOnDisk));
    }

    public boolean canHandle(HttpRequest request) {
        return request.getLocation().equalsIgnoreCase(PREFIX);
    }
}

