/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.ui;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareContentProvider;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareDeviceCoreContentProvider;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTree;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTrees;
import com.nxp.s32ds.debug.ide.ui.dialogs.DeviceCoreViewerFilterByDebugger;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class S32DebuggerHardwareDialog
extends Dialog {
    private Button butOK;
    private HardwareTree treeViewer;
    private String titleText;
    private final ViewerFilter hardwareFilter;
    private final HardwareContentProvider contentProvider;
    private DeviceCoreDescriptor deviceCoreDescriptor;
    private DeviceDescriptor deviceDescriptor;
    private String deviceRevision;

    public S32DebuggerHardwareDialog(Shell parentShell, String title, String debuggerId) {
        this(parentShell, (HardwareContentProvider)new HardwareDeviceCoreContentProvider(debuggerId), title);
    }

    public S32DebuggerHardwareDialog(Shell parentShell, HardwareContentProvider contentProvider, String title) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.titleText = title;
        this.contentProvider = contentProvider;
        this.hardwareFilter = new DeviceCoreViewerFilterByDebugger(contentProvider);
    }

    public void create() {
        super.create();
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        innerComposite.setLayout((Layout)gridLayout);
        GridData fill = new GridData(4, 4, true, true);
        fill.minimumHeight = 400;
        fill.minimumWidth = 300;
        innerComposite.setLayoutData((Object)fill);
        this.treeViewer = HardwareTrees.getHardwareTree((Composite)innerComposite, (ITreeContentProvider)this.contentProvider, selectionEvent -> {
            this.deviceCoreDescriptor = this.treeViewer.getDeviceCoreDescriptor();
            this.deviceDescriptor = this.treeViewer.getDeviceDescriptor();
            this.deviceRevision = this.treeViewer.getDeviceRevision();
            if (this.contentProvider.getSelectionType() == DeviceDescriptor.class) {
                this.butOK.setEnabled(this.deviceDescriptor != null);
            }
            if (this.contentProvider.getSelectionType() == DeviceCoreDescriptor.class) {
                this.butOK.setEnabled(this.deviceCoreDescriptor != null);
            }
        });
        this.treeViewer.addFilter(this.hardwareFilter);
        this.treeViewer.setAdvancedMode();
        this.treeViewer.setInput((Object)this.contentProvider.getFamilyDescriptors());
        this.getShell().setText(this.titleText);
        return innerComposite;
    }

    protected boolean isResizable() {
        return false;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.butOK.setEnabled(false);
        return butBar;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public String getDeviceRevision() {
        return this.deviceRevision;
    }

    public EntityDescriptor getDescriptor() {
        if (this.contentProvider.getSelectionType() == DeviceDescriptor.class) {
            return this.deviceDescriptor;
        }
        if (this.contentProvider.getSelectionType() == DeviceCoreDescriptor.class) {
            return this.deviceCoreDescriptor;
        }
        return null;
    }
}

