/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.ui;

import com.nxp.s32ds.debug.ide.core.usb.devices.s32debugger.tap.S32DebuggerTapUsbDevices;
import com.nxp.s32ds.debug.ide.internal.ui.FirmwareUpdateDialog;
import com.nxp.s32ds.debug.ide.internal.ui.FirmwareUpdateMessages;
import com.nxp.s32ds.debug.ide.ui.DebuggerUIActivator;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class S32DebugProbeFirmwareUpdater {
    private static boolean performUpdate;
    private static final int YES_BUTTON = 2;
    private static final String DO_NOT_ASK_AGAIN_KEY = "do_not_ask_again_key";

    public static void updateFW106IfNeeded() {
        Collection usbDevices = S32DebuggerTapUsbDevices.getConnectedUSBDevicesFW106();
        boolean doNotShowDialog = S32DebugProbeFirmwareUpdater.getPreferenceStore().getBoolean(DO_NOT_ASK_AGAIN_KEY);
        if (!usbDevices.isEmpty() && doNotShowDialog) {
            Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
            CDebugUIPlugin.getStandardDisplay().syncExec(() -> {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)FirmwareUpdateMessages.UpdateRequestDialogTitle_message, (String)FirmwareUpdateMessages.UpdateRequestDialogText_message, (String)FirmwareUpdateMessages.UpdateRequestDialogDo_not_ask_again, (boolean)false, null, null);
                performUpdate = dialog.getReturnCode() == 2;
                S32DebugProbeFirmwareUpdater.getPreferenceStore().setValue(DO_NOT_ASK_AGAIN_KEY, dialog.getToggleState());
            });
            if (performUpdate) {
                S32DebugProbeFirmwareUpdater.performUpdate(usbDevices, shell);
            }
        }
    }

    private static void performUpdate(Collection<String> usbDevices, final Shell shell) {
        FirmwareUpdateDialog dialog = new FirmwareUpdateDialog(shell, usbDevices);
        if (dialog.open() == 0) {
            try {
                new ProgressMonitorDialog(shell).run(true, false, monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    subMonitor.setTaskName(FirmwareUpdateMessages.FirwareUpdateDialogUpdate_Processing_firmware_update);
                    dialog.getDevicesToUpdateFirmware().forEach(device -> {
                        final String result = S32DebuggerTapUsbDevices.updateUSBDeviceFW106((String)device);
                        if (!result.isEmpty()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)shell, (String)FirmwareUpdateMessages.UpdateRequestDialogTitle_message, (String)result);
                                }
                            });
                        }
                    });
                });
            }
            catch (InvocationTargetException e) {
                DebuggerUIActivator.getInstance().logError("Cannot create progress dialog", e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return DebuggerUIActivator.getInstance().getPreferenceStore();
    }
}

