/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard;

import com.nxp.s32ds.cle.cdt.sdk.core.imports.SdksImporter;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ExternalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard.ExternalSdkWizardImportFromZipFilePage;
import com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard.ExternalSdkWizardLoadSdkFromDescriptorPage;
import com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard.ExternalSdkWizardSelectOriginPage;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;

public class ExternalSdkWizard
extends Wizard {
    private ExternalSdkWizardSelectOriginPage importSdkWizardSelectOriginPage = new ExternalSdkWizardSelectOriginPage();
    private ExternalSdkWizardImportFromZipFilePage importFromZipFilePage = new ExternalSdkWizardImportFromZipFilePage();
    private ExternalSdkWizardLoadSdkFromDescriptorPage loadFromDescriptorPage = new ExternalSdkWizardLoadSdkFromDescriptorPage();
    private Collection<SdkDescriptor> importedSdks;

    public ExternalSdkWizard(Collection<SdkDescriptor> importedSdks) {
        this.importedSdks = importedSdks;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.importSdkWizardSelectOriginPage);
        this.addPage((IWizardPage)this.loadFromDescriptorPage);
        this.addPage((IWizardPage)this.importFromZipFilePage);
    }

    public boolean canFinish() {
        if (this.importFromZipFilePage.isCurrentPage()) {
            return this.importFromZipFilePage.isPageComplete();
        }
        if (this.loadFromDescriptorPage.isCurrentPage()) {
            return this.loadFromDescriptorPage.isPageComplete();
        }
        return false;
    }

    public IWizardPage getPreviousPage(IWizardPage arg0) {
        return null;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public String getWindowTitle() {
        return Messages.ExternalSdkWizard_title;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean performFinish() {
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getShell());
        if (this.importFromZipFilePage.isCurrentPage()) {
            Display.getDefault().syncExec(() -> this.loadSdkFromZip(monitor));
        } else if (this.loadFromDescriptorPage.isCurrentPage()) {
            Display.getDefault().syncExec(() -> this.loadSdkFromManifest(monitor));
        }
        return true;
    }

    private void loadSdkFromZip(ProgressMonitorDialog monitor) {
        final Map<String, Map<String, String>> importingSdksData = this.importFromZipFilePage.getImportingSdks();
        final String originImportPath = this.importFromZipFilePage.getArchiveFilePath();
        final String extractionFolder = this.importFromZipFilePage.getArchiveExtractionFolder();
        monitor.open();
        try {
            monitor.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
                    subMonitor.beginTask(Messages.ExternalSdkWizard_load_sdk_from_zip_progress_dialog, ProgressCounter.TotalWork.getValue());
                    subMonitor.subTask(Messages.ExternalSdkWizard_load_sdk_header_progress_dialog);
                    new SdksImporter().loadSdkHeaders(originImportPath, extractionFolder, (IProgressMonitor)subMonitor.split(ProgressCounter.LoadSDKHeader.getValue()));
                    subMonitor.subTask(Messages.ExternalSdkWizard_import_sdk_progress_dialog);
                    ExternalSdkWizard.this.importedSdks.addAll(new SdksImporter().performImport(importingSdksData, originImportPath, extractionFolder, (IProgressMonitor)subMonitor.split(ProgressCounter.PerformImportZIP.getValue())));
                    subMonitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            SdkCoreActivator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private void loadSdkFromManifest(ProgressMonitorDialog monitor) {
        monitor.open();
        try {
            monitor.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                    int progressMonitorSize = ExternalSdkWizard.this.loadFromDescriptorPage.getDescriptorFilePaths().keySet().size();
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)progressMonitorSize);
                    subMonitor.beginTask(Messages.ExternalSdkWizard_load_sdk_from_manifest_file_progress_dialog, progressMonitorSize);
                    ExternalSdkWizard.this.loadFromDescriptorPage.getDescriptorFilePaths().keySet().forEach(filePath -> ExternalSdkLoader.loadSdkFromDescriptorFile((String)filePath, (boolean)true, (boolean)true, (IProgressMonitor)subMonitor.split(ProgressCounter.ProcessedUnit.getValue())));
                    subMonitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            SdkCoreActivator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private static enum ProgressCounter {
        TotalWork(100),
        LoadSDKHeader(80),
        PerformImportZIP(20),
        ProcessedUnit(1);

        private final int value;

        private ProgressCounter(int work) {
            this.value = work;
        }

        public int getValue() {
            return this.value;
        }
    }
}

