/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.info;

import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class InfoDialog
extends Dialog {
    private String title;

    protected InfoDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = Objects.requireNonNull(title);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        shell.setMinimumSize(300, 100);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContent(contents);
        InfoDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected abstract void createContent(Composite var1);

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Group createInfoGroup(Composite parent, String label) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(label);
        return group;
    }

    protected void createInfoElement(Composite parent, String label, String text) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setLayoutData((Object)new GridData(34));
        nameLabel.setText(label);
        this.createTextField(parent, text);
    }

    protected void createFlagInfoElement(Composite parent, String labelText) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(34));
        label.setText(labelText);
        Button checkbox = new Button(parent, 32);
        checkbox.setSelection(true);
        checkbox.setEnabled(false);
    }

    protected void createLinkInfoElement(Composite parent, String label, String linkPath, String text, boolean isDirectory) {
        try {
            final String path = Paths.get(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(linkPath), new String[0]).normalize().toString();
            File file = new File(path);
            String errorMessage = null;
            if (path.isEmpty()) {
                errorMessage = "Invalid location: empty";
            } else if (!file.exists()) {
                errorMessage = "Invalid location: not exists";
            } else if (isDirectory && !file.isDirectory()) {
                errorMessage = "Invalid location: is not directory";
            }
            Link nameLink = new Link(parent, 0);
            nameLink.setLayoutData((Object)new GridData(272));
            if (errorMessage != null) {
                this.createErrorDecoration((Control)nameLink, errorMessage, parent).show();
            } else {
                label = "<a>" + label + "</a>";
            }
            nameLink.setText(label);
            nameLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)path);
                }
            });
            text = path;
        }
        catch (CoreException coreException) {}
        this.createTextField(parent, text);
    }

    protected void createLinkInfoElement(Composite parent, String label, String text, boolean isDirectory) {
        this.createLinkInfoElement(parent, label, text, text, isDirectory);
    }

    protected void createTextField(Composite parent, String text) {
        Text valueTextField = new Text(parent, 2058);
        valueTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        valueTextField.setText(text);
    }

    protected ControlDecoration createErrorDecoration(Control control, String message, Composite parent) {
        ControlDecoration decoration = new ControlDecoration(control, 16512, parent);
        decoration.setDescriptionText(message);
        decoration.setMarginWidth(1);
        decoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR").createImage());
        return decoration;
    }
}

