/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control.AbstractSdkResourceControl;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFileResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFolderResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResourcesHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class HeaderResourcesControl
extends AbstractSdkResourceControl {
    public static final String HEADERS_SUFFIX = "H";
    private static final int INCLUDE_ALL_MENUITEM_ID = 5;
    private static final int INCLUDE_NONE_MENUITEM_ID = 6;
    private Set<AbstractSdkResourceControl.SdkResourceDataHolder> selectedIncludeFiles = new LinkedHashSet<AbstractSdkResourceControl.SdkResourceDataHolder>();
    private ToolChainHolder rootToolChainHolder;

    public HeaderResourcesControl(Composite parent, boolean isEdiatable, Map<String, ToolChainHolder> toolChainHolders, ToolChainHolder rootToolChainHolder) {
        super(parent, ResourceSdkCore.headerFilesMatcher, isEdiatable, false, HEADERS_SUFFIX, toolChainHolders);
        this.rootToolChainHolder = rootToolChainHolder;
        this.resourceType = ResourceSdkGroup.HEADER_RESOURCES;
    }

    @Override
    public void setInput(AbstractSdkResourceControl.InputWrapper inputWrapper, boolean isCreateMode, boolean isExpand) {
        String completedSdkPath;
        super.setInput(inputWrapper, isCreateMode, isExpand);
        AbstractSdkResourceControl.SdkDataHolder sdkDataHolder = inputWrapper.get();
        ModelSdk sdk = sdkDataHolder.getSdk();
        if (sdk != null && (completedSdkPath = SdkManagementUtils.performStringSubstitution((String)sdk.getHeader().getBasePath(), null)) != null && Path.fromOSString((String)sdkDataHolder.getRootPath()).equals((Object)Path.fromOSString((String)completedSdkPath))) {
            Map<String, List<SdkResourcesHolder>> checkedIncludeFiles = sdk.getResources(ResourceSdkGroup.INCLUDE_FILE_RESOURCES, "all_toolchains");
            for (Map.Entry<String, List<SdkResourcesHolder>> e : checkedIncludeFiles.entrySet()) {
                String sdkId = e.getKey();
                for (SdkResourcesHolder resourcesHolder : e.getValue()) {
                    String toolChainId = resourcesHolder.getToolChainId();
                    resourcesHolder.getAllResources().stream().map(resource -> new AbstractSdkResourceControl.SdkResourceDataHolder((SdkResource)resource, sdkId, toolChainId)).forEach(this.selectedIncludeFiles::add);
                }
            }
        }
    }

    public Map<String, Set<SdkResource>> getIncludeFiles() {
        LinkedHashSet selectedResources = new LinkedHashSet();
        this.selectedIncludeFiles.stream().map(AbstractSdkResourceControl.SdkResourceDataHolder::getResource).forEach(selectedResources::add);
        LinkedHashMap<String, Set<SdkResource>> checkedResources = new LinkedHashMap<String, Set<SdkResource>>();
        checkedResources.put(this.rootToolChainHolder.getTCId(), selectedResources);
        return checkedResources;
    }

    @Override
    public void clearSelected() {
        super.clearSelected();
        this.selectedIncludeFiles.clear();
    }

    @Override
    protected void addExtraColumns() {
        super.addExtraColumns();
        TreeViewerColumn includeFilesColumn = new TreeViewerColumn(this.viewer, 0);
        includeFilesColumn.getColumn().setText(Messages.SdKEditDialogHeaderResourcesControl_label_include_files_column);
        includeFilesColumn.getColumn().setWidth(50);
        includeFilesColumn.setLabelProvider((CellLabelProvider)new IncludeFilesColumnLabelProvider());
        if (this.isEditable) {
            includeFilesColumn.setEditingSupport((EditingSupport)new IncludeFilesColumnEditingSupport((ColumnViewer)this.viewer));
        }
        includeFilesColumn.getColumn().pack();
    }

    @Override
    protected CellLabelProvider getSelectColumnLabelProvider() {
        return new HeaderResourcesControlSelectColumnLabelProvider();
    }

    @Override
    protected EditingSupport getSelectColumnEditingSupport() {
        return new HeaderResourcesControlSelectColumnEditingSupport((ColumnViewer)this.viewer);
    }

    @Override
    protected boolean isDirectorySelectable(AbstractSdkResourceControl.SdkResourceDataHolder directory) {
        if (!super.isDirectorySelectable(directory)) {
            File[] listFiles = directory.getPath().toFile().listFiles();
            if (listFiles != null) {
                return Arrays.stream(listFiles).noneMatch(File::isFile);
            }
            return false;
        }
        return true;
    }

    @Override
    protected List<AbstractSdkResourceControl.SdkResourceDataHolder> getMatchedSelectableFolders(AbstractSdkResourceControl.SdkResourceDataHolder parentDirectory) {
        File[] listFiles = parentDirectory.getPath().toFile().listFiles();
        if (listFiles != null) {
            String sdkId = parentDirectory.getSdkId();
            String toolChainId = parentDirectory.getToolChainId();
            return Arrays.stream(listFiles).filter(File::isDirectory).map(dir -> this.getResourceDataHolder(ExtendedPath.fromOSString(dir.getAbsolutePath(), true), sdkId, toolChainId)).filter(this::isDirectorySelectable).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected Menu getMenu(Tree tree) {
        Menu menu = super.getMenu(tree);
        new MenuItem(menu, 2);
        this.addItem(menu, tree, Messages.SdKEditDialogHeaderResourcesControl_menuitem_include_all, 5);
        this.addItem(menu, tree, Messages.SdKEditDialogHeaderResourcesControl_menuitem_include_none, 6);
        return menu;
    }

    @Override
    protected void switchSelection(Tree tree, int id) {
        super.switchSelection(tree, id);
        switch (id) {
            case 5: {
                this.selectedIncludeFiles.clear();
                this.viewer.expandAll();
                this.includeItems(tree.getItems());
                break;
            }
            case 2: 
            case 6: {
                this.selectedIncludeFiles.clear();
                break;
            }
        }
    }

    private void includeItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSdkResourceControl.SdkResourceDataHolder includeFile;
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof AbstractSdkResourceControl.SdkResourceDataHolder && this.isFileSelected(includeFile = this.getIncludeFile((AbstractSdkResourceControl.SdkResourceDataHolder)data))) {
                this.addIncludeFile(includeFile);
            }
            this.includeItems(treeItem.getItems());
            ++n2;
        }
    }

    private AbstractSdkResourceControl.SdkResourceDataHolder getIncludeFile(AbstractSdkResourceControl.SdkResourceDataHolder sdkResourceDataHolder) {
        SdkFileResource includeFile = new SdkFileResource(ResourceSdkKind.INCLUDE_FILE, sdkResourceDataHolder.getResource().getPath());
        return new AbstractSdkResourceControl.SdkResourceDataHolder(includeFile, sdkResourceDataHolder.getSdkId(), sdkResourceDataHolder.getToolChainId());
    }

    private void addIncludeFile(AbstractSdkResourceControl.SdkResourceDataHolder includeFile) {
        this.selectedIncludeFiles.add(includeFile);
    }

    private boolean isIncludeFilesContainPath(ExtendedPath path) {
        return this.selectedIncludeFiles.stream().anyMatch(s -> s.getPath().equals((Object)path));
    }

    @Override
    protected SdkResource getResource(ExtendedPath path) {
        return path.toFile().isDirectory() ? new SdkFolderResource(ResourceSdkKind.HEADER_FOLDER, path, ResourceSdkCore.headerFilesMatcher) : new SdkFileResource(ResourceSdkKind.HEADER_FILE, path);
    }

    private class HeaderResourcesControlSelectColumnEditingSupport
    extends AbstractSdkResourceControl.SelectColumnEditingSupport {
        public HeaderResourcesControlSelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        @Override
        protected void handleSubDirectoriesSelection(AbstractSdkResourceControl.SdkResourceDataHolder resourceDataHolder, boolean isSelected) {
            File[] subDirectories = resourceDataHolder.getPath().toFile().listFiles(file -> file.isDirectory() && (file.listFiles() == null || file.listFiles().length == 0));
            if (subDirectories != null) {
                File[] fileArray = subDirectories;
                int n = subDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    AbstractSdkResourceControl.SdkResourceDataHolder subDirectory = HeaderResourcesControl.this.getResourceDataHolder(ExtendedPath.fromOSString(f.getAbsolutePath(), true), resourceDataHolder.getSdkId(), resourceDataHolder.getToolChainId());
                    if (isSelected) {
                        HeaderResourcesControl.this.selectedFolders.add(subDirectory);
                    } else {
                        HeaderResourcesControl.this.selectedFolders.remove(subDirectory);
                    }
                    ++n2;
                }
            }
        }
    }

    private class HeaderResourcesControlSelectColumnLabelProvider
    extends AbstractSdkResourceControl.SelectColumnLabelProvider {
        private HeaderResourcesControlSelectColumnLabelProvider() {
        }

        @Override
        protected boolean isRootDirectoryCellSelected(AbstractSdkResourceControl.SdkResourceDataHolder resourceDataHolder) {
            return HeaderResourcesControl.this.isFolderSelected(resourceDataHolder);
        }
    }

    private class IncludeFilesColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public IncludeFilesColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (HeaderResourcesControl.this.isEditable && element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                AbstractSdkResourceControl.SdkResourceDataHolder resource = (AbstractSdkResourceControl.SdkResourceDataHolder)element;
                return !resource.isDirectory() && HeaderResourcesControl.this.isFileSelected(resource);
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                return HeaderResourcesControl.this.isIncludeFilesContainPath(((AbstractSdkResourceControl.SdkResourceDataHolder)element).getPath());
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                AbstractSdkResourceControl.SdkResourceDataHolder includeFile = HeaderResourcesControl.this.getIncludeFile((AbstractSdkResourceControl.SdkResourceDataHolder)element);
                boolean isIncludeFile = (Boolean)value;
                if (isIncludeFile) {
                    HeaderResourcesControl.this.addIncludeFile(includeFile);
                } else {
                    this.removeIncludeFile(includeFile);
                }
                this.getViewer().refresh();
            }
        }

        private void removeIncludeFile(AbstractSdkResourceControl.SdkResourceDataHolder includeFile) {
            HeaderResourcesControl.this.selectedIncludeFiles.remove(includeFile);
        }
    }

    private class IncludeFilesColumnLabelProvider
    extends CellLabelProvider {
        private IncludeFilesColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof AbstractSdkResourceControl.SdkResourceDataHolder) {
                cell.setImage(this.getImage((AbstractSdkResourceControl.SdkResourceDataHolder)element));
            }
        }

        private Image getImage(AbstractSdkResourceControl.SdkResourceDataHolder resource) {
            boolean isFileAndSelected;
            ExtendedPath path = resource.getPath();
            boolean isResourceIncluded = HeaderResourcesControl.this.isIncludeFilesContainPath(path);
            boolean bl = isFileAndSelected = path.toFile().isFile() && (!HeaderResourcesControl.this.isEditable || HeaderResourcesControl.this.isFileSelected(resource));
            if (isResourceIncluded) {
                return isFileAndSelected ? SELECTED_ENABLED_IMAGE : SELECTED_DISABLED_IMAGE;
            }
            return isFileAndSelected ? SELECTED_DISABLED_IMAGE : null;
        }
    }
}

