/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach.SdkAttachmentChangeHandler;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.SdkAttachWizardDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class SdkAttachMenuHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAdaptable adaptable;
        Object objectAdapter;
        IStructuredSelection structuredSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (objectAdapter = (adaptable = (IAdaptable)element).getAdapter(IResource.class)) instanceof IResource) {
            SdkAttachMenuHandler.changeSdkAttachStates(event, ((IResource)objectAdapter).getProject());
        }
        return null;
    }

    private static void changeSdkAttachStates(ExecutionEvent event, IProject project) {
        Collection<SdkDescriptor> filteredSdks = SdkAttachMenuHandler.getFilteredSdks(project);
        Map<String, List<IStatus>> sdksAttachStates = SdkAttachMenuHandler.getFilteredSdksAttachStates(filteredSdks, project);
        Collection<SdkDescriptor> attachableSdks = SdkAttachMenuHandler.getAttachableSdks(filteredSdks);
        SdkAttachWizardDialog dialog = new SdkAttachWizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), SdkAttachmentChangeHandler.createAttachWizard(project, sdksAttachStates, attachableSdks));
        dialog.create();
        if (dialog.open() == 0) {
            Display display = Display.getDefault();
            SdkAttachmentChangeHandler.collectChangedSdksAttachStates(sdksAttachStates, project);
            display.syncExec(() -> {
                IStatus iStatus = SdkAttachmentChangeHandler.handleSdksAttachmentsChanges(project, null);
            });
        }
    }

    private static Collection<SdkDescriptor> getFilteredSdks(IProject project) {
        List filteredSdks = SdkManagementUtils.getFilteredSdks((SdkFilter)new ProjectCompatibleSdksFilter(project));
        return filteredSdks.stream().filter(sdk -> SdkType.INTERNAL != sdk.getType() && !sdk.getTags().contains("mcal")).sorted(SdkManagementUtils.getSdksComparator()).collect(Collectors.toList());
    }

    private static Map<String, List<IStatus>> getFilteredSdksAttachStates(Collection<SdkDescriptor> filteredSdks, IProject project) {
        SdkAttachDataHolder.getProjectAttachData((IProject)project);
        SdkAttachStatusesHolder.INSTANCE.loadAvailableSDKsAttachStates(project);
        Map sdksAttachStates = SdkAttachStatusesHolder.INSTANCE.getActualSdksAttachStatesCopy(project);
        return SdkAttachmentChangeHandler.checkSdksForAttach(sdksAttachStates, project);
    }

    private static Collection<SdkDescriptor> getAttachableSdks(Collection<SdkDescriptor> filteredSdks) {
        return filteredSdks.stream().filter(arg_0 -> ((SdkAttachStatusesHolder)SdkAttachStatusesHolder.INSTANCE).isSdkAttachable(arg_0)).collect(Collectors.toList());
    }
}

